/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.gclass;

import ghidra.app.util.SymbolPath;
import ghidra.program.model.data.CategoryPath;
import java.util.Objects;

public class ClassID
implements Comparable<ClassID> {
    private final SymbolPath symbolPath;
    private final CategoryPath categoryPath;
    static final int classNameHash = Objects.hash(ClassID.class.getName());

    public ClassID(CategoryPath categoryPath, SymbolPath symbolPath) {
        this.categoryPath = categoryPath;
        this.symbolPath = symbolPath;
    }

    public CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    public SymbolPath getSymbolPath() {
        return this.symbolPath;
    }

    public String toString() {
        return String.format("%s --- %s", this.categoryPath, this.symbolPath);
    }

    @Override
    public int compareTo(ClassID o) {
        int ret = this.symbolPath.compareTo(o.symbolPath);
        if (ret != 0) {
            return ret;
        }
        return this.categoryPath.compareTo(o.categoryPath);
    }

    public int hashCode() {
        return Objects.hash(this.categoryPath, this.symbolPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassID other = (ClassID)obj;
        return Objects.equals(this.categoryPath, other.categoryPath) && Objects.equals(this.symbolPath, other.symbolPath);
    }
}

