/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AbstractUnsignedIntegerDataType;
import ghidra.program.model.data.ColorIcon;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import java.awt.Color;
import java.math.BigInteger;
import java.util.List;

public abstract class AbstractColorDataType
extends AbstractUnsignedIntegerDataType {
    private static Settings rgbValueSettings = new SettingsImpl();

    public AbstractColorDataType(String name, DataTypeManager dtm) {
        super(name, dtm);
    }

    @Override
    public AbstractIntegerDataType getOppositeSignednessDataType() {
        Msg.error((Object)this, (Object)("Unsupported method use for " + this.getClass().getName()), (Throwable)new UnsupportedOperationException());
        return this;
    }

    @Override
    public final Class<?> getValueClass(Settings settings) {
        return ColorIcon.class;
    }

    @Override
    public final String getRepresentation(MemBuffer buf, Settings settings, int length) {
        int size = this.getLength();
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return "??";
        }
        BigInteger value = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf)).getBigInteger(bytes, size, true);
        String valueRep = AbstractColorDataType.getRepresentation(value, rgbValueSettings, 8 * size, false);
        StringBuilder strbuf = new StringBuilder();
        strbuf.append(this.getEncodingName(settings));
        strbuf.append(" ");
        strbuf.append(valueRep);
        strbuf.append(" {");
        int cnt = 0;
        for (ComponentValue compValue : this.getComponentValues(buf, settings)) {
            if (cnt++ != 0) {
                strbuf.append(",");
            }
            strbuf.append(compValue.getRepresentation(settings));
        }
        strbuf.append("}");
        return strbuf.toString();
    }

    protected abstract String getEncodingName(Settings var1);

    protected abstract List<ComponentValue> getComponentValues(MemBuffer var1, Settings var2);

    @Override
    public ColorIcon getValue(MemBuffer buf, Settings settings, int length) {
        int size = this.getLength();
        if (size < 1 || size > 8) {
            throw new AssertionError((Object)("Unsupported length: " + size));
        }
        byte[] bytes = new byte[size];
        if (buf.getBytes(bytes, 0) != size) {
            return null;
        }
        return new ColorIcon(this.decodeColor(buf, settings));
    }

    protected abstract Color decodeColor(MemBuffer var1, Settings var2);

    protected static int getFieldValue(long fullValue, int rightShift, int finalMask) {
        return (int)(fullValue >>> rightShift) & finalMask;
    }

    protected static int scaleFieldValue(int value, int bitSize) {
        return value * 255 / ((1 << bitSize) - 1);
    }

    static {
        PADDING.setPadded(rgbValueSettings, true);
    }

    protected record ComponentValue(String name, int value, int bitLength) {
        String getRepresentation(Settings settings) {
            BigInteger bigValue = BigInteger.valueOf(Integer.toUnsignedLong(this.value));
            return this.name + ":" + AbstractIntegerDataType.getRepresentation(bigValue, settings, this.bitLength, false);
        }
    }
}

