/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ConstrainedForwardRecordIterator;
import db.ConvertedRecordIterator;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class SymbolDatabaseAdapterV3
extends SymbolDatabaseAdapter {
    static final int SYMBOL_VERSION = 3;
    private static final long MIN_ADDRESS_OFFSET = 0L;
    private static final long MAX_ADDRESS_OFFSET = -1L;
    private static final int V3_SYMBOL_NAME_COL = 0;
    private static final int V3_SYMBOL_ADDR_COL = 1;
    private static final int V3_SYMBOL_PARENT_ID_COL = 2;
    private static final int V3_SYMBOL_TYPE_COL = 3;
    private static final int V3_SYMBOL_STRING_DATA_COL = 4;
    private static final int V3_SYMBOL_FLAGS_COL = 5;
    private static final int V3_SYMBOL_HASH_COL = 6;
    private static final int V3_SYMBOL_PRIMARY_COL = 7;
    private static final int V3_SYMBOL_DATATYPE_COL = 8;
    private static final int V3_SYMBOL_VAROFFSET_COL = 9;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV3(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap;
        this.symbolTable = handle.getTable("Symbols");
        if (this.symbolTable == null) {
            throw new VersionException("Missing Table: Symbols");
        }
        if (this.symbolTable.getSchema().getVersion() != 3) {
            int version = this.symbolTable.getSchema().getVersion();
            if (version < 3) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    DBRecord createSymbolRecord(String name, long namespaceID, Address address, SymbolType symbolType, boolean isPrimary, SourceType source) {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return false;
        }
        return this.symbolTable.hasRecord((Field)new LongField(key), 1);
    }

    @Override
    Field[] getSymbolIDs(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return Field.EMPTY_ARRAY;
        }
        return this.symbolTable.findRecords((Field)new LongField(key), 1);
    }

    @Override
    DBRecord getSymbolRecord(long symbolID) throws IOException {
        return this.convertV3Record(this.symbolTable.getRecord(symbolID));
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, forward));
        return new V3ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, startAddr, forward));
        return new V3ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    void updateSymbolRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return new V3ConvertedRecordIterator(this.symbolTable.iterator());
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, start, end, forward));
        return new V3ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    RecordIterator getSymbols(AddressSetView set, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward));
        return new V3ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    protected RecordIterator getPrimarySymbols(AddressSetView set, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 6, this.addrMap, set, forward));
        return new V3ConvertedRecordIterator((RecordIterator)it);
    }

    @Override
    protected DBRecord getPrimarySymbol(Address address) throws IOException {
        AddressIndexPrimaryKeyIterator it = new AddressIndexPrimaryKeyIterator(this.symbolTable, 6, this.addrMap, address, address, true);
        if (it.hasNext()) {
            return this.convertV3Record(this.symbolTable.getRecord(it.next()));
        }
        return null;
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    private String getExternalStringData(DBRecord rec) {
        long addrKey = rec.getLongValue(1);
        Address addr = this.addrMap.decodeAddress(addrKey);
        if (addr == null || !addr.isExternalAddress()) {
            return null;
        }
        byte symbolTypeId = rec.getByteValue(3);
        if (symbolTypeId != SYMBOL_TYPE_FUNCTION && symbolTypeId != SYMBOL_TYPE_LABEL) {
            return null;
        }
        return rec.getString(4);
    }

    @Override
    RecordIterator getExternalSymbolsByMemoryAddress(Address extProgAddr) throws IOException {
        if (extProgAddr == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        String matchAddrStr = extProgAddr.toString();
        return new ConstrainedForwardRecordIterator(this.symbolTable.iterator(), rec -> {
            String str = this.getExternalStringData((DBRecord)rec);
            if (str != null) {
                String addressString;
                int indexOf = str.indexOf(",");
                String string = addressString = indexOf >= 0 ? str.substring(0, indexOf) : str;
                if (matchAddrStr.equals(addressString)) {
                    return this.convertV3Record((DBRecord)rec);
                }
            }
            return null;
        });
    }

    @Override
    RecordIterator getExternalSymbolsByOriginalImportName(String extLabel) throws IOException {
        if (StringUtils.isBlank((CharSequence)extLabel)) {
            return EmptyRecordIterator.INSTANCE;
        }
        return new ConstrainedForwardRecordIterator(this.symbolTable.iterator(), rec -> {
            String str = this.getExternalStringData((DBRecord)rec);
            if (str != null) {
                String originalImportedName;
                int indexOf = str.indexOf(",");
                String string = originalImportedName = indexOf >= 0 ? str.substring(indexOf + 1) : null;
                if (extLabel.equals(originalImportedName)) {
                    return this.convertV3Record((DBRecord)rec);
                }
            }
            return null;
        });
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        LongField field = new LongField(id);
        RecordIterator it = this.symbolTable.indexIterator(2, (Field)field, (Field)field, true);
        return new V3ConvertedRecordIterator(it);
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField field = new StringField(name);
        RecordIterator it = this.symbolTable.indexIterator(0, (Field)field, (Field)field, true);
        return new V3ConvertedRecordIterator(it);
    }

    @Override
    RecordIterator scanSymbolsByName(String startName) throws IOException {
        StringField field = new StringField(startName);
        RecordIterator it = this.symbolTable.indexIterator(0, (Field)field, null, true);
        return new V3ConvertedRecordIterator(it);
    }

    @Override
    RecordIterator getSymbolsByNameAndNamespace(String name, long id) throws IOException {
        LongField start = SymbolDatabaseAdapterV3.computeLocatorHash(name, id, 0L);
        if (start == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        LongField end = SymbolDatabaseAdapterV3.computeLocatorHash(name, id, -1L);
        Object it = this.symbolTable.indexIterator(5, (Field)start, (Field)end, true);
        it = new V3ConvertedRecordIterator((RecordIterator)it);
        RecordIterator filtered = SymbolDatabaseAdapterV3.getNameAndNamespaceFilterIterator(name, id, it);
        return new V3ConvertedRecordIterator(filtered);
    }

    @Override
    DBRecord getSymbolRecord(Address address, String name, long namespaceId) throws IOException {
        long addressKey = this.addrMap.getKey(address, false);
        LongField search = SymbolDatabaseAdapterV3.computeLocatorHash(name, namespaceId, addressKey);
        if (search == null) {
            return null;
        }
        Object it = this.symbolTable.indexIterator(5, (Field)search, (Field)search, true);
        RecordIterator filtered = SymbolDatabaseAdapterV3.getNameNamespaceAddressFilterIterator(name, namespaceId, addressKey, it = new V3ConvertedRecordIterator((RecordIterator)it));
        if (filtered.hasNext()) {
            return filtered.next();
        }
        return null;
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        if (space.isMemorySpace()) {
            AddressIndexKeyIterator addressKeyIterator = new AddressIndexKeyIterator(this.symbolTable, 1, this.addrMap, space.getMinAddress(), space.getMaxAddress(), false);
            if (addressKeyIterator.hasNext()) {
                return this.addrMap.decodeAddress(addressKeyIterator.next());
            }
        } else {
            LongField val;
            Address addr;
            LongField max = new LongField(this.addrMap.getKey(space.getMaxAddress(), false));
            DBFieldIterator iterator = this.symbolTable.indexFieldIterator(null, (Field)max, false, 1);
            if (iterator.hasPrevious() && space.equals((addr = this.addrMap.decodeAddress((val = (LongField)iterator.previous()).getLongValue())).getAddressSpace())) {
                return addr;
            }
        }
        return null;
    }

    @Override
    Table getTable() {
        return this.symbolTable;
    }

    private DBRecord convertV3Record(DBRecord record) {
        Field varOffset;
        Field dataTypeId;
        Field primaryAddr;
        if (record == null) {
            return null;
        }
        DBRecord rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(record.getKey());
        String symbolName = record.getString(0);
        rec.setString(0, symbolName);
        long symbolAddrKey = record.getLongValue(1);
        rec.setLongValue(1, symbolAddrKey);
        long namespaceId = record.getLongValue(2);
        rec.setLongValue(2, namespaceId);
        byte symbolTypeId = record.getByteValue(3);
        rec.setByteValue(3, symbolTypeId);
        rec.setByteValue(4, record.getByteValue(5));
        SymbolDatabaseAdapterV3.convertSymbolStringData(symbolTypeId, rec, record.getString(4));
        Field hash = record.getFieldValue(6);
        if (hash != null) {
            rec.setField(5, hash);
        }
        if ((primaryAddr = record.getFieldValue(7)) != null) {
            rec.setField(6, primaryAddr);
        }
        if ((dataTypeId = record.getFieldValue(8)) != null) {
            rec.setField(7, dataTypeId);
        }
        if ((varOffset = record.getFieldValue(9)) != null) {
            rec.setField(8, varOffset);
        }
        return rec;
    }

    static void convertSymbolStringData(byte symbolTypeId, DBRecord record, String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        if (symbolTypeId == SYMBOL_TYPE_LABEL || symbolTypeId == SYMBOL_TYPE_FUNCTION) {
            int indexOf = str.indexOf(",");
            String originalImportedName = indexOf >= 0 ? str.substring(indexOf + 1) : null;
            String addressString = indexOf >= 0 ? str.substring(0, indexOf) : str;
            record.setString(10, addressString);
            record.setString(9, originalImportedName);
        } else if (symbolTypeId == SYMBOL_TYPE_LOCAL_VAR || symbolTypeId == SYMBOL_TYPE_PARAMETER) {
            record.setString(11, str);
        } else if (symbolTypeId == SYMBOL_TYPE_LIBRARY) {
            record.setString(12, str);
        }
    }

    private class V3ConvertedRecordIterator
    extends ConvertedRecordIterator {
        V3ConvertedRecordIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected DBRecord convertRecord(DBRecord record) {
            return SymbolDatabaseAdapterV3.this.convertV3Record(record);
        }
    }
}

