/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.util.ArrayList;
import java.util.Objects;
import javax.help.UnsupportedOperationException;

public abstract class MemorySymbol
extends SymbolDB {
    protected MemorySymbol(SymbolManager mgr, DBObjectCache<SymbolDB> cache, Address addr, DBRecord record) {
        super(mgr, cache, addr, record);
        if (!addr.isMemoryAddress() && !this.isExternal()) {
            throw new IllegalArgumentException("memory or external address required");
        }
    }

    protected MemorySymbol(SymbolManager mgr, DBObjectCache<SymbolDB> cache, Address addr, long key) {
        super(mgr, cache, addr, key);
        if (!addr.isMemoryAddress()) {
            throw new IllegalArgumentException("memory address required");
        }
    }

    @Override
    public final boolean isExternalEntryPoint() {
        this.validate(this.lock);
        return this.symbolMgr.isExternalEntryPoint(this.address);
    }

    @Override
    public final boolean isExternal() {
        return this.address.isExternalAddress();
    }

    @Override
    public final boolean isPinned() {
        if (!this.isExternal()) {
            return this.doIsPinned();
        }
        return false;
    }

    @Override
    public final void setPinned(boolean pinned) {
        if (!this.isExternal()) {
            this.doSetPinned(pinned);
        }
    }

    private boolean doIsPinned() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                boolean bl = false;
                return bl;
            }
            byte flags = this.record.getByteValue(4);
            boolean bl = (flags & 4) != 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    private void doSetPinned(boolean pinned) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (pinned == this.isPinned()) {
                return;
            }
            if (this.record != null) {
                this.updatePinnedFlag(pinned);
                this.updateRecord();
                this.symbolMgr.symbolAnchoredFlagChanged(this);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void updatePinnedFlag(boolean pinned) {
        byte flags = this.record.getByteValue(4);
        flags = pinned ? (byte)(flags | 4) : (byte)(flags & 0xFFFFFFFB);
        this.record.setByteValue(4, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveLowLevel(Address newAddress, String newName, Namespace newNamespace, SourceType newSource, boolean pinned) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            long newAddressKey = this.symbolMgr.getAddressMap().getKey(newAddress, true);
            this.record.setLongValue(1, newAddressKey);
            if (this.record.getFieldValue(6) != null) {
                this.record.setLongValue(6, newAddressKey);
            }
            if (newName != null) {
                this.record.setString(0, newName);
            }
            if (newNamespace != null) {
                this.record.setLongValue(2, newNamespace.getID());
            }
            if (newSource != null) {
                this.setSourceFlagBit(newSource);
            }
            this.updatePinnedFlag(pinned);
            this.updateRecord();
            this.setInvalid();
        }
        finally {
            this.lock.release();
        }
    }

    private boolean hasExactlyOneSymbolAtAddress(Address addr) {
        SymbolIterator it = this.symbolMgr.getSymbolsAsIterator(addr);
        if (!it.hasNext()) {
            return false;
        }
        it.next();
        return !it.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReferenceCount() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            if (this.address.isExternalAddress() || this.hasExactlyOneSymbolAtAddress(this.address)) {
                int n = rm.getReferenceCountTo(this.address);
                return n;
            }
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            int count = 0;
            boolean isPrimary = this.isPrimary();
            while (iter.hasNext()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L)) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasReferences() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            boolean isPrimary = this.isPrimary();
            while (iter.hasNext()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference[] getReferences(TaskMonitor monitor) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (monitor == null) {
                monitor = TaskMonitor.DUMMY;
            }
            if (monitor.getMaximum() == 0L) {
                monitor = new UnknownProgressWrappingTaskMonitor(monitor, 20L);
            }
            ReferenceDBManager rm = this.symbolMgr.getReferenceManager();
            ReferenceIterator iter = rm.getReferencesTo(this.address);
            boolean isPrimary = this.isPrimary();
            ArrayList<Reference> list = new ArrayList<Reference>();
            int cnt = 0;
            while (iter.hasNext() && !monitor.isCancelled()) {
                Reference ref = iter.next();
                long symbolID = ref.getSymbolID();
                if (symbolID != this.key && (!isPrimary || symbolID >= 0L)) continue;
                list.add(ref);
                monitor.setProgress((long)cnt++);
            }
            Reference[] refs = new Reference[list.size()];
            Reference[] referenceArray = list.toArray(refs);
            return referenceArray;
        }
        finally {
            this.lock.release();
        }
    }

    public final String getExternalOriginalImportedName() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                String string = null;
                return string;
            }
            String string = this.record.getString(9);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExternalOriginalImportedName(String originalImportedName, boolean notify) {
        SymbolType type = this.getSymbolType();
        if (!this.getAddress().isExternalAddress() || type != SymbolType.LABEL && type != SymbolType.FUNCTION) {
            throw new UnsupportedOperationException("Symbol does not support: originalImportedName");
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.record == null) {
                return;
            }
            String oldData = this.record.getString(9);
            if (!Objects.equals(originalImportedName, oldData)) {
                this.record.setString(9, originalImportedName);
                this.updateRecord();
                if (notify) {
                    this.symbolMgr.symbolDataChanged(this);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    public final Address getExternalProgramAddress() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                Address address = null;
                return address;
            }
            String addrStr = this.record.getString(10);
            if (addrStr == null) {
                Address address = null;
                return address;
            }
            Address address = this.symbolMgr.getAddressMap().getAddressFactory().getAddress(addrStr);
            return address;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setExternalProgramAddress(Address externalProgramAddress, boolean notify) {
        SymbolType type = this.getSymbolType();
        if (!this.getAddress().isExternalAddress() || type != SymbolType.LABEL && type != SymbolType.FUNCTION) {
            throw new UnsupportedOperationException("Symbol does not support: external program address");
        }
        if (externalProgramAddress != null && !externalProgramAddress.isLoadedMemoryAddress()) {
            throw new IllegalArgumentException("Memory address required for external program");
        }
        this.lock.acquire();
        try {
            String oldData;
            this.checkDeleted();
            if (this.record == null) {
                return;
            }
            String addrStr = externalProgramAddress != null ? externalProgramAddress.toString() : null;
            if (!Objects.equals(addrStr, oldData = this.record.getString(10))) {
                this.record.setString(10, addrStr);
                this.updateRecord();
                if (notify) {
                    this.symbolMgr.symbolDataChanged(this);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    static void setExternalFields(DBRecord record, String originalImportName, Address externalProgramAddress) {
        String addrStr = externalProgramAddress != null ? externalProgramAddress.toString() : null;
        record.setString(10, addrStr);
        record.setString(9, originalImportName);
    }
}

