/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.util.ErrorHandler;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.framework.Application;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.EventType;
import ghidra.framework.options.Options;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.LockException;
import ghidra.program.database.DBStringMapAdapter;
import ghidra.program.database.IntRangeMap;
import ghidra.program.database.IntRangeMapDB;
import ghidra.program.database.ListingDB;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ObsoleteProgramPropertiesService;
import ghidra.program.database.OverlaySpaceDBAdapter;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramCompilerSpec;
import ghidra.program.database.ProgramDBChangeSet;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.database.ProgramUserDataDB;
import ghidra.program.database.SpecExtension;
import ghidra.program.database.bookmark.BookmarkDBManager;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.code.InstructionDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.module.TreeManager;
import ghidra.program.database.oldfunction.OldFunctionManager;
import ghidra.program.database.properties.DBPropertyMapManager;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.register.ProgramRegisterContextDB;
import ghidra.program.database.reloc.RelocationManager;
import ghidra.program.database.sourcemap.SourceFileManagerDB;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.database.util.AddressSetPropertyMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageVersionException;
import ghidra.program.model.lang.OldLanguageMappingService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.util.ChangeManager;
import ghidra.program.util.CodeUnitPropertyChangeRecord;
import ghidra.program.util.CodeUnitUserDataChangeRecord;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.FunctionChangeRecord;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.LanguageTranslatorFactory;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramUtilities;
import ghidra.program.util.UserDataChangeRecord;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.RollbackException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ProgramDB
extends DomainObjectAdapterDB
implements Program,
ChangeManager {
    public static final String CONTENT_TYPE = "Program";
    private static final String UNKNOWN = "unknown";
    static final int DB_VERSION = 30;
    private static final int UPGRADE_REQUIRED_BEFORE_VERSION = 19;
    public static final int ANALYSIS_OPTIONS_MOVED_VERSION = 9;
    public static final int ADDED_VARIABLE_STORAGE_MANAGER_VERSION = 10;
    public static final int METADATA_ADDED_VERSION = 11;
    public static final int EXTERNAL_FUNCTIONS_ADDED_VERSION = 17;
    public static final int COMPOUND_VARIABLE_STORAGE_ADDED_VERSION = 18;
    public static final int AUTO_PARAMETERS_ADDED_VERSION = 19;
    public static final int RELOCATION_STATUS_ADDED_VERSION = 26;
    private static final String DATA_MAP_TABLE_NAME = "Program";
    private static final String PROGRAM_NAME = "Program Name";
    private static final String PROGRAM_DB_VERSION = "DB Version";
    private static final String LANGUAGE_VERSION = "Language Version";
    private static final String OLD_LANGUAGE_NAME = "Language Name";
    private static final String LANGUAGE_ID = "Language ID";
    private static final String COMPILER_SPEC_ID = "Compiler Spec ID";
    private static final String COMPILER = "Compiler";
    private static final String EXECUTABLE_PATH = "Executable Location";
    private static final String EXECUTABLE_FORMAT = "Executable Format";
    private static final String EXECUTABLE_MD5 = "Executable MD5";
    private static final String EXECUTABLE_SHA256 = "Executable SHA256";
    private static final String EXECUTE_PATH = "Execute Path";
    private static final String EXECUTE_FORMAT = "Execute Format";
    private static final String IMAGE_OFFSET = "Image Offset";
    private static final int MEMORY_MGR = 0;
    private static final int CODE_MGR = 1;
    private static final int SYMBOL_MGR = 2;
    private static final int NAMESPACE_MGR = 3;
    private static final int FUNCTION_MGR = 4;
    private static final int EXTERNAL_MGR = 5;
    private static final int REF_MGR = 6;
    private static final int DATA_MGR = 7;
    private static final int EQUATE_MGR = 8;
    private static final int BOOKMARK_MGR = 9;
    private static final int CONTEXT_MGR = 10;
    private static final int PROPERTY_MGR = 11;
    private static final int TREE_MGR = 12;
    private static final int RELOC_MGR = 13;
    private static final int SOURCE_FILE_MGR = 14;
    private static final int NUM_MANAGERS = 15;
    private ManagerDB[] managers = new ManagerDB[15];
    private OldFunctionManager oldFunctionMgr;
    private MemoryMapDB memoryManager;
    private GlobalNamespace globalNamespace;
    private boolean changeable = true;
    private ProgramAddressFactory addressFactory;
    private AddressMapDB addrMap;
    private ListingDB listing;
    private ProgramUserDataDB programUserData;
    private DBStringMapAdapter dataMap;
    private Language language;
    private CompilerSpec compilerSpec;
    private boolean languageUpgradeRequired;
    private LanguageID languageID;
    private CompilerSpecID compilerSpecID;
    private int languageVersion;
    private int languageMinorVersion;
    private LanguageTranslator languageUpgradeTranslator;
    private boolean imageBaseOverride = false;
    private Address effectiveImageBase = null;
    private boolean recordChanges;
    private OverlaySpaceDBAdapter overlaySpaceAdapter;
    private Map<String, AddressSetPropertyMapDB> addrSetPropertyMap = new HashMap<String, AddressSetPropertyMapDB>();
    private Map<String, IntRangeMapDB> intRangePropertyMap = new HashMap<String, IntRangeMapDB>();
    private static final String PREFERRED_ROOT_NAMESPACE_CATEGORY_PROPERTY_PATHNAME = "Program Information.Preferred Root Namespace Category";
    private CategoryPath preferredRootNamespaceCategory;

    public ProgramDB(String name, Language language, CompilerSpec compilerSpec, Object consumer) throws IOException {
        super(new DBHandle(), name, 500, consumer);
        if (!(compilerSpec instanceof BasicCompilerSpec)) {
            throw new IllegalArgumentException("unsupported compilerSpec: " + compilerSpec.getClass().getName());
        }
        this.language = language;
        this.compilerSpec = ProgramCompilerSpec.getProgramCompilerSpec(this, compilerSpec);
        this.languageID = language.getLanguageID();
        this.compilerSpecID = compilerSpec.getCompilerSpecID();
        this.languageVersion = language.getVersion();
        this.languageMinorVersion = language.getMinorVersion();
        this.addressFactory = new ProgramAddressFactory(language, compilerSpec, s -> this.getDefinedAddressSet(s));
        this.recordChanges = false;
        boolean success = false;
        try {
            int id = this.startTransaction("create program");
            this.createProgramInfo();
            if (this.createManagers(OpenMode.CREATE, TaskMonitor.DUMMY) != null) {
                throw new AssertException("Unexpected version exception on create");
            }
            this.listing = new ListingDB();
            this.changeSet = new ProgramDBChangeSet(this.addrMap, 50);
            this.initManagers(OpenMode.CREATE, TaskMonitor.DUMMY);
            this.createProgramInformationOptions();
            this.programUserData = new ProgramUserDataDB(this);
            this.endTransaction(id, true);
            this.clearUndo(false);
            this.registerCompilerSpecOptions();
            this.getCodeManager().activateContextLocking();
            success = true;
        }
        catch (CancelledException e) {
            throw new AssertException();
        }
        finally {
            this.dbh.closeScratchPad();
            if (!success) {
                this.release(consumer);
                this.dbh.close();
            }
        }
        ProgramUtilities.addTrackedProgram(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramDB(DBHandle dbh, OpenMode openMode, TaskMonitor monitor, Object consumer) throws IOException, VersionException, LanguageNotFoundException, CancelledException {
        super(dbh, "Untitled", 500, consumer);
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        if (openMode == null || openMode == OpenMode.CREATE) {
            throw new IllegalArgumentException("invalid openMode: " + String.valueOf(openMode));
        }
        boolean success = false;
        try {
            int id = this.startTransaction("create program");
            this.recordChanges = false;
            this.changeable = openMode != OpenMode.IMMUTABLE;
            VersionException dbVersionExc = this.initializeProgramInfo(openMode);
            LanguageVersionException languageVersionExc = null;
            try {
                this.language = DefaultLanguageService.getLanguageService().getLanguage(this.languageID);
                languageVersionExc = LanguageVersionException.check(this.language, this.languageVersion, this.languageMinorVersion);
            }
            catch (LanguageNotFoundException e) {
                languageVersionExc = LanguageVersionException.checkForLanguageChange(e, this.languageID, this.languageVersion);
            }
            if (languageVersionExc != null) {
                this.languageUpgradeRequired = true;
                this.languageUpgradeTranslator = languageVersionExc.getLanguageTranslator();
                if (this.languageUpgradeTranslator != null) {
                    this.language = languageVersionExc.getOldLanguage();
                    this.languageVersion = this.language.getVersion();
                    this.languageMinorVersion = this.language.getMinorVersion();
                }
            }
            this.initCompilerSpec();
            this.addressFactory = new ProgramAddressFactory(this.language, this.compilerSpec, s -> this.getDefinedAddressSet(s));
            VersionException versionExc = this.createManagers(openMode, monitor);
            if (dbVersionExc != null) {
                versionExc = dbVersionExc.combine(versionExc);
            }
            if (languageVersionExc != null && openMode != OpenMode.UPGRADE) {
                versionExc = languageVersionExc.combine(versionExc);
            }
            if (versionExc != null) {
                throw versionExc;
            }
            this.listing = new ListingDB();
            this.changeSet = new ProgramDBChangeSet(this.addrMap, 50);
            this.initManagers(openMode, monitor);
            if (openMode == OpenMode.UPGRADE) {
                int oldVersion = this.getStoredVersion();
                this.upgradeDatabase(monitor);
                if (this.languageUpgradeRequired) {
                    try {
                        this.setLanguage(this.languageUpgradeTranslator, null, false, monitor);
                    }
                    catch (IllegalStateException e) {
                        if (e.getCause() instanceof CancelledException) {
                            throw (CancelledException)e.getCause();
                        }
                        throw e;
                    }
                    catch (LockException e) {
                        throw new AssertException("Upgrade mode requires exclusive access");
                    }
                    this.languageUpgradeRequired = false;
                }
                this.addressFactory.invalidateOverlayCache();
                this.postUpgrade(oldVersion, monitor);
                this.changed = true;
            }
            this.registerProgramInformationOptions();
            this.restoreProgramInformationOptions();
            this.recordChanges = true;
            this.endTransaction(id, true);
            this.clearUndo(false);
            SpecExtension.checkFormatVersion(this);
            this.installExtensions();
            this.registerCompilerSpecOptions();
            this.getCodeManager().activateContextLocking();
            success = true;
        }
        finally {
            dbh.closeScratchPad();
            if (!success) {
                this.release(consumer);
            }
        }
        if (openMode == OpenMode.IMMUTABLE) {
            this.setImmutable();
        }
        ProgramUtilities.addTrackedProgram(this);
    }

    private AddressSetView getDefinedAddressSet(AddressSpace s) {
        MemoryMapDB memory = this.getMemory();
        if (memory != null) {
            return memory.intersectRange(s.getMinAddress(), s.getMaxAddress());
        }
        return null;
    }

    public boolean isLanguageUpgradePending() {
        return this.languageUpgradeRequired;
    }

    private void initCompilerSpec() throws CompilerSpecNotFoundException {
        CompilerSpec langSpec;
        try {
            langSpec = this.languageUpgradeTranslator != null ? this.languageUpgradeTranslator.getOldCompilerSpec(this.compilerSpecID) : this.language.getCompilerSpecByID(this.compilerSpecID);
        }
        catch (CompilerSpecNotFoundException e) {
            Msg.error((Object)this, (Object)("Compiler Spec " + String.valueOf(this.compilerSpecID) + " for Language " + this.language.getLanguageDescription().getDescription() + " Not Found, using default: " + String.valueOf(e)));
            langSpec = this.language.getDefaultCompilerSpec();
            if (langSpec == null) {
                throw e;
            }
            this.compilerSpecID = langSpec.getCompilerSpecID();
        }
        this.compilerSpec = ProgramCompilerSpec.getProgramCompilerSpec(this, langSpec);
    }

    protected void setDomainFile(DomainFile df) {
        super.setDomainFile(df);
        this.recordChanges = true;
    }

    private void registerProgramInformationOptions() {
        Options pl = this.getOptions("Program Information");
        pl.registerOption(EXECUTABLE_PATH, (Object)UNKNOWN, null, "Original import path of program image");
        pl.registerOption(EXECUTABLE_FORMAT, (Object)UNKNOWN, null, "Original program image format");
        pl.registerOption("Created With Ghidra Version", (Object)"3.0 or earlier", null, "Version of Ghidra used to create this program.");
        pl.registerOption("Date Created", (Object)JANUARY_1_1970, null, "Date this program was created");
        pl.registerOption("Preferred Root Namespace Category", (Object)"", null, "Preferred data type category path of root namespace");
    }

    private void createProgramInformationOptions() {
        this.registerProgramInformationOptions();
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_PATH, UNKNOWN);
        pl.setString(EXECUTABLE_FORMAT, UNKNOWN);
        pl.setString("Created With Ghidra Version", Application.getApplicationVersion());
        pl.setDate("Date Created", new Date());
    }

    private void restoreProgramInformationOptions() {
        Options pl = this.getOptions("Program Information");
        this.updatePreferredRootNamespaceCategory(pl.getString("Preferred Root Namespace Category", null));
    }

    protected boolean propertyChanged(String propertyName, Object oldValue, Object newValue) {
        String path;
        if (propertyName.equals(PREFERRED_ROOT_NAMESPACE_CATEGORY_PROPERTY_PATHNAME) && !this.updatePreferredRootNamespaceCategory(path = (String)newValue)) {
            return false;
        }
        super.propertyChanged(propertyName, oldValue, newValue);
        return true;
    }

    private boolean updatePreferredRootNamespaceCategory(String path) {
        if (path != null) {
            path = path.trim();
        }
        this.preferredRootNamespaceCategory = null;
        if (!StringUtils.isBlank((CharSequence)path)) {
            try {
                this.preferredRootNamespaceCategory = new CategoryPath(path);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Ignoring invalid preferred root namespace category path: " + path));
                return false;
            }
        }
        return true;
    }

    void setProgramUserData(ProgramUserDataDB programUserData) {
        this.programUserData = programUserData;
    }

    @Override
    public ProgramUserData getProgramUserData() {
        if (this.programUserData == null) {
            try {
                this.programUserData = new ProgramUserDataDB(this);
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        return this.programUserData;
    }

    protected FileSystem getAssociatedUserFilesystem() {
        return super.getAssociatedUserFilesystem();
    }

    protected DomainObjectAdapterDB getUserData() {
        return this.programUserData;
    }

    @Override
    public Listing getListing() {
        return this.listing;
    }

    @Override
    public SymbolManager getSymbolTable() {
        return (SymbolManager)this.managers[2];
    }

    @Override
    public ExternalManagerDB getExternalManager() {
        return (ExternalManagerDB)this.managers[5];
    }

    @Override
    public EquateManager getEquateTable() {
        return (EquateManager)this.managers[8];
    }

    @Override
    public MemoryMapDB getMemory() {
        return this.memoryManager;
    }

    public NamespaceManager getNamespaceManager() {
        return (NamespaceManager)this.managers[3];
    }

    @Override
    public ReferenceDBManager getReferenceManager() {
        return (ReferenceDBManager)this.managers[6];
    }

    public CodeManager getCodeManager() {
        return (CodeManager)this.managers[1];
    }

    public TreeManager getTreeManager() {
        return (TreeManager)this.managers[12];
    }

    @Override
    public ProgramDataTypeManager getDataTypeManager() {
        return (ProgramDataTypeManager)this.managers[7];
    }

    @Override
    public FunctionManagerDB getFunctionManager() {
        return (FunctionManagerDB)this.managers[4];
    }

    @Override
    public BookmarkDBManager getBookmarkManager() {
        return (BookmarkDBManager)this.managers[9];
    }

    @Override
    public RelocationManager getRelocationTable() {
        return (RelocationManager)this.managers[13];
    }

    @Override
    public SourceFileManagerDB getSourceFileManager() {
        return (SourceFileManagerDB)this.managers[14];
    }

    @Override
    public String getCompiler() {
        String compiler = null;
        Options pl = this.getOptions("Program Information");
        compiler = pl.getString(COMPILER, UNKNOWN);
        return compiler == null ? UNKNOWN : compiler;
    }

    @Override
    public void setCompiler(String compiler) {
        Options pl = this.getOptions("Program Information");
        pl.setString(COMPILER, compiler);
    }

    @Override
    public CategoryPath getPreferredRootNamespaceCategoryPath() {
        return this.preferredRootNamespaceCategory;
    }

    @Override
    public void setPreferredRootNamespaceCategoryPath(String categoryPath) {
        Options pl = this.getOptions("Program Information");
        pl.setString("Preferred Root Namespace Category", categoryPath);
    }

    @Override
    public String getExecutablePath() {
        String path = null;
        Options pl = this.getOptions("Program Information");
        path = pl.getString(EXECUTABLE_PATH, UNKNOWN);
        return path == null ? UNKNOWN : path;
    }

    @Override
    public void setExecutablePath(String path) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_PATH, path);
    }

    @Override
    public String getExecutableFormat() {
        String format = null;
        try {
            Options pl = this.getOptions("Program Information");
            format = pl.getString(EXECUTABLE_FORMAT, (String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format == null ? UNKNOWN : format;
    }

    @Override
    public void setExecutableFormat(String format) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_FORMAT, format);
    }

    @Override
    public String getExecutableMD5() {
        String format = null;
        try {
            Options pl = this.getOptions("Program Information");
            format = pl.getString(EXECUTABLE_MD5, (String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format == null ? UNKNOWN : format;
    }

    @Override
    public void setExecutableMD5(String md5) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_MD5, md5);
    }

    @Override
    public String getExecutableSHA256() {
        String format = null;
        try {
            Options pl = this.getOptions("Program Information");
            format = pl.getString(EXECUTABLE_SHA256, (String)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return format == null ? UNKNOWN : format;
    }

    @Override
    public void setExecutableSHA256(String sha256) {
        Options pl = this.getOptions("Program Information");
        pl.setString(EXECUTABLE_SHA256, sha256);
    }

    @Override
    public Date getCreationDate() {
        Options pl = this.getOptions("Program Information");
        return pl.getDate("Date Created", new Date(0L));
    }

    @Override
    public int getDefaultPointerSize() {
        return this.compilerSpec.getDataOrganization().getPointerSize();
    }

    @Override
    public LanguageID getLanguageID() {
        return this.languageID;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    @Override
    public PropertyMapManager getUsrPropertyManager() {
        return (PropertyMapManager)((Object)this.managers[11]);
    }

    @Override
    public ProgramContext getProgramContext() {
        return (ProgramContext)((Object)this.managers[10]);
    }

    @Override
    public Address getMinAddress() {
        return this.memoryManager.getMinAddress();
    }

    @Override
    public Address getMaxAddress() {
        return this.memoryManager.getMaxAddress();
    }

    @Override
    public ProgramChangeSet getChanges() {
        return (ProgramChangeSet)this.changeSet;
    }

    @Override
    public ProgramAddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    @Override
    public AddressMapDB getAddressMap() {
        return this.addrMap;
    }

    @Override
    public Address[] parseAddress(String addrStr) {
        return this.parseAddress(addrStr, true);
    }

    @Override
    public Address[] parseAddress(String addrStr, boolean caseSensitive) {
        int pos = addrStr.lastIndexOf(":");
        if (pos >= 0) {
            MemoryBlock[] blocks;
            String spaceName = addrStr.substring(0, pos);
            if (spaceName.endsWith(":")) {
                spaceName = spaceName.substring(0, spaceName.length() - 1);
            }
            String offsetStr = addrStr.substring(pos + 1);
            for (MemoryBlock block : blocks = this.memoryManager.getBlocks()) {
                if (!StringUtilities.equals((String)spaceName, (String)block.getName(), (boolean)caseSensitive)) continue;
                try {
                    Address addr = block.getStart().getAddress(offsetStr);
                    if (addr == null || !block.contains(addr)) continue;
                    return new Address[]{addr};
                }
                catch (AddressFormatException e) {
                    return new Address[0];
                }
            }
        }
        if (addrStr.endsWith("h")) {
            addrStr = addrStr.substring(0, addrStr.length() - 1);
        }
        return this.addressFactory.getAllAddresses(addrStr, caseSensitive);
    }

    public void dataTypeChanged(long dataTypeID, ProgramEvent eventType, boolean isAutoChange, Object oldValue, Object newValue) {
        if (this.recordChanges && !isAutoChange) {
            ((ProgramDBChangeSet)this.changeSet).dataTypeChanged(dataTypeID);
        }
        this.changed = true;
        try {
            this.managers[2].invalidateCache(true);
            this.managers[4].invalidateCache(true);
            this.managers[1].invalidateCache(true);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, null, oldValue, newValue));
    }

    public void dataTypeAdded(long dataTypeID, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).dataTypeAdded(dataTypeID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, null, oldValue, newValue));
    }

    public void categoryChanged(long categoryID, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).categoryChanged(categoryID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, null, oldValue, newValue));
    }

    public void categoryAdded(long categoryID, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).categoryAdded(categoryID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, null, oldValue, newValue));
    }

    public void sourceArchiveAdded(UniversalID sourceArchiveID, ProgramEvent eventType) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).sourceArchiveAdded(sourceArchiveID.getValue());
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, sourceArchiveID, null, null));
    }

    public void sourceArchiveChanged(UniversalID sourceArchiveID, ProgramEvent eventType) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).sourceArchiveChanged(sourceArchiveID.getValue());
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, sourceArchiveID, null, null));
    }

    public void programTreeAdded(long id, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).programTreeAdded(id);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, null, oldValue, newValue));
    }

    public void programTreeChanged(long id, ProgramEvent eventType, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            ((ProgramDBChangeSet)this.changeSet).programTreeChanged(id);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, affectedObj, oldValue, newValue));
    }

    public void tagChanged(FunctionTag tag, ProgramEvent eventType, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            long tagID = tag.getId();
            ((ProgramDBChangeSet)this.changeSet).tagChanged(tagID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, tag, oldValue, newValue));
    }

    public void tagCreated(FunctionTag tag, ProgramEvent eventType) {
        if (this.recordChanges) {
            long tagID = tag.getId();
            ((ProgramDBChangeSet)this.changeSet).tagCreated(tagID);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, tag, null, null));
    }

    public void symbolChanged(Symbol symbol, ProgramEvent eventType, Address addr, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            Namespace parentNamespace;
            if (!symbol.isDynamic()) {
                long symbolID = symbol.getID();
                ((ProgramDBChangeSet)this.changeSet).symbolChanged(symbolID);
            }
            if (symbol instanceof VariableSymbolDB && (parentNamespace = symbol.getParentNamespace()) instanceof Function) {
                Function function = (Function)parentNamespace;
                Address entryPoint = function.getEntryPoint();
                this.updateChangeSet(entryPoint, entryPoint);
                this.fireEvent(new FunctionChangeRecord(function, null));
            }
            if (addr != null) {
                this.updateChangeSet(addr, addr);
            }
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, addr, addr, affectedObj, oldValue, newValue));
    }

    public void symbolAdded(Symbol symbol, ProgramEvent eventType, Address addr, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            if (!symbol.isDynamic()) {
                long symbolID = symbol.getID();
                ((ProgramDBChangeSet)this.changeSet).symbolAdded(symbolID);
            }
            if (symbol instanceof VariableSymbolDB) {
                long nameSpaceID = symbol.getParentNamespace().getID();
                Function function = this.getFunctionManager().getFunction(nameSpaceID);
                if (function != null) {
                    Address entryPoint = function.getEntryPoint();
                    this.updateChangeSet(entryPoint, entryPoint);
                    this.fireEvent(new FunctionChangeRecord(function, null));
                }
            }
            if (addr != null) {
                this.updateChangeSet(addr, addr);
            }
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, addr, addr, null, oldValue, newValue));
    }

    @Override
    public void setRegisterValuesChanged(Register register, Address start, Address end) {
        if (this.recordChanges) {
            if (register != null && register.isProcessorContext()) {
                this.updateChangeSet(start, end);
            } else {
                ((ProgramDBChangeSet)this.changeSet).addRegisterRange(start, end);
            }
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(ProgramEvent.REGISTER_VALUES_CHANGED, start, end, null, null, null));
    }

    @Override
    public void setChanged(ProgramEvent event, Object oldValue, Object newValue) {
        this.setChanged(event, null, null, oldValue, newValue);
    }

    public void setChanged(ProgramChangeRecord changeRecord) {
        if (this.recordChanges) {
            this.updateChangeSet(changeRecord.getStart(), changeRecord.getEnd());
        }
        this.changed = true;
        this.fireEvent(changeRecord);
    }

    @Override
    public void setChanged(ProgramEvent event, Address start, Address end, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(start, end);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(event, start, end, null, oldValue, newValue));
    }

    @Override
    public void setObjChanged(ProgramEvent eventType, Object affected, Object oldValue, Object newValue) {
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, null, null, affected, oldValue, newValue));
    }

    @Override
    public void setObjChanged(ProgramEvent eventType, Address addr, Object affectedObj, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(addr, addr);
        }
        this.changed = true;
        this.fireEvent(new ProgramChangeRecord(eventType, addr, addr, affectedObj, oldValue, newValue));
    }

    private void updateChangeSet(Address start, Address end) {
        ProgramDBChangeSet pcs = (ProgramDBChangeSet)this.changeSet;
        if (start != null) {
            pcs.addRange(start, end != null ? end : start);
        } else if (end != null) {
            pcs.addRange(end, end);
        }
    }

    @Override
    public void setPropertyChanged(String propertyName, Address codeUnitAddr, Object oldValue, Object newValue) {
        if (this.recordChanges) {
            this.updateChangeSet(codeUnitAddr, null);
        }
        this.changed = true;
        this.fireEvent(new CodeUnitPropertyChangeRecord(ProgramEvent.CODE_UNIT_PROPERTY_CHANGED, propertyName, codeUnitAddr, oldValue, newValue));
    }

    @Override
    public void setPropertyRangeRemoved(String propertyName, Address start, Address end) {
        if (this.recordChanges) {
            this.updateChangeSet(start, end);
        }
        this.changed = true;
        this.fireEvent(new CodeUnitPropertyChangeRecord(ProgramEvent.CODE_UNIT_PROPERTY_RANGE_REMOVED, propertyName, start, end));
    }

    void userDataChanged(String propertyName, Address codeUnitAddr, Object oldValue, Object newValue) {
        this.fireEvent(new CodeUnitUserDataChangeRecord(propertyName, codeUnitAddr, oldValue, newValue));
    }

    protected void userDataChanged(String propertyName, Object oldValue, Object newValue) {
        this.fireEvent(new UserDataChangeRecord(propertyName, this.name, this.name));
    }

    public void setName(String newName) {
        this.lock.acquire();
        try {
            if (this.name.equals(newName)) {
                return;
            }
            this.dataMap.put(PROGRAM_NAME, newName);
            this.getTreeManager().setProgramName(this.name, newName);
            super.setName(newName);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void refreshName() throws IOException {
        this.name = this.dataMap.get(PROGRAM_NAME);
    }

    private void refreshImageBase() throws IOException {
        Address currentImageBase;
        long baseOffset = this.getStoredBaseImageOffset();
        Address storedImageBase = this.addressFactory.getDefaultAddressSpace().getAddress(baseOffset);
        if (!this.imageBaseOverride && !(currentImageBase = this.getImageBase()).equals(storedImageBase)) {
            currentImageBase = storedImageBase;
            this.addrMap.setImageBase(currentImageBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramOverlayAddressSpace createOverlaySpace(String overlaySpaceName, AddressSpace baseSpace) throws IllegalStateException, DuplicateNameException, InvalidNameException, LockException {
        this.checkExclusiveAccess();
        if (!this.addressFactory.isValidOverlayBaseSpace(baseSpace)) {
            throw new IllegalArgumentException("Invalid address space for overlay: " + baseSpace.getName());
        }
        ProgramOverlayAddressSpace ovSpace = null;
        this.lock.acquire();
        try {
            if (this.imageBaseOverride) {
                throw new IllegalStateException("Overlay spaces may not be created while an image-base override is active");
            }
            ovSpace = this.overlaySpaceAdapter.createOverlaySpace(this.addressFactory, overlaySpaceName, baseSpace);
            this.setChanged(ProgramEvent.OVERLAY_SPACE_ADDED, overlaySpaceName, null);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return ovSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameOverlaySpace(String overlaySpaceName, String newName) throws NotFoundException, InvalidNameException, DuplicateNameException, LockException {
        this.lock.acquire();
        try {
            this.checkExclusiveAccess();
            AddressSpace space = this.addressFactory.getAddressSpace(overlaySpaceName);
            if (space == null || !(space instanceof ProgramOverlayAddressSpace)) {
                throw new NotFoundException("Overlay " + overlaySpaceName + " not found");
            }
            ProgramOverlayAddressSpace os = (ProgramOverlayAddressSpace)space;
            this.addressFactory.checkValidOverlaySpaceName(newName);
            if (this.overlaySpaceAdapter.renameOverlaySpace(overlaySpaceName, newName)) {
                os.setName(newName);
                this.addressFactory.overlaySpaceRenamed(overlaySpaceName, newName, true);
                this.addrMap.renameOverlaySpace(overlaySpaceName, newName);
                this.clearCache(true);
                this.setChanged(ProgramEvent.OVERLAY_SPACE_RENAMED, overlaySpaceName, newName);
                this.fireEvent(new DomainObjectChangeRecord((EventType)DomainObjectEvent.RESTORED));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOverlaySpace(String overlaySpaceName) throws LockException, NotFoundException {
        this.lock.acquire();
        try {
            this.checkExclusiveAccess();
            AddressSpace space = this.addressFactory.getAddressSpace(overlaySpaceName);
            if (space == null || !(space instanceof ProgramOverlayAddressSpace)) {
                throw new NotFoundException("Overlay " + overlaySpaceName + " not found");
            }
            ProgramOverlayAddressSpace os = (ProgramOverlayAddressSpace)space;
            if (!os.getOverlayAddressSet().isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.addressFactory.removeOverlaySpace(overlaySpaceName);
            this.overlaySpaceAdapter.removeOverlaySpace(overlaySpaceName);
            this.addrMap.deleteOverlaySpace(overlaySpaceName);
            this.clearCache(true);
            this.setChanged(ProgramEvent.OVERLAY_SPACE_REMOVED, overlaySpaceName, null);
            this.fireEvent(new DomainObjectChangeRecord((EventType)DomainObjectEvent.RESTORED));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    private long getStoredBaseImageOffset() throws IOException {
        String imageBaseStr = this.dataMap.get(IMAGE_OFFSET);
        if (imageBaseStr != null) {
            return new BigInteger(imageBaseStr, 16).longValue();
        }
        return 0L;
    }

    @Override
    public Address getImageBase() {
        if (this.effectiveImageBase != null) {
            return this.effectiveImageBase;
        }
        return this.addrMap.getImageBase();
    }

    @Deprecated
    public void setEffectiveImageBase(Address imageBase) {
        this.effectiveImageBase = imageBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImageBase(Address base, boolean commit) throws AddressOverflowException, LockException, IllegalStateException {
        if (commit) {
            this.checkExclusiveAccess();
        }
        this.lock.acquire();
        try {
            MemoryBlock[] blocks;
            Address currentImageBase = this.getImageBase();
            if (!(commit && this.imageBaseOverride || !base.equals(currentImageBase))) {
                return;
            }
            if (!this.addressFactory.getDefaultAddressSpace().equals(base.getAddressSpace())) {
                throw new IllegalArgumentException("Base address must be default space");
            }
            for (MemoryBlock block : blocks = this.getMemory().getBlocks()) {
                if (!block.getStart().hasSameAddressSpace(base)) continue;
                try {
                    long distanceFromBase = block.getStart().subtract(currentImageBase);
                    Address newStart = base.addWrap(distanceFromBase);
                    newStart.addNoWrap(block.getSize() - 1L);
                }
                catch (AddressOverflowException e) {
                    throw new AddressOverflowException("wrapped memory block: " + block.getName());
                }
            }
            Address oldBase = currentImageBase;
            this.addrMap.setImageBase(base);
            if (commit) {
                try {
                    this.dataMap.put(IMAGE_OFFSET, Long.toHexString(base.getOffset()));
                    this.imageBaseOverride = false;
                    this.setChanged(ProgramEvent.IMAGE_BASE_CHANGED, oldBase, base);
                    this.invalidate();
                    ((SymbolManager)this.managers[2]).imageBaseChanged(oldBase, base);
                    this.changed = true;
                }
                catch (IOException e) {
                    this.dbError(e);
                }
            } else {
                this.imageBaseOverride = true;
            }
            this.invalidate();
        }
        finally {
            this.lock.release();
        }
        ((TreeManager)this.managers[12]).imageBaseChanged(commit);
        this.flushEvents();
    }

    @Override
    public void restoreImageBase() {
        if (!this.imageBaseOverride) {
            return;
        }
        this.lock.acquire();
        try {
            this.imageBaseOverride = false;
            this.invalidate();
        }
        finally {
            this.lock.release();
        }
        ((TreeManager)this.managers[12]).imageBaseChanged(false);
        this.flushEvents();
    }

    public String getDescription() {
        return "Program";
    }

    private void createProgramInfo() throws IOException {
        this.dataMap = new DBStringMapAdapter(this.dbh, "Program", true);
        this.dataMap.put(PROGRAM_NAME, this.name);
        this.dataMap.put(OLD_LANGUAGE_NAME, this.languageID.getIdAsString());
        this.dataMap.put(LANGUAGE_ID, this.languageID.getIdAsString());
        this.dataMap.put(COMPILER_SPEC_ID, this.compilerSpecID.getIdAsString());
        this.dataMap.put(LANGUAGE_VERSION, this.languageVersion + "." + this.languageMinorVersion);
        this.dataMap.put(PROGRAM_DB_VERSION, Integer.toString(30));
    }

    private VersionException initializeProgramInfo(OpenMode openMode) throws IOException, VersionException, LanguageNotFoundException {
        int storedVersion;
        boolean requiresUpgrade = false;
        this.dataMap = new DBStringMapAdapter(this.dbh, "Program", false);
        this.name = this.dataMap.get(PROGRAM_NAME);
        String languageIdStr = this.dataMap.get(LANGUAGE_ID);
        if (languageIdStr == null) {
            String oldLanguageName = this.dataMap.get(OLD_LANGUAGE_NAME);
            LanguageCompilerSpecPair languageCompilerSpecPair = OldLanguageMappingService.lookupMagicString(oldLanguageName, false);
            if (languageCompilerSpecPair == null) {
                throw new LanguageNotFoundException(oldLanguageName);
            }
            this.languageID = languageCompilerSpecPair.languageID;
            this.compilerSpecID = languageCompilerSpecPair.compilerSpecID;
            if (openMode != OpenMode.UPGRADE) {
                requiresUpgrade = true;
            } else {
                this.dataMap.put(LANGUAGE_ID, this.languageID.getIdAsString());
                this.dataMap.put(COMPILER_SPEC_ID, this.compilerSpecID.getIdAsString());
            }
        } else {
            this.languageID = new LanguageID(languageIdStr);
            this.compilerSpecID = new CompilerSpecID(this.dataMap.get(COMPILER_SPEC_ID));
        }
        this.languageVersion = 1;
        this.languageMinorVersion = 0;
        String languageVersionStr = this.dataMap.get(LANGUAGE_VERSION);
        if (languageVersionStr != null) {
            try {
                String[] vs = languageVersionStr.split("\\.");
                this.languageVersion = Integer.parseInt(vs[0]);
                this.languageMinorVersion = Integer.parseInt(vs[1]);
            }
            catch (Exception vs) {
                // empty catch block
            }
        }
        if ((storedVersion = this.getStoredVersion()) > 30) {
            throw new VersionException(2, false);
        }
        if (openMode != OpenMode.UPGRADE && storedVersion < 19) {
            requiresUpgrade = true;
        }
        if (openMode == OpenMode.UPDATE && storedVersion < 30) {
            requiresUpgrade = true;
        }
        return requiresUpgrade ? new VersionException(true) : null;
    }

    private void upgradeDatabase(TaskMonitor monitor) throws IOException, CancelledException {
        this.performPropertyListAlterations(ObsoleteProgramPropertiesService.getObsoleteProgramProperties(), monitor);
        this.checkFunctionWrappedPointers(monitor);
        this.dataMap.put(PROGRAM_DB_VERSION, Integer.toString(30));
    }

    private void postUpgrade(int oldVersion, TaskMonitor monitor) throws CancelledException, IOException {
        if (oldVersion < 18) {
            this.getFunctionManager().initSignatureSource(monitor);
        } else if (oldVersion < 19) {
            this.getFunctionManager().removeExplicitThisParameters(monitor);
        }
    }

    public int getStoredVersion() throws IOException {
        String dbVersionDtr = this.dataMap.get(PROGRAM_DB_VERSION);
        if (dbVersionDtr != null) {
            try {
                return Integer.parseInt(dbVersionDtr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private void checkOldProperties(OpenMode openMode, TaskMonitor monitor) throws IOException, VersionException {
        int storedVersion;
        String exePath = this.dataMap.get(EXECUTE_PATH);
        if (exePath != null) {
            if (openMode == OpenMode.IMMUTABLE) {
                return;
            }
            if (openMode != OpenMode.UPGRADE) {
                throw new VersionException(true);
            }
            Options pl = this.getOptions("Program Information");
            pl.setString(EXECUTABLE_PATH, exePath);
            this.dataMap.put(EXECUTE_PATH, null);
            String exeFormat = this.dataMap.get(EXECUTE_FORMAT);
            if (exeFormat != null) {
                pl.setString(EXECUTABLE_FORMAT, exeFormat);
                this.dataMap.put(EXECUTE_FORMAT, null);
            }
        }
        if ((storedVersion = this.getStoredVersion()) < 9) {
            if (openMode == OpenMode.IMMUTABLE) {
                return;
            }
            if (openMode != OpenMode.UPGRADE) {
                throw new VersionException(true);
            }
            Options oldList = this.getOptions("Analysis");
            for (String propertyName : oldList.getOptionNames()) {
                oldList.removeOption(propertyName);
            }
        }
        if (storedVersion < 11) {
            if (openMode == OpenMode.IMMUTABLE) {
                return;
            }
            if (openMode != OpenMode.UPGRADE) {
                throw new VersionException(true);
            }
        }
    }

    private void checkFunctionWrappedPointers(TaskMonitor monitor) throws IOException, CancelledException {
        int storedVersion = this.getStoredVersion();
        if (storedVersion < 17) {
            FunctionManagerDB functionManager = this.getFunctionManager();
            SymbolManager symbolTable = this.getSymbolTable();
            monitor.setProgress(0L);
            monitor.setMaximum((long)functionManager.getFunctionCount());
            int cnt = 0;
            for (Symbol functionSymbol : symbolTable.getSymbols(this.memoryManager, SymbolType.FUNCTION, true)) {
                monitor.checkCancelled();
                ProgramUtilities.convertFunctionWrappedExternalPointer(functionSymbol);
                monitor.setProgress((long)(++cnt));
            }
        } else {
            return;
        }
    }

    private VersionException createManagers(OpenMode openMode, TaskMonitor monitor) throws CancelledException, IOException {
        VersionException versionExc = null;
        try {
            this.overlaySpaceAdapter = OverlaySpaceDBAdapter.getOverlaySpaceAdapter(this.dbh, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
            try {
                this.overlaySpaceAdapter = OverlaySpaceDBAdapter.getOverlaySpaceAdapter(this.dbh, OpenMode.IMMUTABLE, monitor);
            }
            catch (VersionException e1) {
                if (e1.isUpgradable()) {
                    throw new RuntimeException("OverlaySpaceDBAdapter is supported but failed to open as READ-ONLY!");
                }
                return versionExc;
            }
        }
        this.overlaySpaceAdapter.initializeOverlaySpaces(this.addressFactory);
        monitor.checkCancelled();
        try {
            this.checkOldProperties(openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        long baseImageOffset = this.getStoredBaseImageOffset();
        try {
            this.addrMap = new AddressMapDB(this.dbh, openMode, this.addressFactory, baseImageOffset, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
            try {
                this.addrMap = new AddressMapDB(this.dbh, OpenMode.IMMUTABLE, this.addressFactory, baseImageOffset, monitor);
            }
            catch (VersionException e1) {
                if (e1.isUpgradable()) {
                    Msg.error((Object)this, (Object)"AddressMapDB is upgradeable but failed to support READ-ONLY mode!");
                }
                return versionExc;
            }
        }
        monitor.checkCancelled();
        try {
            this.memoryManager = new MemoryMapDB(this.dbh, this.addrMap, openMode, this.language.isBigEndian(), this.lock, monitor);
            this.managers[0] = this.memoryManager;
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[1] = new CodeManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[4] = new FunctionManagerDB(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            if (!e.isUpgradable()) {
                try {
                    this.oldFunctionMgr = new OldFunctionManager(this.dbh, (ErrorHandler)this, this.addrMap);
                    if (openMode != OpenMode.UPGRADE) {
                        this.oldFunctionMgr = null;
                        versionExc = new VersionException(true).combine(versionExc);
                    }
                    this.managers[4] = new FunctionManagerDB(this.dbh, this.addrMap, OpenMode.CREATE, this.lock, monitor);
                }
                catch (VersionException versionException) {}
            }
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[5] = new ExternalManagerDB(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[2] = new SymbolManager(this.dbh, this.addrMap, openMode, (ErrorHandler)this, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[3] = new NamespaceManager(this.dbh, (ErrorHandler)this, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[6] = new ReferenceDBManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[8] = new EquateManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[7] = new ProgramDataTypeManager(this.dbh, this.addrMap, openMode, (ErrorHandler)this, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[11] = new DBPropertyMapManager(this.dbh, this, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[9] = new BookmarkDBManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[12] = new TreeManager(this.dbh, (ErrorHandler)this, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[13] = new RelocationManager(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        try {
            this.managers[10] = new ProgramRegisterContextDB(this.dbh, (ErrorHandler)this, this.language, this.compilerSpec, this.addrMap, this.lock, openMode, (CodeManager)this.managers[1], monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.managers[14] = new SourceFileManagerDB(this.dbh, this.addrMap, openMode, this.lock, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        monitor.checkCancelled();
        return versionExc;
    }

    private void initManagers(OpenMode openMode, TaskMonitor monitor) throws CancelledException, IOException {
        int i;
        this.globalNamespace = new GlobalNamespace(this.getMemory());
        for (i = 0; i < 15; ++i) {
            monitor.checkCancelled();
            this.managers[i].setProgram(this);
        }
        this.listing.setProgram(this);
        if (openMode == OpenMode.CREATE) {
            this.getDataTypeManager().saveDataOrganization();
        }
        monitor.checkCancelled();
        if (openMode == OpenMode.UPGRADE && this.oldFunctionMgr != null) {
            this.oldFunctionMgr.upgrade(this, monitor);
        }
        for (i = 0; i < 15; ++i) {
            monitor.checkCancelled();
            this.managers[i].programReady(openMode, this.getStoredVersion(), monitor);
        }
    }

    protected void clearCache(boolean all) {
        this.lock.acquire();
        try {
            super.clearCache(all);
            this.refreshName();
            this.overlaySpaceAdapter.updateOverlaySpaces(this.addressFactory);
            this.addrMap.invalidateCache();
            this.refreshImageBase();
            for (int i = 0; i < 15; ++i) {
                this.managers[i].invalidateCache(all);
            }
            this.restoreProgramInformationOptions();
            this.installExtensions();
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    @Override
    public Register getRegister(Address addr) {
        return this.language.getRegister(this.getGlobalAddress(addr), 0);
    }

    @Override
    public Register[] getRegisters(Address addr) {
        return this.language.getRegisters(this.getGlobalAddress(addr));
    }

    @Override
    public Register getRegister(Address addr, int size) {
        return this.language.getRegister(this.getGlobalAddress(addr), size);
    }

    @Override
    public Register getRegister(Varnode varnode) {
        return this.language.getRegister(this.getGlobalAddress(varnode.getAddress()), varnode.getSize());
    }

    private Address getGlobalAddress(Address addr) {
        if (addr instanceof OldGenericNamespaceAddress) {
            return ((OldGenericNamespaceAddress)addr).getGlobalAddress();
        }
        return addr;
    }

    @Override
    public Register getRegister(String regName) {
        return this.language.getRegister(regName);
    }

    protected void setChanged(boolean state) {
        super.setChanged(state);
        if (!state && !this.dbh.isChanged()) {
            this.languageUpgradeTranslator = null;
        }
    }

    void setChangeSet(ProgramDBChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws RollbackException {
        this.lock.acquire();
        try {
            for (int i = 14; i >= 0; --i) {
                this.managers[i].deleteAddressRange(startAddr, endAddr, monitor);
            }
            this.clearCache(false);
            Iterator<String> iter = this.addrSetPropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                AddressSetPropertyMapDB pm = this.addrSetPropertyMap.get(iter.next());
                pm.remove(startAddr, endAddr);
            }
            iter = this.intRangePropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                IntRangeMap map = this.intRangePropertyMap.get(iter.next());
                map.clearValue(startAddr, endAddr);
            }
        }
        catch (CancelledException e) {
            throw new RollbackException("Operation cancelled");
        }
        finally {
            this.lock.release();
        }
    }

    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, RollbackException {
        this.lock.acquire();
        try {
            for (int i = 14; i >= 0; --i) {
                this.managers[i].moveAddressRange(fromAddr, toAddr, length, monitor);
            }
            this.clearCache(false);
            Iterator<String> iter = this.addrSetPropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                AddressSetPropertyMapDB pm = this.addrSetPropertyMap.get(iter.next());
                pm.moveAddressRange(fromAddr, toAddr, length, monitor);
            }
            iter = this.intRangePropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                IntRangeMap map = this.intRangePropertyMap.get(iter.next());
                map.moveAddressRange(fromAddr, toAddr, length, monitor);
            }
        }
        catch (CancelledException e) {
            throw new RollbackException("Operation cancelled");
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    @Override
    public void setLanguage(Language newLanguage, CompilerSpecID newCompilerSpecID, boolean forceRedisassembly, TaskMonitor monitor) throws IllegalStateException, IncompatibleLanguageException, LockException {
        if (newLanguage == this.language) {
            this.setLanguage((LanguageTranslator)null, newCompilerSpecID, forceRedisassembly, monitor);
        } else {
            LanguageTranslator languageTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(this.language, newLanguage);
            if (languageTranslator == null) {
                throw new IncompatibleLanguageException("Language translation not supported");
            }
            this.setLanguage(languageTranslator, newCompilerSpecID, forceRedisassembly, monitor);
        }
        try {
            this.updateMetadata();
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLanguage(LanguageTranslator translator, CompilerSpecID newCompilerSpecID, boolean forceRedisassembly, TaskMonitor monitor) throws LockException {
        this.checkExclusiveAccess();
        this.lock.acquire();
        try {
            this.setEventsEnabled(false);
            try {
                boolean redisassemblyRequired = true;
                LanguageID oldLanguageId = this.languageID;
                int oldLanguageVersion = this.languageVersion;
                int oldLanguageMinorVersion = this.languageMinorVersion;
                if (translator != null) {
                    this.language = translator.getNewLanguage();
                    this.languageID = this.language.getLanguageID();
                    if (newCompilerSpecID == null) {
                        newCompilerSpecID = translator.getNewCompilerSpecID(this.compilerSpecID);
                    }
                    Msg.info((Object)this, (Object)("Setting language for Program " + this.getName() + ": " + String.valueOf(translator)));
                    Msg.info((Object)this, (Object)("Setting compiler spec for Program " + this.getName() + ": " + String.valueOf(this.compilerSpecID) + " -> " + String.valueOf(newCompilerSpecID)));
                } else if (!forceRedisassembly && this.language.getVersion() == this.languageVersion && this.language.getMinorVersion() == this.languageMinorVersion) {
                    redisassemblyRequired = false;
                    Msg.info((Object)this, (Object)("Setting compiler spec for Program " + this.getName() + ": " + String.valueOf(this.compilerSpecID) + " -> " + String.valueOf(newCompilerSpecID)));
                } else {
                    Msg.info((Object)this, (Object)("Updating language version for Program " + this.getName() + ": " + String.valueOf(this.language.getLanguageDescription()) + " (Version " + this.language.getVersion() + "." + this.language.getMinorVersion() + ")"));
                }
                if (newCompilerSpecID != null) {
                    this.compilerSpec = ProgramCompilerSpec.getProgramCompilerSpec(this, this.language.getCompilerSpecByID(newCompilerSpecID));
                    if (!(oldLanguageId.equals(this.languageID) && this.compilerSpecID.equals(newCompilerSpecID) || !(this.compilerSpec instanceof ProgramCompilerSpec))) {
                        ((ProgramCompilerSpec)this.compilerSpec).resetProgramOptions(monitor);
                    }
                }
                this.compilerSpecID = this.compilerSpec.getCompilerSpecID();
                this.languageVersion = this.language.getVersion();
                this.languageMinorVersion = this.language.getMinorVersion();
                if (translator != null) {
                    this.addressFactory = new ProgramAddressFactory(this.language, this.compilerSpec, s -> this.getDefinedAddressSet(s));
                    this.addrMap.setLanguage(this.language, this.addressFactory, translator);
                    this.overlaySpaceAdapter.setLanguage(this.language, this.addressFactory, translator);
                    this.memoryManager.setLanguage(this.language);
                    this.addrMap.memoryMapChanged(this.memoryManager);
                    monitor.setMessage("Updating symbols...");
                    this.getSymbolTable().setLanguage(translator, monitor);
                    this.getFunctionManager().setLanguage(translator, monitor);
                }
                this.clearCache(true);
                monitor.setMessage("Updating language...");
                monitor.setProgress(0L);
                ProgramRegisterContextDB contextMgr = (ProgramRegisterContextDB)this.getProgramContext();
                if (redisassemblyRequired) {
                    contextMgr.setLanguage(translator, this.compilerSpec, this.memoryManager, monitor);
                    this.repairContext(oldLanguageVersion, oldLanguageMinorVersion, translator, monitor);
                    this.getCodeManager().reDisassembleAllInstructions(monitor);
                } else {
                    contextMgr.initializeDefaultValues(this.language, this.compilerSpec);
                }
                this.getDataTypeManager().languageChanged(monitor);
                this.managers[4].setProgram(this);
                this.managers[4].programReady(OpenMode.UPDATE, this.getStoredVersion(), monitor);
                if (translator != null) {
                    translator.fixupInstructions(this, translator.getOldLanguage(), monitor);
                }
                this.dataMap.put(LANGUAGE_ID, this.languageID.getIdAsString());
                this.dataMap.put(COMPILER_SPEC_ID, this.compilerSpecID.getIdAsString());
                this.dataMap.put(LANGUAGE_VERSION, this.languageVersion + "." + this.languageMinorVersion);
                this.setChanged(true);
                this.clearCache(true);
                this.invalidate();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Set language aborted - program object is now in an unusable state!", t);
            }
            finally {
                this.setEventsEnabled(true);
            }
            this.fireEvent(new DomainObjectChangeRecord((EventType)ProgramEvent.LANGUAGE_CHANGED));
        }
        finally {
            this.lock.release();
        }
    }

    private void repairContext(int oldLanguageVersion, int oldLanguageMinorVersion, LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        String processorName = this.language.getProcessor().toString();
        if ("ARM".equalsIgnoreCase(processorName)) {
            this.repairARMContext(oldLanguageVersion, oldLanguageMinorVersion, translator, monitor);
        }
    }

    private void repairARMContext(int oldLanguageVersion, int oldLanguageMinorVersion, LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        if (!(this.language instanceof SleighLanguage)) {
            return;
        }
        if (oldLanguageVersion != 1 || oldLanguageMinorVersion >= 6) {
            return;
        }
        monitor.setMessage("Checking ARM Context...");
        CodeManager codeManager = this.getCodeManager();
        monitor.setMaximum((long)codeManager.getNumInstructions());
        monitor.setProgress(0L);
        int cnt = 0;
        int repairCnt = 0;
        ProgramContext context = this.getProgramContext();
        Register contextReg = context.getBaseContextRegister();
        if (contextReg == Register.NO_CONTEXT) {
            return;
        }
        Register thumbBitReg = context.getRegister("TMode");
        if (thumbBitReg == null) {
            return;
        }
        Register oldContextReg = contextReg;
        if (translator != null) {
            oldContextReg = translator.getOldContextRegister();
        }
        AddressRange contextRange = null;
        BigInteger lastStoredTMode = null;
        InstructionIterator instructions = codeManager.getInstructions(this.memoryManager.getLoadedAndInitializedAddressSet(), true);
        while (instructions.hasNext()) {
            monitor.checkCancelled();
            if (++cnt % 100 == 0) {
                monitor.setProgress((long)cnt);
            }
            InstructionDB instr = (InstructionDB)instructions.next();
            RegisterValue protoContextValue = instr.getOriginalPrototypeContext(oldContextReg);
            if (translator != null) {
                protoContextValue = translator.getNewRegisterValue(protoContextValue);
            }
            RegisterValue protoTModeValue = protoContextValue.getRegisterValue(thumbBitReg);
            BigInteger protoTMode = protoTModeValue.getUnsignedValue();
            Address addr = instr.getMinAddress();
            if (contextRange == null || !contextRange.contains(addr)) {
                contextRange = context.getRegisterValueRangeContaining(contextReg, addr);
                RegisterValue storedValue = context.getNonDefaultValue(contextReg, instr.getMinAddress());
                if (storedValue == null) {
                    lastStoredTMode = BigInteger.valueOf(0L);
                } else {
                    RegisterValue storedTModeValue = storedValue.getRegisterValue(thumbBitReg);
                    lastStoredTMode = storedTModeValue.getUnsignedValueIgnoreMask();
                }
            }
            if (protoTMode.equals(lastStoredTMode)) continue;
            try {
                context.setRegisterValue(addr, addr.add(instr.getLength() - 1), protoTModeValue);
                ++repairCnt;
            }
            catch (ContextChangeException e) {
                Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)((Object)e));
            }
            catch (AddressOutOfBoundsException e) {
                Msg.error((Object)this, (Object)("Unexpected instruction memory error at " + String.valueOf(instr.getMaxAddress())), (Throwable)e);
            }
        }
        if (repairCnt != 0) {
            Msg.warn((Object)this, (Object)("Repaired ARM Tmode context at " + repairCnt + " locations"));
        }
        this.clearCache(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetPropertyMap createAddressSetPropertyMap(String mapName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            AddressSetPropertyMapDB map = AddressSetPropertyMapDB.createPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            this.addrSetPropertyMap.put(mapName, map);
            this.setChanged(ProgramEvent.ADDRESS_PROPERTY_MAP_ADDED, null, mapName);
            AddressSetPropertyMapDB addressSetPropertyMapDB = map;
            return addressSetPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetPropertyMap getAddressSetPropertyMap(String mapName) {
        this.lock.acquire();
        try {
            AddressSetPropertyMapDB map = this.addrSetPropertyMap.get(mapName);
            if (map != null) {
                AddressSetPropertyMapDB addressSetPropertyMapDB = map;
                return addressSetPropertyMapDB;
            }
            map = AddressSetPropertyMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            if (map != null) {
                this.addrSetPropertyMap.put(mapName, map);
            }
            AddressSetPropertyMapDB addressSetPropertyMapDB = map;
            return addressSetPropertyMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void deleteAddressSetPropertyMap(String mapName) {
        this.lock.acquire();
        try {
            AddressSetPropertyMapDB pm = this.addrSetPropertyMap.remove(mapName);
            if (pm == null) {
                pm = AddressSetPropertyMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            }
            if (pm != null) {
                pm.delete();
                this.setChanged(ProgramEvent.ADDRESS_PROPERTY_MAP_REMOVED, null, mapName);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntRangeMapDB createIntRangeMap(String mapName) throws DuplicateNameException {
        this.lock.acquire();
        try {
            IntRangeMapDB map = IntRangeMapDB.createPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            this.intRangePropertyMap.put(mapName, map);
            this.setChanged(ProgramEvent.INT_PROPERTY_MAP_ADDED, null, mapName);
            IntRangeMapDB intRangeMapDB = map;
            return intRangeMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntRangeMap getIntRangeMap(String mapName) {
        this.lock.acquire();
        try {
            IntRangeMapDB rangeMap = this.intRangePropertyMap.get(mapName);
            if (rangeMap != null) {
                IntRangeMapDB intRangeMapDB = rangeMap;
                return intRangeMapDB;
            }
            rangeMap = IntRangeMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            if (rangeMap != null) {
                this.intRangePropertyMap.put(mapName, rangeMap);
            }
            IntRangeMapDB intRangeMapDB = rangeMap;
            return intRangeMapDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void deleteIntRangeMap(String mapName) {
        this.lock.acquire();
        try {
            IntRangeMapDB rangeMap = this.intRangePropertyMap.remove(mapName);
            if (rangeMap == null) {
                rangeMap = IntRangeMapDB.getPropertyMap(this, mapName, (ErrorHandler)this, this.addrMap, this.lock);
            }
            if (rangeMap != null) {
                rangeMap.delete();
                this.setChanged(ProgramEvent.INT_PROPERTY_MAP_REMOVED, null, mapName);
            }
        }
        finally {
            this.lock.release();
        }
    }

    protected void close() {
        if (this.programUserData != null && this.changed && this.languageUpgradeTranslator != null) {
            this.programUserData.setChanged(false);
        }
        super.close();
        this.intRangePropertyMap.clear();
        this.addrSetPropertyMap.clear();
        for (ManagerDB manager : this.managers) {
            if (manager == null) continue;
            manager.dispose();
        }
    }

    public Map<String, String> getMetadata() {
        this.metadata.clear();
        this.metadata.put(PROGRAM_NAME, this.getName());
        this.metadata.put(LANGUAGE_ID, String.valueOf(this.languageID) + " (" + this.languageVersion + "." + this.languageMinorVersion + ")");
        this.metadata.put("Compiler ID", this.compilerSpecID.getIdAsString());
        this.metadata.put("Processor", this.language.getProcessor().toString());
        this.metadata.put("Endian", this.memoryManager.isBigEndian() ? "Big" : "Little");
        this.metadata.put("Address Size", "" + this.addressFactory.getDefaultAddressSpace().getSize());
        this.metadata.put("Minimum Address", ProgramDB.getString(this.getMinAddress()));
        this.metadata.put("Maximum Address", ProgramDB.getString(this.getMaxAddress()));
        this.metadata.put("# of Bytes", this.getNumberOfBytes());
        this.metadata.put("# of Memory Blocks", "" + this.memoryManager.getBlocks().length);
        this.metadata.put("# of Instructions", "" + this.listing.getNumInstructions());
        this.metadata.put("# of Defined Data", "" + this.listing.getNumDefinedData());
        this.metadata.put("# of Functions", "" + this.getFunctionManager().getFunctionCount());
        this.metadata.put("# of Symbols", "" + this.getSymbolTable().getNumSymbols());
        this.metadata.put("# of Data Types", "" + this.getDataTypeManager().getDataTypeCount(true));
        this.metadata.put("# of Data Type Categories", "" + this.getDataTypeManager().getCategoryCount());
        Options propList = this.getOptions("Program Information");
        List propNames = propList.getOptionNames();
        Collections.sort(propNames);
        for (String propName : propNames) {
            String valueAsString;
            if (propName.indexOf(46) >= 0 || (valueAsString = propList.getValueAsString(propName)) == null) continue;
            this.metadata.put(propName, propList.getValueAsString(propName));
        }
        return this.metadata;
    }

    private static String getString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    private String getNumberOfBytes() {
        MemoryBlock[] blocks;
        long size = 0L;
        for (MemoryBlock block : blocks = this.memoryManager.getBlocks()) {
            size += block.getSize();
        }
        return "" + size;
    }

    protected void updateMetadata() throws IOException {
        this.getMetadata();
        super.updateMetadata();
    }

    public boolean lock(String reason) {
        if (super.lock(reason)) {
            if (this.programUserData == null || this.programUserData.lock(reason)) {
                return true;
            }
            super.unlock();
        }
        return false;
    }

    public void forceLock(boolean rollback, String reason) {
        super.forceLock(rollback, reason);
        if (this.programUserData != null) {
            this.programUserData.forceLock(rollback, reason);
        }
    }

    public void unlock() {
        super.unlock();
        if (this.programUserData != null) {
            this.programUserData.unlock();
        }
    }

    @Override
    public long getUniqueProgramID() {
        return this.dbh.getDatabaseId();
    }

    public void invalidateWriteCache() {
        ProgramRegisterContextDB contextMgr = (ProgramRegisterContextDB)this.getProgramContext();
        contextMgr.invalidateProcessorContextWriteCache();
        super.invalidateWriteCache();
    }

    public void flushWriteCache() {
        ProgramRegisterContextDB contextMgr = (ProgramRegisterContextDB)this.getProgramContext();
        contextMgr.flushProcessorContextWriteCache();
        super.flushWriteCache();
    }

    protected void installExtensions() {
        if (!(this.compilerSpec instanceof ProgramCompilerSpec)) {
            return;
        }
        this.lock.acquire();
        try {
            ((ProgramCompilerSpec)this.compilerSpec).installExtensions();
            this.getFunctionManager().invalidateCache(true);
            this.getDataTypeManager().invalidateCache();
        }
        finally {
            this.lock.release();
        }
    }

    private void registerCompilerSpecOptions() {
        if (!(this.compilerSpec instanceof ProgramCompilerSpec)) {
            throw new AssertException("unsupported compilerSpec: " + this.compilerSpec.getClass().getName());
        }
        ((ProgramCompilerSpec)this.compilerSpec).registerProgramOptions();
    }

    protected void domainObjectRestored() {
        super.domainObjectRestored();
        this.getDataTypeManager().notifyRestored();
    }
}

