/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.pcodeCPort.slgh_compile.DirectoryVisitor;
import ghidra.pcodeCPort.slgh_compile.SleighCompile;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.antlr.runtime.RecognitionException;
import org.jdom.JDOMException;
import utility.application.ApplicationLayout;

public class SleighCompileLauncher
implements GhidraLaunchable {
    public static final String FILE_IN_DEFAULT_EXT = ".slaspec";
    public static final String FILE_OUT_DEFAULT_EXT = ".sla";
    private static final FileFilter SLASPEC_FILTER = pathname -> pathname.getName().endsWith(FILE_IN_DEFAULT_EXT);

    public void launch(GhidraApplicationLayout layout, String[] args) throws JDOMException, IOException, RecognitionException {
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        System.exit(SleighCompileLauncher.runMain(args));
    }

    public static int runMain(String[] args) throws IOException, RecognitionException {
        int i;
        Object filein = null;
        Object fileout = null;
        HashMap<String, String> preprocs = new HashMap<String, String>();
        SleighCompile.yydebug = false;
        boolean allMode = false;
        if (args.length < 1) {
            Msg.info(SleighCompile.class, (Object)"Usage: sleigh [options...] [<infile.slaspec> [<outfile.sla>] | -a <directory-path>]");
            Msg.info(SleighCompile.class, (Object)"    sleigh [options...] <infile.slaspec> [<outfile.sla>]");
            Msg.info(SleighCompile.class, (Object)"       <infile.slaspec>   source slaspec file to be compiled");
            Msg.info(SleighCompile.class, (Object)"       <outfile.sla>      optional output sla file (infile.sla assumed)");
            Msg.info(SleighCompile.class, (Object)"  or");
            Msg.info(SleighCompile.class, (Object)"    sleigh [options...] -a <directory-path>");
            Msg.info(SleighCompile.class, (Object)"       <directory-path>   directory to have all slaspec files compiled");
            Msg.info(SleighCompile.class, (Object)"  options:");
            Msg.info(SleighCompile.class, (Object)"   -x                turns on parser debugging");
            Msg.info(SleighCompile.class, (Object)"   -y                write .sla using XML debug format");
            Msg.info(SleighCompile.class, (Object)"   -u                print warnings for unnecessary pcode instructions");
            Msg.info(SleighCompile.class, (Object)"   -l                report pattern conflicts");
            Msg.info(SleighCompile.class, (Object)"   -n                print warnings for all NOP constructors");
            Msg.info(SleighCompile.class, (Object)"   -t                print warnings for dead temporaries");
            Msg.info(SleighCompile.class, (Object)"   -e                enforce use of 'local' keyword for temporaries");
            Msg.info(SleighCompile.class, (Object)"   -c                print warnings for all constructors with colliding operands");
            Msg.info(SleighCompile.class, (Object)"   -f                print warnings for unused token fields");
            Msg.info(SleighCompile.class, (Object)"   -o                print warnings for temporaries which are too large");
            Msg.info(SleighCompile.class, (Object)"  -s                treat register names as case sensitive");
            Msg.info(SleighCompile.class, (Object)"   -DNAME=VALUE      defines a preprocessor macro NAME with value VALUE (option may be repeated)");
            Msg.info(SleighCompile.class, (Object)"   -dMODULE          defines a preprocessor macro MODULE with a value of its module path (option may be repeated)");
            Msg.info(SleighCompile.class, (Object)"   -i <options-file> inject options from specified file");
            return 2;
        }
        boolean unnecessaryPcodeWarning = false;
        boolean lenientConflict = true;
        boolean allCollisionWarning = false;
        boolean allNopWarning = false;
        boolean deadTempWarning = false;
        boolean enforceLocalKeyWord = false;
        boolean unusedFieldWarning = false;
        boolean largeTemporaryWarning = false;
        boolean caseSensitiveRegisterNames = false;
        boolean debugOutput = false;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].charAt(1) == 'i') {
                if ((args = SleighCompileLauncher.injectOptionsFromFile(args, ++i)) != null) continue;
                return 1;
            }
            if (args[i].charAt(1) == 'D') {
                String preproc = args[i].substring(2);
                int pos = preproc.indexOf(61);
                if (pos == -1) {
                    Msg.error(SleighCompile.class, (Object)("Bad sleigh option: " + args[i]));
                    return 1;
                }
                String name = preproc.substring(0, pos);
                String value = preproc.substring(pos + 1);
                preprocs.put(name, value);
                continue;
            }
            if (args[i].charAt(1) == 'd') {
                String moduleName = args[i].substring(2);
                ResourceFile module = Application.getModuleRootDir((String)moduleName);
                if (module == null || !module.isDirectory()) {
                    Msg.error(SleighCompile.class, (Object)("Failed to resolve module reference: " + args[i]));
                    return 1;
                }
                Msg.debug(SleighCompile.class, (Object)("Sleigh resolved module: " + moduleName + "=" + module.getAbsolutePath()));
                preprocs.put(moduleName, module.getAbsolutePath());
                continue;
            }
            if (args[i].charAt(1) == 'u') {
                unnecessaryPcodeWarning = true;
                continue;
            }
            if (args[i].charAt(1) == 't') {
                deadTempWarning = true;
                continue;
            }
            if (args[i].charAt(1) == 'e') {
                enforceLocalKeyWord = true;
                continue;
            }
            if (args[i].charAt(1) == 'f') {
                unusedFieldWarning = true;
                continue;
            }
            if (args[i].charAt(1) == 'l') {
                lenientConflict = false;
                continue;
            }
            if (args[i].charAt(1) == 'c') {
                allCollisionWarning = true;
                continue;
            }
            if (args[i].charAt(1) == 'n') {
                allNopWarning = true;
                continue;
            }
            if (args[i].charAt(1) == 'a') {
                allMode = true;
                continue;
            }
            if (args[i].charAt(1) == 'o') {
                largeTemporaryWarning = true;
                continue;
            }
            if (args[i].charAt(1) == 's') {
                caseSensitiveRegisterNames = true;
                continue;
            }
            if (args[i].charAt(1) == 'y') {
                debugOutput = true;
                continue;
            }
            if (args[i].charAt(1) == 'x') {
                SleighCompile.yydebug = true;
                continue;
            }
            Msg.error(SleighCompile.class, (Object)("Unknown option: " + args[i]));
            return 1;
        }
        if (i < args.length - 2) {
            Msg.error(SleighCompile.class, (Object)"Too many parameters");
            return 1;
        }
        if (allMode) {
            if (i == args.length) {
                Msg.error(SleighCompile.class, (Object)"Missing input directory path");
                return 1;
            }
            String directory = args[i];
            File dir = new File(directory);
            if (!dir.exists() || !dir.isDirectory()) {
                Msg.error(SleighCompile.class, (Object)(directory + " is not a directory"));
                return 1;
            }
            TreeSet<String> failures = new TreeSet<String>();
            int totalFailures = 0;
            int totalSuccesses = 0;
            DirectoryVisitor visitor = new DirectoryVisitor(dir, SLASPEC_FILTER);
            for (File input : visitor) {
                System.out.println("Compiling " + String.valueOf(input) + ":");
                SleighCompile compiler = new SleighCompile();
                compiler.setAllOptions(preprocs, unnecessaryPcodeWarning, lenientConflict, allCollisionWarning, allNopWarning, deadTempWarning, unusedFieldWarning, enforceLocalKeyWord, largeTemporaryWarning, caseSensitiveRegisterNames, debugOutput);
                String outname = input.getName().replace(FILE_IN_DEFAULT_EXT, FILE_OUT_DEFAULT_EXT);
                File output = new File(input.getParent(), outname);
                int retval = compiler.run_compilation(input.getAbsolutePath(), output.getAbsolutePath());
                System.out.println();
                if (retval != 0) {
                    ++totalFailures;
                    failures.add(input.getAbsolutePath());
                    continue;
                }
                ++totalSuccesses;
            }
            System.out.println(totalSuccesses + " languages successfully compiled");
            if (totalFailures != 0) {
                for (String path : failures) {
                    System.out.println(path + " failed to compile");
                }
                System.out.println(totalFailures + " languages total failed to compile");
            }
            return -totalFailures;
        }
        SleighCompile compiler = new SleighCompile();
        compiler.setAllOptions(preprocs, unnecessaryPcodeWarning, lenientConflict, allCollisionWarning, allNopWarning, deadTempWarning, unusedFieldWarning, enforceLocalKeyWord, largeTemporaryWarning, caseSensitiveRegisterNames, debugOutput);
        if (i == args.length) {
            Msg.error(SleighCompile.class, (Object)"Missing input file name");
            return 1;
        }
        filein = args[i];
        if (i < args.length - 1) {
            fileout = args[i + 1];
        }
        String baseName = filein;
        if (((String)filein).toLowerCase().endsWith(FILE_IN_DEFAULT_EXT)) {
            baseName = ((String)filein).substring(0, ((String)filein).length() - FILE_IN_DEFAULT_EXT.length());
        }
        filein = baseName + FILE_IN_DEFAULT_EXT;
        String baseOutName = fileout;
        if (fileout == null) {
            baseOutName = baseName;
        } else if (((String)fileout).toLowerCase().endsWith(FILE_OUT_DEFAULT_EXT)) {
            baseOutName = ((String)fileout).substring(0, ((String)fileout).length() - FILE_OUT_DEFAULT_EXT.length());
        }
        fileout = baseOutName + FILE_OUT_DEFAULT_EXT;
        return compiler.run_compilation((String)filein, (String)fileout);
    }

    private static String[] injectOptionsFromFile(String[] args, int index) {
        if (index >= args.length) {
            Msg.error(SleighCompile.class, (Object)"Missing options input file name");
            return null;
        }
        File optionsFile = new File(args[index]);
        if (!optionsFile.isFile()) {
            Msg.error(SleighCompile.class, (Object)("Options file not found: " + optionsFile.getAbsolutePath()));
            if (SystemUtilities.isInDevelopmentMode()) {
                Msg.error(SleighCompile.class, (Object)"Eclipse language module must be selected and 'gradle prepdev' prevously run");
            }
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i <= index; ++i) {
            list.add(args[i]);
        }
        try (BufferedReader r = new BufferedReader(new FileReader(optionsFile));){
            String option = r.readLine();
            while (option != null) {
                if ((option = option.trim()).length() != 0 && !option.startsWith("#")) {
                    list.add(option);
                }
                option = r.readLine();
            }
        }
        catch (IOException e) {
            Msg.error(SleighCompile.class, (Object)("Reading options file failed (" + optionsFile.getName() + "): " + e.getMessage()));
            return null;
        }
        for (int i = index + 1; i < args.length; ++i) {
            list.add(args[i]);
        }
        return list.toArray(new String[list.size()]);
    }
}

