/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class FSBRootNode
extends FSBNode {
    private RefdFile rootDir;
    private FSBFileNode prevNode;
    private FSBRootNode modelNode;
    private boolean cryptoStatusUpdated;
    private Icon icon;

    FSBRootNode(RefdFile rootDir) {
        this(rootDir, null);
    }

    FSBRootNode(RefdFile rootDir, FSBFileNode prevNode) {
        super(FSBComponentProvider.getDescriptiveFSName(rootDir));
        this.rootDir = rootDir;
        this.prevNode = prevNode;
        this.modelNode = this;
        this.icon = FSBComponentProvider.getFSIcon(rootDir.fsRef.getFilesystem(), prevNode == null, FSBIcons.getInstance());
    }

    public GTreeNode clone() throws CloneNotSupportedException {
        FSBRootNode clone = (FSBRootNode)super.clone();
        clone.rootDir = null;
        return clone;
    }

    public void dispose() {
        this.releaseFSRefIfModelNode();
        super.dispose();
    }

    @Override
    public void init(TaskMonitor monitor) throws CancelledException {
        this.setChildren(this.generateChildren(monitor));
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return this.icon;
    }

    public void setCryptoStatusUpdated(boolean cryptoStatusUpdated) {
        this.cryptoStatusUpdated = cryptoStatusUpdated;
    }

    boolean isCryptoStatusUpdated() {
        return this.cryptoStatusUpdated;
    }

    public void swapBackPrevModelNodeAndDispose() {
        if (this != this.modelNode) {
            this.modelNode.swapBackPrevModelNodeAndDispose();
            return;
        }
        int indexInParent = this.getIndexInParent();
        GTreeNode parent = this.getParent();
        parent.removeNode((GTreeNode)this);
        parent.addNode(indexInParent, (GTreeNode)this.prevNode);
        this.dispose();
    }

    @Override
    public GFile getGFile() {
        return this.rootDir.file;
    }

    public FileSystemRef getFSRef() {
        return this.modelNode.rootDir != null ? this.modelNode.rootDir.fsRef : null;
    }

    private void releaseFSRefIfModelNode() {
        if (this != this.modelNode || this.rootDir == null) {
            return;
        }
        FileSystemService.getInstance().releaseFileSystemImmediate(this.rootDir.fsRef);
        this.rootDir = null;
    }

    @Override
    public void refreshNode(TaskMonitor monitor) throws CancelledException {
        if (this != this.modelNode) {
            this.modelNode.refreshNode(monitor);
            return;
        }
        this.refreshChildren(monitor);
        if (this.cryptoStatusUpdated) {
            // empty if block
        }
    }

    @Override
    public String getToolTip() {
        return this.getName();
    }

    public boolean isLeaf() {
        return false;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (this.rootDir != null) {
            try {
                return FSBNode.createNodesFromFileList(this.rootDir.file.getListing(), monitor);
            }
            catch (IOException e) {
                FSUtilities.displayException((Object)this, null, "Error Opening File System", "Problem generating children at root of file system", e);
            }
        }
        return List.of();
    }

    @Override
    public FSRL getFSRL() {
        return this.modelNode != null && this.modelNode.rootDir != null ? this.modelNode.rootDir.file.getFSRL() : null;
    }

    public FSBNode getGFileFSBNode(GFile file, TaskMonitor monitor) {
        List<GFile> pathParts = this.splitGFilePath(file);
        List<GFile> rootPathParts = this.splitGFilePath(this.rootDir.file);
        FSBNode fileNode = this;
        for (int i = rootPathParts.size(); fileNode != null && i < pathParts.size(); fileNode = fileNode.findMatchingNode(pathParts.get(i), monitor), ++i) {
            try {
                continue;
            }
            catch (CancelledException e) {
                return null;
            }
        }
        return fileNode;
    }

    public FSRL getContainer() {
        if (this.rootDir != null && this.rootDir.file.getParentFile() == null) {
            return this.rootDir.fsRef.getFilesystem().getFSRL().getContainer();
        }
        return null;
    }

    private List<GFile> splitGFilePath(GFile f) {
        ArrayList<GFile> result = new ArrayList<GFile>();
        while (f != null) {
            result.add(0, f);
            f = f.getParentFile();
        }
        return result;
    }

    public FSRL getProgramProviderFSRL(FSRL fsrl) {
        GFileSystem fs;
        if (this.rootDir != null && (fs = this.rootDir.fsRef.getFilesystem()) instanceof GFileSystemProgramProvider) {
            GFileSystemProgramProvider programProviderFS = (GFileSystemProgramProvider)((Object)fs);
            try {
                GFile gfile = fs.lookup(fsrl.getPath());
                if (gfile != null && programProviderFS.canProvideProgram(gfile)) {
                    return fsrl;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public FSRL getLoadableFSRL() {
        FSRL ppFSRL = this.getProgramProviderFSRL(this.getFSRL());
        if (ppFSRL != null) {
            return ppFSRL;
        }
        return this.getContainer();
    }
}

