/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import com.google.common.primitives.Bytes;
import ghidra.app.plugin.core.analysis.rust.RustUtilities;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.golang.GoBuildId;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.pe.BaseRelocation;
import ghidra.app.util.bin.format.pe.BaseRelocationDataDirectory;
import ghidra.app.util.bin.format.pe.COMDescriptorDataDirectory;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.DebugDataDirectory;
import ghidra.app.util.bin.format.pe.DelayImportDataDirectory;
import ghidra.app.util.bin.format.pe.DelayImportDescriptor;
import ghidra.app.util.bin.format.pe.ExportDataDirectory;
import ghidra.app.util.bin.format.pe.ExportInfo;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.ImageCor20Header;
import ghidra.app.util.bin.format.pe.ImportDataDirectory;
import ghidra.app.util.bin.format.pe.ImportInfo;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionFlags;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.app.util.bin.format.pe.debug.DebugDirectoryParser;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractPeDebugLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PeLoader
extends AbstractPeDebugLoader {
    public static final String PE_NAME = "Portable Executable (PE)";
    public static final String HEADERS = "Headers";
    private static final long MIN_BYTE_LENGTH = 4L;
    public static final String PARSE_CLI_HEADERS_OPTION_NAME = "Parse CLI headers (if present)";
    static final boolean PARSE_CLI_HEADERS_OPTION_DEFAULT = true;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        PortableExecutable pe = new PortableExecutable(provider, this.getSectionLayout(), false, false);
        NTHeader ntHeader = pe.getNTHeader();
        if (ntHeader != null && ntHeader.getOptionalHeader() != null) {
            long imageBase = ntHeader.getOptionalHeader().getImageBase();
            String machineName = ntHeader.getFileHeader().getMachineName();
            String compilerFamily = CompilerOpinion.getOpinion((PortableExecutable)pe, (ByteProvider)provider, null, (TaskMonitor)TaskMonitor.DUMMY, (MessageLog)new MessageLog()).family;
            for (QueryResult result : QueryOpinionService.query(this.getName(), machineName, compilerFamily)) {
                loadSpecs.add(new LoadSpec((Loader)this, imageBase, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, imageBase, true));
            }
        }
        return loadSpecs;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        if (monitor.isCancelled()) {
            return;
        }
        PortableExecutable pe = new PortableExecutable(provider, this.getSectionLayout(), false, this.shouldParseCliHeaders(options));
        NTHeader ntHeader = pe.getNTHeader();
        if (ntHeader == null) {
            return;
        }
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        monitor.setMessage("Completing PE header parsing...");
        FileBytes fileBytes = this.createFileBytes(provider, program, monitor);
        try {
            Map<SectionHeader, Address> sectionToAddress = this.processMemoryBlocks(pe, program, fileBytes, monitor, log);
            monitor.setCancelEnabled(false);
            optionalHeader.processDataDirectories(log, monitor);
            monitor.setCancelEnabled(true);
            optionalHeader.validateDataDirectories(program);
            DataDirectory[] datadirs = optionalHeader.getDataDirectories();
            this.layoutHeaders(program, pe, ntHeader, datadirs);
            for (DataDirectory datadir : datadirs) {
                if (datadir == null || !datadir.hasParsedCorrectly() || !datadir.hasParsedCorrectly()) continue;
                datadir.markup(program, false, monitor, log, ntHeader);
            }
            this.processExports(optionalHeader, program, monitor, log);
            this.processImports(optionalHeader, program, monitor, log);
            this.processDelayImports(optionalHeader, program, monitor, log);
            this.processRelocations(optionalHeader, program, monitor, log);
            this.processDebug(optionalHeader, ntHeader, sectionToAddress, program, options, monitor);
            this.processProperties(optionalHeader, ntHeader, program, monitor);
            this.processComments(program.getListing(), monitor);
            this.processSymbols(ntHeader, sectionToAddress, program, monitor, log);
            this.processEntryPoints(ntHeader, program, monitor);
            String compiler = CompilerOpinion.getOpinion(pe, provider, program, monitor, log).toString();
            program.setCompiler(compiler);
        }
        catch (AddressOverflowException e) {
            throw new IOException(e);
        }
        catch (DuplicateNameException e) {
            throw new IOException(e);
        }
        catch (CodeUnitInsertionException e) {
            throw new IOException(e);
        }
        catch (MemoryAccessException e) {
            throw new IOException(e);
        }
        monitor.setMessage("[" + program.getName() + "]: done!");
    }

    protected PortableExecutable.SectionLayout getSectionLayout() {
        return PortableExecutable.SectionLayout.FILE;
    }

    protected FileBytes createFileBytes(ByteProvider provider, Program program, TaskMonitor monitor) throws IOException, CancelledException {
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
        return fileBytes;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(PARSE_CLI_HEADERS_OPTION_NAME, true, Boolean.class, "-loader-parseCliHeaders"));
        }
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(PARSE_CLI_HEADERS_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    @Override
    protected boolean isCaseInsensitiveLibraryFilenames() {
        return true;
    }

    private boolean shouldParseCliHeaders(List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(PARSE_CLI_HEADERS_OPTION_NAME)) continue;
                return (Boolean)option.getValue();
            }
        }
        return true;
    }

    private void layoutHeaders(Program program, PortableExecutable pe, NTHeader ntHeader, DataDirectory[] datadirs) {
        try {
            DataType dt = pe.getDOSHeader().toDataType();
            Address start = program.getImageBase();
            DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            dt = pe.getRichHeader().toDataType();
            if (dt != null) {
                start = program.getImageBase().add((long)pe.getRichHeader().getOffset());
                DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            dt = ntHeader.toDataType();
            start = program.getImageBase().add((long)pe.getDOSHeader().e_lfanew());
            DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            FileHeader fh = ntHeader.getFileHeader();
            SectionHeader[] sections = fh.getSectionHeaders();
            int index = fh.getPointerToSections();
            start = program.getImageBase().add((long)index);
            for (SectionHeader section : sections) {
                dt = section.toDataType();
                DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.setComment(CommentType.EOL, start, section.getName());
                start = start.add((long)dt.getLength());
            }
        }
        catch (Exception e1) {
            Msg.error((Object)this, (Object)("Error laying down header structures " + String.valueOf(e1)));
        }
    }

    private void processSymbols(NTHeader ntHeader, Map<SectionHeader, Address> sectionToAddress, Program program, TaskMonitor monitor, MessageLog log) {
        FileHeader fileHeader = ntHeader.getFileHeader();
        List<DebugCOFFSymbol> symbols = fileHeader.getSymbols();
        int errorCount = 0;
        for (DebugCOFFSymbol symbol : symbols) {
            if (this.processDebugCoffSymbol(symbol, ntHeader, sectionToAddress, program, monitor)) continue;
            ++errorCount;
        }
        if (errorCount != 0) {
            log.appendMsg("Failed to apply " + errorCount + " symbols contained within unknown sections.");
        }
    }

    private void processProperties(OptionalHeader optionalHeader, NTHeader ntHeader, Program prog, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        Options props = prog.getOptions("Program Information");
        props.setInt("SectionAlignment", optionalHeader.getSectionAlignment());
        props.setBoolean("Relocatable", prog.getRelocationTable().getSize() > 0);
        if (GoRttiMapper.isGolangProgram(prog)) {
            this.processGolangProperties(optionalHeader, ntHeader, prog, monitor);
        }
    }

    private void processGolangProperties(OptionalHeader optionalHeader, NTHeader ntHeader, Program prog, TaskMonitor monitor) {
        ElfInfoItem.ItemWithAddress<GoBuildInfo> buildInfo;
        ElfInfoItem.ItemWithAddress<GoBuildId> buildId = GoBuildId.findBuildId(prog);
        if (buildId != null) {
            buildId.item().markupProgram(prog, buildId.address());
        }
        if ((buildInfo = GoBuildInfo.findBuildInfo(prog)) != null) {
            buildInfo.item().markupProgram(prog, buildInfo.address());
        }
    }

    private void processRelocations(OptionalHeader optionalHeader, Program prog, TaskMonitor monitor, MessageLog log) {
        monitor.setMessage("[" + prog.getName() + "]: processing relocation tables...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 5) {
            return;
        }
        BaseRelocationDataDirectory brdd = (BaseRelocationDataDirectory)dataDirectories[5];
        if (brdd == null) {
            return;
        }
        AddressSpace space = prog.getAddressFactory().getDefaultAddressSpace();
        RelocationTable relocTable = prog.getRelocationTable();
        for (BaseRelocation reloc : brdd.getBaseRelocations()) {
            if (monitor.isCancelled()) {
                return;
            }
            int baseAddr = reloc.getVirtualAddress();
            for (int i = 0; i < reloc.getCount(); ++i) {
                long addr = optionalHeader.getImageBase() + (long)baseAddr + (long)reloc.getOffset(i);
                relocTable.add(space.getAddress(addr), Relocation.Status.SKIPPED, reloc.getType(i), null, null, null);
            }
        }
    }

    private void processImports(OptionalHeader optionalHeader, Program program, TaskMonitor monitor, MessageLog log) {
        ImportInfo[] imports;
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: processing imports...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 1) {
            return;
        }
        ImportDataDirectory idd = (ImportDataDirectory)dataDirectories[1];
        if (idd == null) {
            return;
        }
        AddressFactory af = program.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        Listing listing = program.getListing();
        for (ImportInfo importInfo : imports = idd.getImports()) {
            if (monitor.isCancelled()) {
                return;
            }
            long addr = Integer.toUnsignedLong(importInfo.getAddress()) + optionalHeader.getImageBase();
            if (!optionalHeader.is64bit()) {
                addr &= 0xFFFFFFFFL;
            }
            Address address = space.getAddress(addr);
            this.setComment(CommentType.PRE, address, importInfo.getComment());
            Data data = listing.getDefinedDataAt(address);
            if (data == null || !data.isPointer()) continue;
            this.addExternalReference(data, importInfo, log);
        }
    }

    protected void addExternalReference(Data pointerData, ImportInfo importInfo, MessageLog log) {
        Address extAddr = (Address)pointerData.getValue();
        if (extAddr != null) {
            pointerData.removeOperandReference(0, extAddr);
            try {
                ReferenceManager refManager = pointerData.getProgram().getReferenceManager();
                refManager.addExternalReference(pointerData.getAddress(), importInfo.getDLL().toUpperCase(), importInfo.getName(), extAddr, SourceType.IMPORTED, 0, RefType.DATA);
            }
            catch (DuplicateNameException e) {
                log.appendMsg("External location not created: " + e.getMessage());
            }
            catch (InvalidInputException e) {
                log.appendMsg("External location not created: " + e.getMessage());
            }
        }
    }

    private void processDelayImports(OptionalHeader optionalHeader, Program program, TaskMonitor monitor, MessageLog log) {
        DelayImportDescriptor[] descriptors;
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: processing delay imports...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 13) {
            return;
        }
        DelayImportDataDirectory didd = (DelayImportDataDirectory)dataDirectories[13];
        if (didd == null) {
            return;
        }
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Listing listing = program.getListing();
        ReferenceManager refManager = program.getReferenceManager();
        FunctionManager funcManager = program.getFunctionManager();
        for (DelayImportDescriptor descriptor : descriptors = didd.getDelayImportDescriptors()) {
            ImportInfo importInfo;
            long offset;
            if (monitor.isCancelled()) {
                return;
            }
            Address iatBaseAddr = space.getAddress(descriptor.isUsingRVA() ? descriptor.getAddressOfIAT() + optionalHeader.getImageBase() : descriptor.getAddressOfIAT());
            Iterator<ImportInfo> iterator = descriptor.getImportList().iterator();
            while (iterator.hasNext() && (offset = (long)(importInfo = iterator.next()).getAddress()) >= 0L) {
                Address proxyFuncAddr;
                Address iatAddr = iatBaseAddr.add(offset);
                Data iatData = listing.getDataAt(iatAddr);
                if (iatData == null || !(iatData.getValue() instanceof Address)) continue;
                try {
                    refManager.addExternalReference(iatAddr, importInfo.getDLL(), importInfo.getName(), null, SourceType.IMPORTED, 0, RefType.DATA);
                }
                catch (DuplicateNameException | InvalidInputException e) {
                    log.appendMsg("Failed to create Delay Load external function at: " + String.valueOf(iatAddr));
                }
                if (funcManager.getFunctionAt(proxyFuncAddr = (Address)iatData.getValue()) != null) continue;
                try {
                    funcManager.createFunction("DelayLoad_" + importInfo.getName(), proxyFuncAddr, (AddressSetView)new AddressSet(proxyFuncAddr), SourceType.IMPORTED);
                }
                catch (OverlappingFunctionException | InvalidInputException e) {
                    log.appendMsg("Failed to create Delay Load proxy function at: " + String.valueOf(proxyFuncAddr));
                }
            }
        }
    }

    private void markAsCode(Program program, Address address) {
        AddressSetPropertyMap codeProp = program.getAddressSetPropertyMap("CodeMap");
        if (codeProp == null) {
            try {
                codeProp = program.createAddressSetPropertyMap("CodeMap");
            }
            catch (DuplicateNameException e) {
                codeProp = program.getAddressSetPropertyMap("CodeMap");
            }
        }
        if (codeProp != null) {
            codeProp.add(address, address);
        }
    }

    private void processExports(OptionalHeader optionalHeader, Program program, TaskMonitor monitor, MessageLog log) {
        ExportInfo[] exports;
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: processing exports...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 0) {
            return;
        }
        ExportDataDirectory edd = (ExportDataDirectory)dataDirectories[0];
        if (edd == null) {
            return;
        }
        AddressFactory af = program.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        SymbolTable symTable = program.getSymbolTable();
        Listing listing = program.getListing();
        ReferenceManager refManager = program.getReferenceManager();
        for (ExportInfo export : exports = edd.getExports()) {
            if (monitor.isCancelled()) {
                return;
            }
            Address address = space.getAddress(export.getAddress());
            this.setComment(CommentType.PRE, address, export.getComment());
            symTable.addExternalEntryPoint(address);
            String name = export.getName();
            try {
                symTable.createLabel(address, name, SourceType.IMPORTED);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            try {
                symTable.createLabel(address, "Ordinal_" + export.getOrdinal(), SourceType.IMPORTED);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (!export.isForwarded()) continue;
            try {
                Object obj;
                listing.createData(address, (DataType)TerminatedStringDataType.dataType, -1);
                Data data = listing.getDataAt(address);
                if (data == null || !((obj = data.getValue()) instanceof String)) continue;
                String str = (String)obj;
                int dotpos = str.indexOf(46);
                if (dotpos < 0) {
                    dotpos = 0;
                }
                String dllName = str.substring(0, dotpos) + ".dll";
                String expName = str.substring(dotpos + 1);
                try {
                    refManager.addExternalReference(address, dllName.toUpperCase(), expName, null, SourceType.IMPORTED, 0, RefType.DATA);
                }
                catch (DuplicateNameException e) {
                    log.appendMsg("External location not created: " + e.getMessage());
                }
                catch (InvalidInputException e) {
                    log.appendMsg("External location not created: " + e.getMessage());
                }
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
                // empty catch block
            }
        }
    }

    protected Map<SectionHeader, Address> processMemoryBlocks(PortableExecutable pe, Program prog, FileBytes fileBytes, TaskMonitor monitor, MessageLog log) throws AddressOverflowException {
        AddressFactory af = prog.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        HashMap<SectionHeader, Address> sectionToAddress = new HashMap<SectionHeader, Address>();
        if (monitor.isCancelled()) {
            return sectionToAddress;
        }
        monitor.setMessage("[" + prog.getName() + "]: processing memory blocks...");
        NTHeader ntHeader = pe.getNTHeader();
        FileHeader fileHeader = ntHeader.getFileHeader();
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        SectionHeader[] sections = fileHeader.getSectionHeaders();
        if (sections.length == 0) {
            Msg.warn((Object)this, (Object)"No sections found");
        }
        int virtualSize = (int)Math.min((long)this.getVirtualSize(pe, sections, space), fileBytes.getSize());
        long addr = optionalHeader.getImageBase();
        Address address = space.getAddress(addr);
        boolean r = true;
        boolean w = false;
        boolean x = false;
        MemoryBlockUtils.createInitializedBlock(prog, false, HEADERS, address, fileBytes, 0L, virtualSize, "", "", r, w, x, log);
        try {
            for (int i = 0; i < sections.length; ++i) {
                int dataSize;
                if (monitor.isCancelled()) {
                    return sectionToAddress;
                }
                addr = (long)sections[i].getVirtualAddress() + optionalHeader.getImageBase();
                address = space.getAddress(addr);
                Object sectionName = sections[i].getReadableName();
                if (((String)sectionName).isBlank()) {
                    sectionName = "SECTION." + i;
                }
                r = (sections[i].getCharacteristics() & SectionFlags.IMAGE_SCN_MEM_READ.getMask()) != 0;
                w = (sections[i].getCharacteristics() & SectionFlags.IMAGE_SCN_MEM_WRITE.getMask()) != 0;
                x = (sections[i].getCharacteristics() & SectionFlags.IMAGE_SCN_MEM_EXECUTE.getMask()) != 0;
                int rawDataSize = sections[i].getSizeOfRawData();
                int rawDataPtr = sections[i].getPointerToRawData();
                virtualSize = sections[i].getVirtualSize();
                MemoryBlock block = null;
                if (rawDataSize != 0 && rawDataPtr != 0) {
                    int n = dataSize = rawDataSize > virtualSize && virtualSize > 0 || rawDataSize < 0 ? virtualSize : rawDataSize;
                    if (ntHeader.checkRVA(dataSize) || 0 < dataSize && (long)dataSize < pe.getFileLength()) {
                        if (!ntHeader.checkRVA(dataSize)) {
                            Msg.warn((Object)this, (Object)("OptionalHeader.SizeOfImage < size of " + sections[i].getName() + " section"));
                        }
                        block = MemoryBlockUtils.createInitializedBlock(prog, false, (String)sectionName, address, fileBytes, (long)rawDataPtr, dataSize, "", "", r, w, x, log);
                        sectionToAddress.put(sections[i], address);
                    }
                    if (rawDataSize == virtualSize || rawDataSize > virtualSize) continue;
                    if (rawDataSize < 0) {
                        Msg.error((Object)this, (Object)("Section[" + i + "] has invalid size " + Integer.toHexString(rawDataSize) + " (" + Integer.toHexString(virtualSize) + ")"));
                        break;
                    }
                    virtualSize -= rawDataSize;
                    address = address.add((long)rawDataSize);
                }
                if (virtualSize == 0) {
                    Msg.error((Object)this, (Object)("Section[" + i + "] has size zero"));
                    continue;
                }
                int n = dataSize = virtualSize > 0 || rawDataSize < 0 ? virtualSize : 0;
                if (dataSize <= 0) continue;
                if (block != null) {
                    MemoryBlock paddingBlock = MemoryBlockUtils.createInitializedBlock(prog, false, (String)sectionName, address, dataSize, "", "", r, w, x, log);
                    if (paddingBlock == null) continue;
                    try {
                        prog.getMemory().join(block, paddingBlock);
                    }
                    catch (Exception e) {
                        log.appendMsg(e.getMessage());
                    }
                    continue;
                }
                MemoryBlockUtils.createUninitializedBlock(prog, false, (String)sectionName, address, dataSize, "", "", r, w, x, log);
                sectionToAddress.putIfAbsent(sections[i], address);
            }
        }
        catch (IllegalStateException ise) {
            if (optionalHeader.getFileAlignment() != optionalHeader.getSectionAlignment()) {
                throw new IllegalStateException(ise);
            }
            Msg.warn((Object)this, (Object)"Section header processing aborted");
        }
        return sectionToAddress;
    }

    protected int getVirtualSize(PortableExecutable pe, SectionHeader[] sections, AddressSpace space) {
        DOSHeader dosHeader = pe.getDOSHeader();
        OptionalHeader optionalHeader = pe.getNTHeader().getOptionalHeader();
        int virtualSize = optionalHeader.is64bit() ? 240 : 224;
        virtualSize += 24;
        if (optionalHeader.getSizeOfHeaders() > (long)(virtualSize += dosHeader.e_lfanew())) {
            virtualSize = (int)optionalHeader.getSizeOfHeaders();
        }
        if (optionalHeader.getFileAlignment() == optionalHeader.getSectionAlignment() && optionalHeader.getFileAlignment() <= 2048) {
            Msg.warn((Object)this, (Object)"File and section alignments identical - possible driver or sectionless image");
        }
        return virtualSize;
    }

    private void processEntryPoints(NTHeader ntHeader, Program prog, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("[" + prog.getName() + "]: processing entry points...");
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        AddressFactory af = prog.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        SymbolTable symTable = prog.getSymbolTable();
        long entry = optionalHeader.getAddressOfEntryPoint();
        int ptr = ntHeader.rvaToPointer((int)entry);
        if (ptr < 0 && (entry != 0L || (ntHeader.getFileHeader().getCharacteristics() & 0x2000) == 0)) {
            Msg.warn((Object)this, (Object)("Virtual entry point at " + Long.toHexString(entry)));
        }
        Address baseAddr = space.getAddress(entry);
        long imageBase = optionalHeader.getImageBase();
        Address entryAddr = baseAddr.addWrap(imageBase);
        entry += optionalHeader.getImageBase();
        Address ILEntryPointVA = this.getILEntryPoint(optionalHeader);
        if (ILEntryPointVA != null) {
            if (entry > 0L) {
                try {
                    symTable.createLabel(entryAddr, "__x86_CIL_", SourceType.IMPORTED);
                    this.markAsCode(prog, entryAddr);
                    symTable.addExternalEntryPoint(entryAddr);
                }
                catch (InvalidInputException e) {
                    Msg.warn((Object)this, (Object)"Backwards compatible native entry point in the CIL binary couldn't be processed");
                }
            }
            entryAddr = ILEntryPointVA;
        }
        try {
            symTable.createLabel(entryAddr, "entry", SourceType.IMPORTED);
            this.markAsCode(prog, entryAddr);
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        symTable.addExternalEntryPoint(entryAddr);
    }

    private Address getILEntryPoint(OptionalHeader optionalHeader) {
        DataDirectory[] dataDirectories;
        for (DataDirectory element : dataDirectories = optionalHeader.getDataDirectories()) {
            COMDescriptorDataDirectory comDescriptorDataDirectory;
            ImageCor20Header imageCor20Header;
            if (element == null || !(element instanceof COMDescriptorDataDirectory) || (imageCor20Header = (comDescriptorDataDirectory = (COMDescriptorDataDirectory)element).getHeader()) == null || (imageCor20Header.getFlags() & 0x10) != 16) continue;
            return imageCor20Header.getEntryPointVA();
        }
        return null;
    }

    private void processDebug(OptionalHeader optionalHeader, NTHeader ntHeader, Map<SectionHeader, Address> sectionToAddress, Program program, List<Option> options, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("[" + program.getName() + "]: processing debug information...");
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        if (dataDirectories.length <= 6) {
            return;
        }
        DebugDataDirectory ddd = (DebugDataDirectory)dataDirectories[6];
        if (ddd == null) {
            return;
        }
        DebugDirectoryParser parser = ddd.getParser();
        if (parser == null) {
            return;
        }
        this.processDebug(parser, ntHeader, sectionToAddress, program, options, monitor);
    }

    @Override
    public String getName() {
        return PE_NAME;
    }

    public static class CompilerOpinion {
        static final char[] errString_borland = "This program must be run under Win32\r\n$".toCharArray();
        static final char[] errString_GCC_VS = "This program cannot be run in DOS mode.\r\r\n$".toCharArray();
        static final char[] errString_Clang = "This program cannot be run in DOS mode.$".toCharArray();
        static final byte[] asm16_Borland = new byte[]{-70, 16, 0, 14, 31, -76, 9, -51, 33, -72, 1, 76, -51, 33, -112, -112};
        static final byte[] asm16_GCC_VS_Clang = new byte[]{14, 31, -70, 14, 0, -76, 9, -51, 33, -72, 1, 76, -51, 33};
        static final byte[] THIS_BYTES = "This".getBytes();

        private static boolean compareBytesToChars(byte[] bytearray, int bytestart, char[] chararray) {
            int i;
            if (bytestart + chararray.length < bytearray.length) {
                for (i = 0; i < chararray.length && chararray[i] == (char)bytearray[bytestart + i]; ++i) {
                }
            }
            return i == chararray.length;
        }

        public static CompilerEnum getOpinion(PortableExecutable pe, ByteProvider provider, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
            DOSHeader dh;
            BinaryReader br;
            CompilerEnum errStringChoice;
            CompilerEnum asmChoice;
            CompilerEnum offsetChoice;
            block36: {
                offsetChoice = CompilerEnum.Unknown;
                asmChoice = CompilerEnum.Unknown;
                errStringChoice = CompilerEnum.Unknown;
                br = new BinaryReader(provider, true);
                dh = pe.getDOSHeader();
                try {
                    if (program == null || !RustUtilities.isRust(program, program.getMemory().getBlock(".rdata"), monitor)) break block36;
                    try {
                        int extensionCount = RustUtilities.addExtensions(program, monitor, "windows");
                        log.appendMsg("Installed " + extensionCount + " Rust cspec extensions");
                    }
                    catch (IOException e) {
                        log.appendMsg("Rust error: " + e.getMessage());
                    }
                    return CompilerEnum.Rustc;
                }
                catch (CancelledException e) {
                    // empty catch block
                }
            }
            List<String> sectionNames = Arrays.stream(pe.getNTHeader().getFileHeader().getSectionHeaders()).map(section -> section.getName()).toList();
            if (SwiftUtils.isSwift(sectionNames)) {
                return CompilerEnum.Swift;
            }
            if (pe.getNTHeader().getOptionalHeader().isCLI()) {
                return CompilerEnum.CLI;
            }
            if (dh.e_lfanew() == 128) {
                offsetChoice = CompilerEnum.GCC_VS;
            } else if (dh.e_lfanew() == 120) {
                offsetChoice = CompilerEnum.Clang;
            } else if (dh.e_lfanew() >= 128) {
                int val1 = br.readInt(128L);
                int val2 = br.readInt(132L);
                if (val1 != 0 && val2 != 0 && (val1 ^ val2) == 1399742788) {
                    return CompilerEnum.VisualStudio;
                }
                if (dh.e_lfanew() == 256) {
                    offsetChoice = CompilerEnum.BorlandPascal;
                } else if (dh.e_lfanew() == 512) {
                    offsetChoice = CompilerEnum.BorlandCpp;
                } else if (dh.e_lfanew() > 768) {
                    return CompilerEnum.Unknown;
                }
            }
            byte[] asm = provider.readBytes(64L, 256L);
            asmChoice = CompilerEnum.Unknown;
            if (Arrays.compare(asm, 0, asm16_Borland.length, asm16_Borland, 0, asm16_Borland.length) == 0) {
                asmChoice = CompilerEnum.BorlandUnk;
            } else if (Arrays.compare(asm, 0, asm16_GCC_VS_Clang.length, asm16_GCC_VS_Clang, 0, asm16_GCC_VS_Clang.length) == 0) {
                asmChoice = CompilerEnum.GCC_VS_Clang;
            }
            int errStringOffset = Bytes.indexOf((byte[])asm, (byte[])THIS_BYTES);
            if (errStringOffset == -1) {
                asmChoice = CompilerEnum.Unknown;
            } else if (CompilerOpinion.compareBytesToChars(asm, errStringOffset, errString_borland)) {
                if (offsetChoice == CompilerEnum.BorlandCpp || offsetChoice == CompilerEnum.BorlandPascal) {
                    return offsetChoice;
                }
                errStringChoice = CompilerEnum.BorlandUnk;
            } else {
                errStringChoice = CompilerOpinion.compareBytesToChars(asm, errStringOffset, errString_GCC_VS) ? CompilerEnum.GCC_VS : (CompilerOpinion.compareBytesToChars(asm, errStringOffset, errString_Clang) ? CompilerEnum.Clang : CompilerEnum.Unknown);
            }
            if (errStringChoice == CompilerEnum.GCC_VS && asmChoice == CompilerEnum.GCC_VS_Clang && dh.e_lfanew() == 128) {
                if (CompilerOpinion.isGolang(pe, provider)) {
                    return CompilerEnum.GOLANG;
                }
                int ptrSymTable = br.readInt(dh.e_lfanew() + 12);
                if (ptrSymTable != 0) {
                    return CompilerEnum.GCC;
                }
            } else {
                if ((offsetChoice == CompilerEnum.Clang || errStringChoice == CompilerEnum.Clang) && asmChoice == CompilerEnum.GCC_VS_Clang) {
                    return CompilerEnum.Clang;
                }
                if (errStringChoice == CompilerEnum.Unknown || asmChoice == CompilerEnum.Unknown) {
                    return CompilerEnum.Unknown;
                }
            }
            if (errStringChoice == CompilerEnum.BorlandUnk || asmChoice == CompilerEnum.BorlandUnk) {
                return CompilerEnum.BorlandUnk;
            }
            FileHeader fileHeader = pe.getNTHeader().getFileHeader();
            if (fileHeader.getSectionHeader("CODE") != null) {
                return CompilerEnum.BorlandPascal;
            }
            if (fileHeader.getSectionHeader(".bss") != null) {
                return CompilerEnum.GCC;
            }
            if (fileHeader.getSectionHeader(".idata") == null) {
                return CompilerEnum.VisualStudio;
            }
            if (fileHeader.getSectionHeader(".tls") != null) {
                return CompilerEnum.BorlandCpp;
            }
            return CompilerEnum.Unknown;
        }

        private static boolean isGolang(PortableExecutable pe, ByteProvider provider) {
            SectionHeader dataSection;
            boolean buildIdPresent = false;
            boolean buildInfoPresent = false;
            SectionHeader textSection = pe.getNTHeader().getFileHeader().getSectionHeader(".text");
            if (textSection != null) {
                try (InputStream is2 = textSection.getDataStream();){
                    GoBuildId buildId = GoBuildId.read(is2);
                    buildIdPresent = buildId != null;
                }
                catch (IOException is2) {
                    // empty catch block
                }
            }
            if ((dataSection = pe.getNTHeader().getFileHeader().getSectionHeader(".data")) != null) {
                try (InputStream is = dataSection.getDataStream();){
                    buildInfoPresent = GoBuildInfo.isPresent(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return buildIdPresent || buildInfoPresent;
        }

        public static enum CompilerEnum {
            VisualStudio("visualstudio:unknown", "visualstudio"),
            GCC("gcc:unknown", "gcc"),
            Clang("clang:unknown", "clang"),
            BorlandPascal("borland:pascal", "borlanddelphi"),
            BorlandCpp("borland:c++", "borlandcpp"),
            BorlandUnk("borland:unknown", "borlandcpp"),
            CLI("cli", "cli"),
            Rustc("rustc", "rustc"),
            GOLANG("golang", "golang"),
            Swift("swift", "swift"),
            Unknown("unknown", "unknown"),
            GCC_VS(null, null),
            GCC_VS_Clang(null, null);

            public final String label;
            public final String family;

            private CompilerEnum(String label, String secondary) {
                this.label = label;
                this.family = secondary;
            }

            public String toString() {
                return this.label;
            }
        }
    }
}

