/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.plugin.core.analysis.rust.RustUtilities;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.golang.GoBuildId;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.MachHeaderFileTypes;
import ghidra.app.util.bin.format.macho.MachHeaderFlags;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.CorruptLoadCommand;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.DyldExportsTrieCommand;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLinkerCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.EncryptedInformationCommand;
import ghidra.app.util.bin.format.macho.commands.EntryPointCommand;
import ghidra.app.util.bin.format.macho.commands.ExportTrie;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.LinkerOptionCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.PreboundDynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.RunPathCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SubClientCommand;
import ghidra.app.util.bin.format.macho.commands.SubFrameworkCommand;
import ghidra.app.util.bin.format.macho.commands.SubLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.SubUmbrellaCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixups;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImports;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsOffsets;
import ghidra.app.util.bin.format.macho.commands.dyld.BindingTable;
import ghidra.app.util.bin.format.macho.commands.dyld.ClassicBindProcessor;
import ghidra.app.util.bin.format.macho.commands.dyld.ClassicLazyBindProcessor;
import ghidra.app.util.bin.format.macho.commands.dyld.RebaseTable;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandlerFactory;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.MachoProgramUtils;
import ghidra.framework.options.Options;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ExternalSymbolResolver;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.map.LazySortedMap;

public class MachoProgramBuilder {
    public static final String HEADER_SYMBOL = "MACH_HEADER";
    protected MachHeader machoHeader;
    protected Program program;
    protected ByteProvider provider;
    protected FileBytes fileBytes;
    protected MessageLog log;
    protected TaskMonitor monitor;
    protected Memory memory;
    protected Listing listing;
    protected AddressSpace space;
    protected BinaryReader reader;
    private Map<String, AddressSpace> segmentOverlayMap;

    protected MachoProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) {
        this.program = program;
        this.provider = provider;
        this.fileBytes = fileBytes;
        this.log = log;
        this.monitor = monitor;
        this.memory = program.getMemory();
        this.listing = program.getListing();
        this.space = program.getAddressFactory().getDefaultAddressSpace();
        this.reader = new BinaryReader(provider, !this.memory.isBigEndian());
        this.segmentOverlayMap = new HashMap<String, AddressSpace>();
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        MachoProgramBuilder machoProgramBuilder = new MachoProgramBuilder(program, provider, fileBytes, log, monitor);
        machoProgramBuilder.build();
    }

    protected void build() throws Exception {
        this.monitor.setMessage("Completing Mach-O header parsing...");
        this.monitor.setCancelEnabled(false);
        this.machoHeader = new MachHeader(this.provider);
        this.machoHeader.parse();
        this.monitor.setCancelEnabled(true);
        this.setProgramImageBase();
        this.processMemoryBlocks(this.machoHeader, this.provider.getName(), true, true);
        this.processEntryPoint(this.provider.getName());
        boolean exportsFound = this.processExports(this.machoHeader);
        this.processSymbolTables(this.machoHeader, !exportsFound);
        this.processStubs();
        this.processUndefinedSymbols();
        this.processAbsoluteSymbols();
        List<String> libraryPaths = this.processLibraries();
        List<Address> chainedFixups = this.processChainedFixups(libraryPaths);
        this.processDyldInfo(false, libraryPaths);
        this.processSectionRelocations();
        this.processExternalRelocations();
        this.processLocalRelocations();
        this.processEncryption();
        this.processUnsupportedLoadCommands();
        this.processCorruptLoadCommands();
        this.markupHeaders(this.machoHeader, this.setupHeaderAddr(this.machoHeader.getAllSegments()));
        this.markupSections();
        this.markupLoadCommandData(this.machoHeader, this.provider.getName());
        this.markupChainedFixups(this.machoHeader, chainedFixups);
        this.markupProgramVars();
        this.setRelocatableProperty();
        this.setProgramDescription();
        if (GoRttiMapper.isGolangProgram(this.program)) {
            this.markupAndSetGolangInitialProgramProperties();
        }
        this.renameObjMsgSendRtpSymbol();
        this.fixupProgramTree(null);
        this.setCompiler();
    }

    protected void setProgramImageBase() throws Exception {
        this.program.setImageBase(this.getMachoBaseAddress(), true);
    }

    protected Address getMachoBaseAddress() {
        Address lowestAddr = null;
        for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            if (segment.getFileSize() <= 0L) continue;
            Address segmentAddr = this.space.getAddress(segment.getVMaddress());
            if (lowestAddr == null) {
                lowestAddr = segmentAddr;
                continue;
            }
            if (segmentAddr.compareTo((Object)lowestAddr) >= 0) continue;
            lowestAddr = segmentAddr;
        }
        return lowestAddr != null ? lowestAddr : this.space.getAddress(0L);
    }

    protected void processMemoryBlocks(MachHeader header, String source, boolean processSections, boolean allowZeroAddr) throws Exception {
        if (header.getFileType() == 9) {
            return;
        }
        HashSet<Section> overlaySections = new HashSet<Section>();
        List<SegmentCommand> segments = header.getAllSegments();
        this.monitor.initialize((long)segments.size(), "Processing segments for " + source + "...");
        for (SegmentCommand segment : segments) {
            this.monitor.increment();
            if (segment.getSegmentName().equals("__PAGEZERO")) continue;
            if (segment.getVMsize() > 0L && (allowZeroAddr || segment.getVMaddress() != 0L)) {
                if (segment.getFileSize() > 0L && this.createMemoryBlock(segment.getSegmentName(), this.space.getAddress(segment.getVMaddress()), segment.getFileOffset(), segment.getFileSize(), segment.getSegmentName(), source, segment.isRead(), segment.isWrite(), segment.isExecute(), false, false) == null) {
                    this.log.appendMsg(String.format("Failed to create block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
                }
                if (segment.getVMsize() <= segment.getFileSize() || this.createMemoryBlock(segment.getSegmentName(), this.space.getAddress(segment.getVMaddress()).add(segment.getFileSize()), 0L, segment.getVMsize() - segment.getFileSize(), segment.getSegmentName(), source, segment.isRead(), segment.isWrite(), segment.isExecute(), true, false) != null) continue;
                this.log.appendMsg(String.format("Failed to create block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
                continue;
            }
            if (segment.getVMaddress() == 0L || segment.getVMsize() != 0L || segment.getFileSize() <= 0L) continue;
            MemoryBlock overlayBlock = this.createMemoryBlock(segment.getSegmentName(), this.space.getAddress(segment.getVMaddress()), segment.getFileOffset(), segment.getFileSize(), segment.getSegmentName(), source, true, false, false, false, true);
            if (overlayBlock == null) {
                this.log.appendMsg(String.format("Failed to create overlay block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
                continue;
            }
            this.segmentOverlayMap.put(segment.getSegmentName(), overlayBlock.getStart().getAddressSpace());
            overlaySections.addAll(segment.getSections());
        }
        if (processSections) {
            List<Section> sections = header.getAllSections();
            this.monitor.initialize((long)sections.size(), "Processing sections for " + source + "...");
            for (Section section : sections) {
                AddressSpace sectionSpace;
                this.monitor.increment();
                AddressSpace addressSpace = sectionSpace = overlaySections.contains(section) ? this.segmentOverlayMap.get(section.getSegmentName()) : this.space;
                if (section.getSize() <= 0L || section.getOffset() <= 0 && section.getType() != 1 || !allowZeroAddr && section.getAddress() == 0L || this.createMemoryBlock(section.getSectionName(), sectionSpace.getAddress(section.getAddress()), section.getOffset(), section.getSize(), section.getSegmentName(), source, section.isRead(), section.isWrite(), section.isExecute(), section.getType() == 1, false) != null) continue;
                this.log.appendMsg(String.format("Failed to create block: %s.%s 0x%x 0x%x %s", section.getSegmentName(), section.getSectionName(), section.getAddress(), section.getSize(), source));
            }
        }
    }

    private MemoryBlock createMemoryBlock(String name, Address start, long dataOffset, long dataLength, String comment, String source, boolean r, boolean w, boolean x, boolean zeroFill, boolean overlay) throws Exception {
        ArrayList<MemoryBlock> intersectingBlocks = new ArrayList<MemoryBlock>();
        AddressSet range = new AddressSet(start, start.add(dataLength - 1L));
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (!range.intersects(block.getStart(), block.getEnd())) continue;
            intersectingBlocks.add(block);
        }
        if (intersectingBlocks.isEmpty()) {
            if (zeroFill) {
                return MemoryBlockUtils.createUninitializedBlock(this.program, overlay, name, start, dataLength, comment, source, r, w, x, this.log);
            }
            return MemoryBlockUtils.createInitializedBlock(this.program, overlay, name, start, this.fileBytes, dataOffset, dataLength, comment, source, r, w, x, this.log);
        }
        MemoryBlock startingBlock = (MemoryBlock)intersectingBlocks.get(0);
        if (start.compareTo((Object)startingBlock.getStart()) > 0) {
            this.memory.split(startingBlock, start);
        }
        MemoryBlock endingBlock = (MemoryBlock)intersectingBlocks.get(intersectingBlocks.size() - 1);
        if (start.add(dataLength - 1L).compareTo((Object)endingBlock.getEnd()) < 0) {
            this.memory.split(endingBlock, start.add(dataLength));
            MemoryBlock newEndingBlock = this.memory.getBlock(start.add(dataLength));
            newEndingBlock.setName(endingBlock.getName());
            newEndingBlock.setSourceName(endingBlock.getSourceName());
            newEndingBlock.setComment(endingBlock.getComment());
        }
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (!range.intersects(block.getStart(), block.getEnd())) continue;
            block.setName(name);
            block.setPermissions(r, w, x);
            block.setSourceName(source);
            block.setComment(comment);
        }
        return this.memory.getBlock(start);
    }

    protected void fixupProgramTree(String suffix) throws Exception {
        if (suffix == null) {
            suffix = "";
        }
        ProgramModule rootModule = this.listing.getDefaultRootModule();
        for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            AddressSpace segmentSpace = this.segmentOverlayMap.getOrDefault(segment.getSegmentName(), this.space);
            Address segmentStart = segmentSpace.getAddress(segment.getVMaddress());
            Address segmentEnd = segmentStart.add(segment.getVMsize() - 1L);
            if (!this.memory.contains(segmentStart)) continue;
            if (!this.memory.contains(segmentEnd)) {
                segmentEnd = this.memory.getBlock(segmentStart).getEnd();
            }
            String segmentName = segment.getSegmentName();
            String noSectionsName = segmentName + " <no section>" + suffix;
            ProgramFragment segmentFragment = null;
            for (Group group : rootModule.getChildren()) {
                ProgramFragment fragment;
                if (!(group instanceof ProgramFragment) || !(fragment = (ProgramFragment)group).getName().equals(segmentName)) continue;
                fragment.setName(noSectionsName);
                segmentFragment = fragment;
                break;
            }
            if (segmentFragment == null) {
                if (segment.getVMsize() == 0L && segment.getFileSize() == 0L) continue;
                this.log.appendMsg("Could not find/fixup segment in Program Tree: " + segmentName);
                continue;
            }
            ProgramModule segmentModule = rootModule.createModule(segmentName + suffix);
            try {
                segmentModule.reparent(noSectionsName, rootModule);
            }
            catch (NotFoundException e) {
                this.log.appendException((Throwable)e);
                continue;
            }
            for (Section section : segment.getSections()) {
                if (section.getSize() == 0L) continue;
                Address sectionStart = segmentSpace.getAddress(section.getAddress());
                Address sectionEnd = sectionStart.add(section.getSize() - 1L);
                if (!this.memory.contains(sectionStart)) {
                    this.log.appendMsg("Warning: Section %s.%s is not contained within its segment".formatted(section.getSegmentName(), section.getSectionName()));
                    continue;
                }
                if (!this.memory.contains(sectionEnd)) {
                    sectionEnd = this.memory.getBlock(sectionStart).getEnd();
                }
                ProgramFragment sectionFragment = segmentModule.createFragment(String.format("%s %s", section.getSegmentName(), section.getSectionName() + suffix));
                sectionFragment.move(sectionStart, sectionEnd);
            }
            if (!segmentFragment.isEmpty()) continue;
            segmentModule.removeChild(segmentFragment.getName());
        }
        for (Group group : rootModule.getChildren()) {
            ProgramFragment fragment;
            if (!(group instanceof ProgramFragment) || !(fragment = (ProgramFragment)group).getName().equals("EXTERNAL")) continue;
            fragment.setName("EXTERNAL" + suffix);
            break;
        }
    }

    protected void processEntryPoint(String source) throws Exception {
        this.monitor.setMessage("Processing entry point...");
        boolean LC_MAIN_PRIORITY = true;
        int LC_UNIX_THREAD_PRIORITY = 2;
        int LC_THREAD_PRIORITY = 3;
        LazySortedMap priorityMap = LazySortedMap.lazySortedMap(new TreeMap(), () -> new ArrayList());
        for (EntryPointCommand cmd : this.machoHeader.getLoadCommands(EntryPointCommand.class)) {
            SegmentCommand segment;
            long offset = cmd.getEntryOffset();
            if (offset <= 0L || (segment = this.machoHeader.getSegment("__TEXT")) == null) continue;
            ((List)priorityMap.get(1)).add(this.space.getAddress(segment.getVMaddress()).add(offset));
        }
        for (ThreadCommand threadCommand : this.machoHeader.getLoadCommands(ThreadCommand.class)) {
            int priority;
            int n = priority = threadCommand.getCommandType() == 5 ? 2 : 3;
            long pointer = threadCommand.getInitialInstructionPointer();
            if (pointer == -1L) continue;
            ((List)priorityMap.get(priority)).add(this.space.getAddress(pointer));
        }
        if (!priorityMap.isEmpty()) {
            boolean realEntryFound = false;
            for (List addrs : priorityMap.values()) {
                for (Address addr : addrs) {
                    if (!realEntryFound) {
                        this.program.getSymbolTable().createLabel(addr, "entry", SourceType.IMPORTED);
                        this.program.getSymbolTable().addExternalEntryPoint(addr);
                        MachoProgramBuilder.createOneByteFunction(this.program, "entry", addr);
                        realEntryFound = true;
                        continue;
                    }
                    this.log.appendMsg("Ignoring entry point at " + String.valueOf(addr) + " in " + source);
                }
            }
        }
    }

    protected boolean processExports(MachHeader header) throws Exception {
        ArrayList<ExportTrie.ExportEntry> exports = new ArrayList<ExportTrie.ExportEntry>();
        List<DyldInfoCommand> dyldInfoCommands = header.getLoadCommands(DyldInfoCommand.class);
        for (DyldInfoCommand dyldInfoCommand : dyldInfoCommands) {
            exports.addAll(dyldInfoCommand.getExportTrie().getExports(e -> !e.isReExport()));
        }
        List<DyldExportsTrieCommand> dyldExportsTrieCommands = header.getLoadCommands(DyldExportsTrieCommand.class);
        for (DyldExportsTrieCommand dyldExportsTreeCommand : dyldExportsTrieCommands) {
            exports.addAll(dyldExportsTreeCommand.getExportTrie().getExports(e -> !e.isReExport()));
        }
        if (exports.isEmpty()) {
            return false;
        }
        SegmentCommand segmentCommand = header.getSegment("__TEXT");
        if (segmentCommand == null) {
            this.log.appendMsg("Cannot process exports, __TEXT segment not found!");
            return false;
        }
        Address baseAddr = this.space.getAddress(segmentCommand.getVMaddress());
        this.monitor.initialize((long)exports.size(), "Processing exports...");
        for (ExportTrie.ExportEntry export : exports) {
            this.monitor.increment();
            String name = SymbolUtilities.replaceInvalidChars((String)export.name(), (boolean)true);
            try {
                this.processNewExport(baseAddr, export, name);
            }
            catch (AddressOutOfBoundsException e2) {
                this.log.appendMsg("Failed to process export '" + String.valueOf(export) + "': " + e2.getMessage());
            }
            catch (Exception e3) {
                this.log.appendMsg("Unable to create symbol: " + e3.getMessage());
            }
        }
        return !exports.isEmpty();
    }

    protected void processNewExport(Address baseAddr, ExportTrie.ExportEntry export, String name) throws AddressOutOfBoundsException, Exception {
        Address exportAddr = baseAddr.add(export.address());
        this.program.getSymbolTable().addExternalEntryPoint(exportAddr);
        this.program.getSymbolTable().createLabel(exportAddr, name, SourceType.IMPORTED);
    }

    protected void processSymbolTables(MachHeader header, boolean processExports) throws Exception {
        SymbolTable symbolTable = this.program.getSymbolTable();
        List<SymbolTableCommand> commands = header.getLoadCommands(SymbolTableCommand.class);
        for (SymbolTableCommand symbolTableCommand : commands) {
            List<NList> symbols = symbolTableCommand.getSymbols();
            this.monitor.initialize((long)symbols.size(), "Processing symbol tables...");
            for (NList symbol : symbols) {
                String string;
                this.monitor.increment();
                if (symbol.isTypePreboundUndefined() || symbol.isLazyBind()) continue;
                Address addr = this.space.getAddress(symbol.getValue());
                if (symbol.isSymbolicDebugging() || symbol.isTypeAbsolute() || symbol.isTypeUndefined() || symbol.isIndirect()) continue;
                if (processExports && symbol.isExternal()) {
                    symbolTable.addExternalEntryPoint(addr);
                }
                if ((string = symbol.getString()).length() == 0) continue;
                string = SymbolUtilities.replaceInvalidChars((String)string, (boolean)true);
                if (symbol.isThumbSymbol()) {
                    this.markAsThumb(addr);
                }
                if (symbolTable.getGlobalSymbol(string, addr) != null) continue;
                try {
                    if (symbol.isExternal() && !processExports) continue;
                    Symbol primary = symbolTable.getPrimarySymbol(addr);
                    Symbol newSymbol = symbolTable.createLabel(addr, string, SourceType.IMPORTED);
                    if (primary != null && primary.getName().equals("<redacted>")) {
                        newSymbol.setPrimary();
                    }
                    if (!symbol.isExternal()) continue;
                    symbolTable.addExternalEntryPoint(addr);
                }
                catch (Exception e) {
                    this.log.appendMsg("Unable to create symbol: " + e.getMessage());
                }
            }
        }
    }

    protected void processStubs() throws Exception {
        SymbolTableCommand symbolTableCommand = this.machoHeader.getFirstLoadCommand(SymbolTableCommand.class);
        DynamicSymbolTableCommand dynamicCommand = this.machoHeader.getFirstLoadCommand(DynamicSymbolTableCommand.class);
        if (dynamicCommand == null) {
            return;
        }
        List<Integer> indirectSymbols = dynamicCommand.getIndirectSymbols();
        if (indirectSymbols.size() == 0) {
            return;
        }
        for (Section section : this.machoHeader.getAllSections()) {
            this.monitor.checkCancelled();
            if (section.getSize() == 0L || section.getType() != 8) continue;
            int indirectSymbolTableIndex = section.getReserved1();
            int symbolSize = this.machoHeader.getAddressSize();
            if (section.getType() == 8) {
                symbolSize = section.getReserved2();
            }
            int nSymbols = (int)section.getSize() / symbolSize;
            Address startAddr = this.space.getAddress(section.getAddress());
            this.monitor.initialize((long)nSymbols, "Processing stubs...");
            for (int i = indirectSymbolTableIndex; i < indirectSymbolTableIndex + nSymbols; ++i) {
                Function stubFunc;
                this.monitor.increment();
                int symbolIndex = indirectSymbols.get(i);
                NList symbol = symbolTableCommand.getSymbolAt(symbolIndex);
                String name = null;
                if (symbol != null) {
                    name = SymbolUtilities.replaceInvalidChars((String)symbol.getString(), (boolean)true);
                }
                if ((stubFunc = MachoProgramBuilder.createOneByteFunction(this.program, name, startAddr)) != null && symbol != null) {
                    ExternalLocation loc = this.program.getExternalManager().addExtLocation("<EXTERNAL>", name, null, SourceType.IMPORTED);
                    stubFunc.setThunkedFunction(loc.createFunction());
                }
                startAddr = startAddr.add((long)symbolSize);
            }
        }
    }

    protected void processUndefinedSymbols() throws Exception {
        ArrayList<NList> undefinedSymbols = new ArrayList<NList>();
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (!(command instanceof SymbolTableCommand)) continue;
            SymbolTableCommand symbolTableCommand = (SymbolTableCommand)command;
            List<NList> symbols = symbolTableCommand.getSymbols();
            this.monitor.initialize((long)symbols.size(), "Collectiing undefined symbols...");
            for (NList symbol : symbols) {
                List globalSymbols;
                this.monitor.increment();
                if (symbol.isSymbolicDebugging() || !symbol.isTypeUndefined() || !(globalSymbols = this.program.getSymbolTable().getLabelOrFunctionSymbols(symbol.getString(), null)).isEmpty()) continue;
                undefinedSymbols.add(symbol);
            }
        }
        if (undefinedSymbols.size() == 0) {
            return;
        }
        try {
            Address addr = AbstractProgramLoader.addExternalBlock(this.program, undefinedSymbols.size() * this.machoHeader.getAddressSize(), this.log);
            this.monitor.initialize((long)undefinedSymbols.size(), "Processing undefined symbols...");
            for (NList symbol : undefinedSymbols) {
                this.monitor.increment();
                try {
                    String name = SymbolUtilities.replaceInvalidChars((String)symbol.getString(), (boolean)true);
                    if (name != null && name.length() > 0) {
                        this.program.getSymbolTable().createLabel(addr, name, SourceType.IMPORTED);
                        this.program.getExternalManager().addExtLocation("<EXTERNAL>", name, null, SourceType.IMPORTED);
                    }
                }
                catch (Exception e) {
                    this.log.appendMsg("Unable to create undefined symbol: " + e.getMessage());
                }
                addr = addr.add((long)this.machoHeader.getAddressSize());
            }
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to create undefined memory block: " + e.getMessage());
        }
    }

    protected void processAbsoluteSymbols() throws Exception {
        ArrayList<NList> absoluteSymbols = new ArrayList<NList>();
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand loadCommand : commands) {
            this.monitor.checkCancelled();
            if (!(loadCommand instanceof SymbolTableCommand)) continue;
            SymbolTableCommand symbolTableCommand = (SymbolTableCommand)loadCommand;
            List<NList> symbols = symbolTableCommand.getSymbols();
            this.monitor.initialize((long)symbols.size(), "Collecting absolute symbols...");
            for (NList symbol : symbols) {
                this.monitor.increment();
                if (symbol.isSymbolicDebugging() || !symbol.isTypeAbsolute()) continue;
                absoluteSymbols.add(symbol);
            }
        }
        if (absoluteSymbols.size() == 0) {
            return;
        }
        Address start = MachoProgramUtils.getNextAvailableAddress(this.program);
        try {
            this.memory.createUninitializedBlock("ABSOLUTE", start, (long)(absoluteSymbols.size() * this.machoHeader.getAddressSize()), false);
            this.monitor.initialize((long)absoluteSymbols.size(), "Processing absolute symbols...");
            for (NList symbol : absoluteSymbols) {
                this.monitor.increment();
                try {
                    String name = SymbolUtilities.replaceInvalidChars((String)symbol.getString(), (boolean)true);
                    if (name != null && name.length() > 0) {
                        this.program.getSymbolTable().createLabel(start, name, SourceType.IMPORTED);
                    }
                }
                catch (Exception e) {
                    this.log.appendMsg("Unable to create absolute symbol: " + e.getMessage());
                }
                start = start.add((long)this.machoHeader.getAddressSize());
            }
        }
        catch (Exception exception) {
            this.log.appendMsg("Unable to create absolute memory block: " + exception.getMessage());
        }
    }

    public List<Address> processChainedFixups(List<String> libraryPaths) throws Exception {
        ArrayList<DyldFixup> fixups;
        Address imagebase;
        block4: {
            int headStartOffset;
            Section threadStartsSection;
            block5: {
                SymbolTable symbolTable;
                block3: {
                    this.monitor.setMessage("Fixing up chained pointers...");
                    symbolTable = this.program.getSymbolTable();
                    imagebase = this.getMachoBaseAddress();
                    fixups = new ArrayList<DyldFixup>();
                    List<DyldChainedFixupsCommand> loadCommands = this.machoHeader.getLoadCommands(DyldChainedFixupsCommand.class);
                    if (loadCommands.isEmpty()) break block3;
                    BinaryReader memReader = new BinaryReader(new MemoryByteProvider(this.memory, imagebase), !this.memory.isBigEndian());
                    for (DyldChainedFixupsCommand loadCommand : loadCommands) {
                        this.monitor.checkCancelled();
                        fixups.addAll(loadCommand.getChainedFixups(memReader, imagebase.getOffset(), symbolTable, this.log, this.monitor));
                    }
                    break block4;
                }
                Section chainStartsSection = this.machoHeader.getSection("__TEXT", "__chain_starts");
                threadStartsSection = this.machoHeader.getSection("__TEXT", "__thread_starts");
                if (chainStartsSection == null || chainStartsSection.getAddress() == 0L || chainStartsSection.getSize() == 0L) break block5;
                this.reader.setPointerIndex(chainStartsSection.getOffset());
                DyldChainedStartsOffsets chainedStartsOffsets = new DyldChainedStartsOffsets(this.reader);
                for (int offset : chainedStartsOffsets.getChainStartOffsets()) {
                    this.monitor.checkCancelled();
                    fixups.addAll(DyldChainedFixups.getChainedFixups(this.reader, null, chainedStartsOffsets.getPointerFormat(), offset, 0L, 0L, imagebase.getOffset(), symbolTable, this.log, this.monitor));
                }
                break block4;
            }
            if (threadStartsSection == null || threadStartsSection.getAddress() == 0L || threadStartsSection.getSize() == 0L) break block4;
            Address threadSectionStart = this.space.getAddress(threadStartsSection.getAddress());
            Address threadSectionEnd = threadSectionStart.add(threadStartsSection.getSize() - 1L);
            long nextOffSize = (this.memory.getInt(threadSectionStart) & 1) * 4 + 4;
            Address chainHead = threadSectionStart.add(4L);
            while (chainHead.compareTo((Object)threadSectionEnd) < 0 && !this.monitor.isCancelled() && (headStartOffset = this.memory.getInt(chainHead)) != -1 && headStartOffset != 0) {
                long chainStart = Integer.toUnsignedLong(headStartOffset);
                fixups.addAll(DyldChainedFixups.processPointerChain(this.reader, chainStart, nextOffSize, imagebase.getOffset(), this.log, this.monitor));
                chainHead = chainHead.add(4L);
            }
        }
        return DyldChainedFixups.fixupChainedPointers(fixups, this.program, imagebase, libraryPaths, this.log, this.monitor);
    }

    protected void processDyldInfo(boolean doClassic, List<String> libraryPaths) throws Exception {
        List<DyldInfoCommand> commands = this.machoHeader.getLoadCommands(DyldInfoCommand.class);
        for (DyldInfoCommand command : commands) {
            this.processRebases(command.getRebaseTable());
            this.processBindings(command.getBindingTable(), libraryPaths);
            this.processBindings(command.getLazyBindingTable(), libraryPaths);
            this.processBindings(command.getWeakBindingTable(), libraryPaths);
        }
        if (commands.size() == 0 && doClassic) {
            ClassicBindProcessor classicBindProcess = new ClassicBindProcessor(this.machoHeader, this.program);
            try {
                classicBindProcess.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
            ClassicLazyBindProcessor classicLazyBindProcess = new ClassicLazyBindProcessor(this.machoHeader, this.program);
            try {
                classicLazyBindProcess.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
        }
    }

    private void processRebases(RebaseTable rebaseTable) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBindings(BindingTable bindingTable, List<String> libraryPaths) throws Exception {
        DataConverter converter = DataConverter.getInstance((boolean)this.program.getLanguage().isBigEndian());
        SymbolTable symbolTable = this.program.getSymbolTable();
        Address imagebase = this.getMachoBaseAddress();
        List<BindingTable.Binding> bindings = bindingTable.getBindings();
        List<BindingTable.Binding> threadedBindings = bindingTable.getThreadedBindings();
        List<SegmentCommand> segments = this.machoHeader.getAllSegments();
        if (threadedBindings != null) {
            DyldChainedImports chainedImports = new DyldChainedImports(bindings);
            this.monitor.initialize((long)threadedBindings.size(), "Processing threaded bindings...");
            for (BindingTable.Binding threadedBinding : threadedBindings) {
                this.monitor.increment();
                List<DyldFixup> fixups = DyldChainedFixups.getChainedFixups(this.reader, chainedImports, DyldChainedPtr.DyldChainType.DYLD_CHAINED_PTR_ARM64E, segments.get(threadedBinding.getSegmentIndex()).getFileOffset(), threadedBinding.getSegmentOffset(), 0L, imagebase.getOffset(), symbolTable, this.log, this.monitor);
                DyldChainedFixups.fixupChainedPointers(fixups, this.program, imagebase, libraryPaths, this.log, this.monitor);
            }
        } else {
            this.monitor.initialize((long)bindings.size(), "Processing bindings...");
            for (BindingTable.Binding binding : bindings) {
                this.monitor.increment();
                if (binding.getUnknownOpcode() != null) {
                    this.log.appendMsg("Unknown bind opcode: 0x%x".formatted(binding.getUnknownOpcode()));
                    continue;
                }
                List symbols = symbolTable.getGlobalSymbols(binding.getSymbolName());
                if (symbols.isEmpty()) continue;
                Symbol symbol = (Symbol)symbols.get(0);
                long offset = symbol.getAddress().getOffset();
                byte[] bytes = this.program.getDefaultPointerSize() == 8 ? converter.getBytes(offset) : converter.getBytes((int)offset);
                Address addr = this.space.getAddress(segments.get(binding.getSegmentIndex()).getVMaddress() + binding.getSegmentOffset());
                try {
                    MachoProgramBuilder.fixupExternalLibrary(this.program, libraryPaths, binding.getLibraryOrdinal(), symbol.getName());
                }
                catch (Exception e) {
                    this.log.appendMsg("WARNING: Problem fixing up symbol '%s' - %s".formatted(symbol.getName(), e.getMessage()));
                }
                boolean success = false;
                try {
                    this.program.getMemory().setBytes(addr, bytes);
                    success = true;
                }
                catch (MemoryAccessException e) {
                    try {
                        this.handleRelocationError(addr, String.format("Relocation failure at address %s: error accessing memory.", addr));
                    }
                    catch (Throwable throwable) {
                        this.program.getRelocationTable().add(addr, success ? Relocation.Status.APPLIED : Relocation.Status.FAILURE, binding.getType(), null, bytes.length, binding.getSymbolName());
                        throw throwable;
                    }
                    this.program.getRelocationTable().add(addr, success ? Relocation.Status.APPLIED : Relocation.Status.FAILURE, binding.getType(), null, bytes.length, binding.getSymbolName());
                    continue;
                }
                this.program.getRelocationTable().add(addr, success ? Relocation.Status.APPLIED : Relocation.Status.FAILURE, binding.getType(), null, bytes.length, binding.getSymbolName());
            }
        }
    }

    protected void markupHeaders(MachHeader header, Address headerAddr) throws Exception {
        if (headerAddr == null) {
            return;
        }
        try {
            DataUtilities.createData((Program)this.program, (Address)headerAddr, (DataType)header.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            this.program.getSymbolTable().createLabel(headerAddr, HEADER_SYMBOL, SourceType.IMPORTED);
            this.monitor.initialize((long)header.getLoadCommands().size(), "Marking up header...");
            for (LoadCommand loadCommand : header.getLoadCommands()) {
                this.monitor.increment();
                Address loadCommandAddr = headerAddr.add(loadCommand.getStartIndex() - header.getStartIndexInProvider());
                DataType loadCommandDataType = loadCommand.toDataType();
                DataUtilities.createData((Program)this.program, (Address)loadCommandAddr, (DataType)loadCommandDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.listing.setComment(loadCommandAddr, CommentType.PRE, LoadCommandTypes.getLoadCommandName(loadCommand.getCommandType()));
                if (loadCommand instanceof SegmentCommand) {
                    SegmentCommand segmentCommand = (SegmentCommand)loadCommand;
                    this.listing.setComment(loadCommandAddr, CommentType.EOL, segmentCommand.getSegmentName());
                    int sectionOffset = loadCommandDataType.getLength();
                    for (Section section : segmentCommand.getSections()) {
                        DataType sectionDataType = section.toDataType();
                        Address sectionAddr = loadCommandAddr.add((long)sectionOffset);
                        DataUtilities.createData((Program)this.program, (Address)sectionAddr, (DataType)sectionDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                        this.listing.setComment(sectionAddr, CommentType.EOL, section.getSegmentName() + "." + section.getSectionName());
                        sectionOffset += sectionDataType.getLength();
                    }
                    continue;
                }
                if (loadCommand instanceof DynamicLinkerCommand) {
                    DynamicLinkerCommand dynamicLinkerCommand = (DynamicLinkerCommand)loadCommand;
                    LoadCommandString name = dynamicLinkerCommand.getLoadCommandString();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof DynamicLibraryCommand) {
                    DynamicLibraryCommand dynamicLibraryCommand = (DynamicLibraryCommand)loadCommand;
                    LoadCommandString name = dynamicLibraryCommand.getDynamicLibrary().getName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof RunPathCommand) {
                    RunPathCommand runPathCommand = (RunPathCommand)loadCommand;
                    LoadCommandString path = runPathCommand.getPath();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)path.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - path.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubFrameworkCommand) {
                    SubFrameworkCommand subFrameworkCommand = (SubFrameworkCommand)loadCommand;
                    LoadCommandString name = subFrameworkCommand.getUmbrellaFrameworkName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubClientCommand) {
                    SubClientCommand subClientCommand = (SubClientCommand)loadCommand;
                    LoadCommandString name = subClientCommand.getClientName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubLibraryCommand) {
                    SubLibraryCommand subLibraryCommand = (SubLibraryCommand)loadCommand;
                    LoadCommandString name = subLibraryCommand.getSubLibraryName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubUmbrellaCommand) {
                    SubUmbrellaCommand subUmbrellaCommand = (SubUmbrellaCommand)loadCommand;
                    LoadCommandString name = subUmbrellaCommand.getSubUmbrellaFrameworkName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof FileSetEntryCommand) {
                    FileSetEntryCommand fileSetEntryCommand = (FileSetEntryCommand)loadCommand;
                    LoadCommandString name = fileSetEntryCommand.getFileSetEntryId();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (!(loadCommand instanceof LinkerOptionCommand)) continue;
                LinkerOptionCommand linkerOptionCommand = (LinkerOptionCommand)loadCommand;
                List<String> linkerOptions = linkerOptionCommand.getLinkerOptions();
                int offset = linkerOptionCommand.toDataType().getLength();
                for (int i = 0; i < linkerOptions.size(); ++i) {
                    Address addr = loadCommandAddr.add((long)offset);
                    int len = linkerOptions.get(i).length() + 1;
                    if (i == linkerOptions.size() - 1) {
                        len = (int)(NumericUtilities.getUnsignedAlignedValue((long)addr.add((long)len).getOffset(), (long)4L) - addr.getOffset());
                    }
                    DataUtilities.createData((Program)this.program, (Address)addr, (DataType)StructConverter.STRING, (int)len, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    offset += len;
                }
            }
        }
        catch (CodeUnitInsertionException e) {
            this.log.appendMsg("Error laying down header structures " + String.valueOf((Object)e));
        }
    }

    protected Address setupHeaderAddr(Collection<SegmentCommand> segments) throws AddressOverflowException {
        Address headerAddr = null;
        long lowestFileOffset = Long.MAX_VALUE;
        for (SegmentCommand segment : segments) {
            if (segment.getFileOffset() == 0L && segment.getFileSize() == 0L) continue;
            if (segment.getFileOffset() == 0L) {
                return this.space.getAddress(segment.getVMaddress());
            }
            lowestFileOffset = Math.min(lowestFileOffset, segment.getFileOffset());
        }
        headerAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
        MemoryBlock headerBlock = MemoryBlockUtils.createInitializedBlock(this.program, true, "HEADER", headerAddr, this.fileBytes, 0L, lowestFileOffset, "Header", "", false, false, false, this.log);
        return headerBlock.getStart();
    }

    protected void markupSections() throws Exception {
        if (this.machoHeader.getFileType() == 9) {
            return;
        }
        for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            this.monitor.checkCancelled();
            if (segment.isAppleProtected()) {
                String msg = "Warning:  " + this.program.getName() + " contains encrypted segment: " + segment.getSegmentName();
                this.log.appendMsg(msg);
                Msg.showWarn((Object)this, null, (String)"Encrypted Binary", (Object)msg);
                continue;
            }
            List<Section> sections = segment.getSections();
            this.monitor.initialize((long)sections.size(), "Marking up sections...");
            for (Section section : sections) {
                MemoryBlock block;
                this.monitor.increment();
                if (section.getSize() == 0L || (block = this.getMemoryBlock(section)) == null) continue;
                if (section.getSectionName().equals("__chain_starts")) {
                    this.reader.setPointerIndex(section.getOffset());
                    DyldChainedStartsOffsets chainedStartsOffsets = new DyldChainedStartsOffsets(this.reader);
                    DataUtilities.createData((Program)this.program, (Address)block.getStart(), (DataType)chainedStartsOffsets.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                } else if (section.getType() == 2) {
                    this.markupBlock(block, (DataType)new TerminatedStringDataType());
                } else if (section.getType() == 3) {
                    this.markupBlock(block, (DataType)new FloatDataType());
                } else if (section.getType() == 4) {
                    this.markupBlock(block, (DataType)new DoubleDataType());
                } else if (section.getType() == 5) {
                    this.markupBlock(block, (DataType)new PointerDataType());
                } else if (section.getType() == 6 || section.getType() == 7) {
                    this.markupBlock(block, (DataType)new PointerDataType());
                } else if (section.getType() != 8 || section.isExecute()) {
                    // empty if block
                }
                if (section.getType() != 7) continue;
                AddressSet set = new AddressSet(block.getStart(), block.getEnd());
                this.processLazyPointerSection((AddressSetView)set);
            }
        }
    }

    protected void processSectionRelocations() throws CancelledException {
        LinkedHashMap<RelocationInfo, Address> relocationMap = new LinkedHashMap<RelocationInfo, Address>();
        for (Section section : this.machoHeader.getAllSections()) {
            this.monitor.checkCancelled();
            MemoryBlock sectionMemoryBlock = this.getMemoryBlock(section);
            if (sectionMemoryBlock == null) {
                if (section.getNumberOfRelocations() <= 0) continue;
                this.log.appendMsg("Unable to process relocations for " + section.getSectionName() + ". No memory block was created.");
                continue;
            }
            List<RelocationInfo> relocations = section.getRelocations();
            this.monitor.initialize((long)relocations.size(), "Processing section relocations...");
            for (RelocationInfo relocationInfo : relocations) {
                this.monitor.increment();
                Address address = sectionMemoryBlock.getStart().add((long)relocationInfo.getAddress());
                relocationMap.put(relocationInfo, address);
            }
        }
        this.performRelocations(relocationMap);
    }

    protected void processExternalRelocations() throws CancelledException {
        LinkedHashMap<RelocationInfo, Address> relocationMap = new LinkedHashMap<RelocationInfo, Address>();
        for (DynamicSymbolTableCommand cmd : this.machoHeader.getLoadCommands(DynamicSymbolTableCommand.class)) {
            this.monitor.checkCancelled();
            List<RelocationInfo> relocations = cmd.getExternalRelocations();
            this.monitor.initialize((long)relocations.size(), "Processing external relocations...");
            for (RelocationInfo relocationInfo : relocations) {
                this.monitor.increment();
                relocationMap.put(relocationInfo, this.space.getAddress((long)relocationInfo.getAddress()));
            }
        }
        this.performRelocations(relocationMap);
    }

    protected void processLocalRelocations() throws CancelledException {
        this.monitor.setMessage("Processing local relocations...");
        LinkedHashMap<RelocationInfo, Address> relocationMap = new LinkedHashMap<RelocationInfo, Address>();
        for (DynamicSymbolTableCommand cmd : this.machoHeader.getLoadCommands(DynamicSymbolTableCommand.class)) {
            this.monitor.checkCancelled();
            List<RelocationInfo> relocations = cmd.getLocalRelocations();
            this.monitor.initialize((long)relocations.size(), "Processing local relocations...");
            for (RelocationInfo relocationInfo : relocations) {
                this.monitor.increment();
                relocationMap.put(relocationInfo, this.space.getAddress((long)relocationInfo.getAddress()));
            }
        }
        this.performRelocations(relocationMap);
    }

    protected List<String> processLibraries() throws Exception {
        Options props = this.program.getOptions("Program Information");
        int libraryIndex = 0;
        ArrayList<String> libraryPaths = new ArrayList<String>();
        List<LoadCommand> loadCommands = this.machoHeader.getLoadCommands();
        this.monitor.initialize((long)loadCommands.size(), "Processing libraries...");
        for (LoadCommand command : loadCommands) {
            int index;
            String libraryName;
            DynamicLibraryCommand dylibCommand;
            this.monitor.increment();
            String libraryPath = null;
            if (command instanceof DynamicLibraryCommand && (dylibCommand = (DynamicLibraryCommand)command).getCommandType() != 13) {
                DynamicLibrary dylib = dylibCommand.getDynamicLibrary();
                libraryPath = dylib.getName().getString();
            } else if (command instanceof SubLibraryCommand) {
                SubLibraryCommand sublibCommand = (SubLibraryCommand)command;
                libraryPath = sublibCommand.getSubLibraryName().getString();
            } else if (command instanceof PreboundDynamicLibraryCommand) {
                PreboundDynamicLibraryCommand pbdlCommand = (PreboundDynamicLibraryCommand)command;
                libraryPath = pbdlCommand.getLibraryName();
            }
            if (libraryPath == null || (libraryName = (index = libraryPath.lastIndexOf("/")) != -1 ? libraryPath.substring(index + 1) : libraryPath).equals(this.program.getName())) continue;
            libraryPaths.add(libraryPath);
            this.addLibrary(libraryPath);
            props.setString(ExternalSymbolResolver.getRequiredLibraryProperty(libraryIndex++), libraryPath);
        }
        if (this.program.getSymbolTable().getLibrarySymbol("<EXTERNAL>") == null) {
            this.program.getSymbolTable().createExternalLibrary("<EXTERNAL>", SourceType.IMPORTED);
        }
        return libraryPaths;
    }

    protected void processEncryption() throws Exception {
        List<EncryptedInformationCommand> cmds = this.machoHeader.getLoadCommands(EncryptedInformationCommand.class);
        this.monitor.initialize((long)cmds.size(), "Processing encryption...");
        for (EncryptedInformationCommand cmd : cmds) {
            this.monitor.increment();
            if (cmd.getCryptID() == 0) continue;
            this.log.appendMsg(String.format("ENCRYPTION DETECTED: (file offset 0x%x, size 0x%x)", cmd.getCryptOffset(), cmd.getCryptSize()));
        }
    }

    protected void processUnsupportedLoadCommands() throws CancelledException {
        List<UnsupportedLoadCommand> cmds = this.machoHeader.getLoadCommands(UnsupportedLoadCommand.class);
        this.monitor.initialize((long)cmds.size(), "Processing unsupported load commands...");
        for (LoadCommand loadCommand : cmds) {
            this.monitor.increment();
            this.log.appendMsg("Skipping unsupported load command: " + LoadCommandTypes.getLoadCommandName(loadCommand.getCommandType()));
        }
    }

    protected void processCorruptLoadCommands() throws CancelledException {
        List<CorruptLoadCommand> cmds = this.machoHeader.getLoadCommands(CorruptLoadCommand.class);
        this.monitor.initialize((long)cmds.size(), "Processing corrupt load commands...");
        for (CorruptLoadCommand cmd : cmds) {
            this.monitor.increment();
            this.log.appendMsg("Skipping corrupt load command: %s (%s: %s)".formatted(LoadCommandTypes.getLoadCommandName(cmd.getCommandType()), cmd.getProblem().getClass().getSimpleName(), cmd.getProblem().getMessage()));
        }
    }

    private void performRelocations(LinkedHashMap<RelocationInfo, Address> relocationMap) throws CancelledException {
        if (relocationMap.isEmpty()) {
            return;
        }
        MachoRelocationHandler handler = MachoRelocationHandlerFactory.getHandler(this.machoHeader);
        if (handler == null) {
            this.log.appendMsg(String.format("No relocation handler for machine type 0x%x", this.machoHeader.getCpuType()));
        }
        Iterator<RelocationInfo> iter = relocationMap.keySet().iterator();
        while (iter.hasNext()) {
            RelocationInfo relocationInfo = iter.next();
            Address address = relocationMap.get(relocationInfo);
            MachoRelocation relocation = null;
            RelocationResult result = RelocationResult.FAILURE;
            if (handler != null) {
                relocation = handler.isPairedRelocation(relocationInfo) ? new MachoRelocation(this.program, this.machoHeader, address, relocationInfo, iter.next()) : new MachoRelocation(this.program, this.machoHeader, address, relocationInfo);
                try {
                    result = handler.relocate(relocation);
                    if (result.status() == Relocation.Status.UNSUPPORTED) {
                        this.handleRelocationError(address, String.format("Relocation type 0x%x at address %s is not supported", relocationInfo.getType(), address));
                    }
                }
                catch (MemoryAccessException e) {
                    this.handleRelocationError(address, String.format("Relocation failure at address %s: error accessing memory.", address));
                }
                catch (RelocationException e) {
                    this.handleRelocationError(address, String.format("Relocation failure at address %s: %s", address, e.getMessage()));
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    msg = String.format("Relocation failure at address %s: %s", address, msg);
                    this.handleRelocationError(address, msg);
                    Msg.error((Object)this, (Object)msg, (Throwable)e);
                }
            }
            this.program.getRelocationTable().add(address, result.status(), relocationInfo.getType(), new long[]{relocationInfo.getValue(), relocationInfo.getLength(), relocationInfo.isPcRelocated() ? 1L : 0L, relocationInfo.isExternal() ? 1L : 0L, relocationInfo.isScattered() ? 1L : 0L}, result.byteLength(), relocation != null ? relocation.getTargetDescription() : null);
        }
    }

    protected void markupLoadCommandData(MachHeader header, String source) throws Exception {
        this.monitor.initialize((long)header.getLoadCommands().size(), "Marking up load command data...");
        for (LoadCommand cmd : header.getLoadCommands()) {
            this.monitor.increment();
            cmd.markup(this.program, header, source, this.monitor, this.log);
        }
    }

    private void handleRelocationError(Address address, String message) {
        this.program.getBookmarkManager().setBookmark(address, "Error", "Relocations", message);
        this.log.appendMsg(message);
    }

    private void addLibrary(String library) {
        library = SymbolUtilities.replaceInvalidChars((String)library, (boolean)true);
        try {
            this.program.getExternalManager().addExternalLibraryName(library, SourceType.IMPORTED);
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to add external library name: " + e.getMessage());
        }
    }

    private MemoryBlock getMemoryBlock(Section section) {
        Address blockAddress = this.space.getAddress(section.getAddress());
        return this.memory.getBlock(blockAddress);
    }

    private void markupBlock(MemoryBlock block, DataType datatype) throws Exception {
        Address address = block.getStart();
        while (!this.monitor.isCancelled() && address.compareTo((Object)block.getEnd()) <= 0) {
            try {
                this.listing.createData(address, datatype);
                if (datatype instanceof Pointer) {
                    this.fixupThumbPointers(address);
                }
                address = address.add((long)this.listing.getDataAt(address).getLength());
            }
            catch (CodeUnitInsertionException e) {
                if (datatype instanceof TerminatedStringDataType) {
                    this.log.appendMsg("Skipping markup for large string at: " + String.valueOf(address));
                } else if (!(datatype instanceof Pointer)) {
                    this.log.appendMsg("Skipping markup for existing pointer at: " + String.valueOf(address));
                } else {
                    this.log.appendException((Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                return;
            }
        }
    }

    private void fixupThumbPointers(Address address) throws AddressOverflowException {
        Data data = this.listing.getDefinedDataAt(address);
        if (data == null) {
            return;
        }
        Object value = data.getValue();
        if (!(value instanceof Address)) {
            return;
        }
        Address pointerAddress = (Address)value;
        if (pointerAddress.getOffset() % 2L == 0L) {
            return;
        }
        MemoryBlock pointerBlock = this.memory.getBlock(pointerAddress);
        if (pointerBlock == null) {
            return;
        }
        if (!pointerBlock.isExecute()) {
            return;
        }
        Reference[] refs = data.getReferencesFrom();
        ReferenceManager referenceManager = this.program.getReferenceManager();
        for (Reference ref : refs) {
            if (this.monitor.isCancelled()) break;
            if (!ref.getToAddress().equals((Object)pointerAddress)) continue;
            referenceManager.delete(ref);
            Address thumbAddress = ref.getToAddress().subtract(1L);
            referenceManager.addMemoryReference(ref.getFromAddress(), thumbAddress, ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
            try {
                this.markAsThumb(thumbAddress);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
    }

    private void markAsThumb(Address address) throws ContextChangeException, AddressOverflowException {
        if (!this.program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"))) {
            return;
        }
        if ((address.getOffset() & 1L) == 1L) {
            address = address.subtractNoWrap(1L);
        }
        Register tModeRegister = this.program.getLanguage().getRegister("TMode");
        this.program.getProgramContext().setValue(tModeRegister, address, address, BigInteger.ONE);
        MachoProgramBuilder.createOneByteFunction(this.program, null, address);
    }

    private void processLazyPointerSection(AddressSetView set) {
        DataIterator dataIterator = this.listing.getData(set, true);
        block2: while (dataIterator.hasNext() && !this.monitor.isCancelled()) {
            Reference[] references;
            Data data = dataIterator.next();
            for (Reference reference : references = data.getReferencesFrom()) {
                if (this.monitor.isCancelled()) continue block2;
                Symbol fromSymbol = this.program.getSymbolTable().getPrimarySymbol(reference.getFromAddress());
                try {
                    MemoryBlock memoryBlock = this.memory.getBlock(reference.getToAddress());
                    Namespace namespace = this.createNamespace(memoryBlock.getName());
                    this.program.getSymbolTable().createLabel(reference.getToAddress(), fromSymbol.getName(), namespace, SourceType.IMPORTED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Namespace createNamespace(String namespaceName) {
        try {
            return this.program.getSymbolTable().createNameSpace(this.program.getGlobalNamespace(), namespaceName, SourceType.IMPORTED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Namespace namespace = this.program.getSymbolTable().getNamespace(namespaceName, this.program.getGlobalNamespace());
            if (namespace != null) {
                return namespace;
            }
            this.log.appendMsg("Unable to create namespace: " + namespaceName);
            this.log.appendException(e);
            return this.program.getGlobalNamespace();
        }
    }

    public static Function createOneByteFunction(Program program, String name, Address address) {
        FunctionManager functionMgr = program.getFunctionManager();
        Function function = functionMgr.getFunctionAt(address);
        if (function != null) {
            return function;
        }
        try {
            return functionMgr.createFunction(name, address, (AddressSetView)new AddressSet(address), SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (OverlappingFunctionException overlappingFunctionException) {
            // empty catch block
        }
        return null;
    }

    protected void markupChainedFixups(MachHeader header, List<Address> chainedFixups) throws CancelledException {
        this.monitor.initialize((long)chainedFixups.size(), "Marking up chained fixups...");
        for (Address addr : chainedFixups) {
            this.monitor.increment();
            try {
                this.listing.createData(addr, (DataType)PointerDataType.dataType);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {}
        }
    }

    protected void markupProgramVars() throws Exception {
        if (this.program.getLanguage().getProcessor() == Processor.findOrPossiblyCreateProcessor((String)"PowerPC")) {
            return;
        }
        SymbolTable symbolTable = this.program.getSymbolTable();
        int defaultPointerSize = this.program.getDefaultPointerSize();
        QWordDataType intDataType = defaultPointerSize == 8 ? new QWordDataType() : new DWordDataType();
        Pointer intPointerDataType = PointerDataType.getPointer((DataType)intDataType, (int)defaultPointerSize);
        Pointer voidPointerDatatype = PointerDataType.getPointer((DataType)new VoidDataType(), (int)defaultPointerSize);
        Pointer charPointerX1DataType = PointerDataType.getPointer((DataType)new CharDataType(), (int)defaultPointerSize);
        Pointer charPointerX2DataType = PointerDataType.getPointer((DataType)charPointerX1DataType, (int)defaultPointerSize);
        Pointer charPointerX3DataType = PointerDataType.getPointer((DataType)charPointerX2DataType, (int)defaultPointerSize);
        StructureDataType structure = new StructureDataType("__program_vars", 0);
        structure.add((DataType)voidPointerDatatype, "mh", "pointer to __mh_execute_header");
        structure.add((DataType)intPointerDataType, "NXArgcPtr", "pointer to argc");
        structure.add((DataType)charPointerX3DataType, "NXArgvPtr", "pointer to argv");
        structure.add((DataType)charPointerX3DataType, "environPtr", "pointer to environment");
        structure.add((DataType)charPointerX2DataType, "__prognamePtr", "pointer to program name");
        Namespace namespace = this.createNamespace("__program_vars");
        List<Section> sections = this.machoHeader.getAllSections();
        this.monitor.initialize((long)sections.size(), "Marking up program variables...");
        for (Section section : sections) {
            this.monitor.increment();
            if (!section.getSectionName().equals("__program_vars")) continue;
            MemoryBlock memoryBlock = this.getMemoryBlock(section);
            try {
                this.listing.createData(memoryBlock.getStart(), (DataType)structure);
                Data data = this.listing.getDataAt(memoryBlock.getStart());
                Data mhData = data.getComponent(0);
                if (symbolTable.getSymbol("__mh_execute_header", mhData.getAddress(0), namespace) == null) {
                    symbolTable.createLabel(mhData.getAddress(0), "__mh_execute_header", namespace, SourceType.IMPORTED);
                }
                Data argcData = data.getComponent(1);
                symbolTable.createLabel(argcData.getAddress(0), "NXArgc", namespace, SourceType.IMPORTED);
                this.listing.createData(argcData.getAddress(0), (DataType)intDataType);
                Data argvData = data.getComponent(2);
                symbolTable.createLabel(argvData.getAddress(0), "NXArgv", namespace, SourceType.IMPORTED);
                this.listing.createData(argvData.getAddress(0), (DataType)charPointerX2DataType);
                Data environData = data.getComponent(3);
                symbolTable.createLabel(environData.getAddress(0), "environ", namespace, SourceType.IMPORTED);
                this.listing.createData(environData.getAddress(0), (DataType)charPointerX2DataType);
                Data prognameData = data.getComponent(4);
                symbolTable.createLabel(prognameData.getAddress(0), "__progname", namespace, SourceType.IMPORTED);
                this.listing.createData(prognameData.getAddress(0), (DataType)charPointerX1DataType);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                return;
            }
        }
    }

    protected void setRelocatableProperty() {
        Options props = this.program.getOptions("Program Information");
        switch (this.machoHeader.getFileType()) {
            case 2: {
                props.setBoolean("Relocatable", false);
                break;
            }
            default: {
                props.setBoolean("Relocatable", true);
            }
        }
    }

    protected void setProgramDescription() {
        Options props = this.program.getOptions("Program Information");
        props.setString("Mach-O File Type", MachHeaderFileTypes.getFileTypeName(this.machoHeader.getFileType()));
        props.setString("Mach-O File Type Description", MachHeaderFileTypes.getFileTypeDescription(this.machoHeader.getFileType()));
        List<String> flags = MachHeaderFlags.getFlags(this.machoHeader.getFlags());
        for (int i = 0; i < flags.size(); ++i) {
            props.setString("Mach-O Flag " + i, flags.get(i));
        }
        List<SubUmbrellaCommand> umbrellas = this.machoHeader.getLoadCommands(SubUmbrellaCommand.class);
        for (int i = 0; i < umbrellas.size(); ++i) {
            props.setString("Mach-O Sub-umbrella " + i, umbrellas.get(i).getSubUmbrellaFrameworkName().getString());
        }
        List<SubFrameworkCommand> frameworks = this.machoHeader.getLoadCommands(SubFrameworkCommand.class);
        for (int i = 0; i < frameworks.size(); ++i) {
            props.setString("Mach-O Sub-framework " + i, frameworks.get(i).getUmbrellaFrameworkName().getString());
        }
    }

    protected void markupAndSetGolangInitialProgramProperties() {
        ElfInfoItem.ItemWithAddress<GoBuildInfo> buildInfo;
        ElfInfoItem.ItemWithAddress<GoBuildId> buildId = GoBuildId.findBuildId(this.program);
        if (buildId != null) {
            buildId.item().markupProgram(this.program, buildId.address());
        }
        if ((buildInfo = GoBuildInfo.findBuildInfo(this.program)) != null) {
            buildInfo.item().markupProgram(this.program, buildInfo.address());
        }
    }

    protected void setCompiler() throws CancelledException {
        try {
            SegmentCommand segment = this.machoHeader.getSegment("__TEXT");
            if (segment == null) {
                return;
            }
            Section section = segment.getSectionByName("__const");
            if (section == null) {
                return;
            }
            if (RustUtilities.isRust(this.program, this.memory.getBlock(this.space.getAddress(section.getAddress())), this.monitor)) {
                this.program.setCompiler("rustc");
                int extensionCount = RustUtilities.addExtensions(this.program, this.monitor, "unix");
                this.log.appendMsg("Installed " + extensionCount + " Rust cspec extensions");
            }
        }
        catch (IOException e) {
            this.log.appendMsg("Rust error: " + e.getMessage());
        }
    }

    protected void renameObjMsgSendRtpSymbol() throws DuplicateNameException, InvalidInputException {
        Address address = this.space.getAddress(0xFFFEFF00L);
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (symbol != null && symbol.isDynamic()) {
            symbol.setName("_objc_msgSend_rtp", SourceType.IMPORTED);
        } else {
            this.program.getSymbolTable().createLabel(address, "_objc_msgSend_rtp", SourceType.IMPORTED);
        }
    }

    public static void fixupExternalLibrary(Program program, List<String> libraryPaths, int libraryOrdinal, String symbol) throws Exception {
        switch (libraryOrdinal) {
            case -3: 
            case -2: 
            case -1: 
            case 0: {
                return;
            }
        }
        ExternalManager extManager = program.getExternalManager();
        int libraryIndex = libraryOrdinal - 1;
        if (libraryIndex < 0 || libraryIndex >= libraryPaths.size()) {
            throw new Exception("Library ordinal '%d' outside of expected range".formatted(libraryOrdinal));
        }
        String libraryName = SymbolUtilities.replaceInvalidChars((String)libraryPaths.get(libraryIndex), (boolean)true);
        Library library = extManager.getExternalLibrary(libraryName);
        if (library == null) {
            throw new Exception("Library '%s' not found in external program list".formatted(libraryName));
        }
        ExternalLocation loc = extManager.getUniqueExternalLocation("<EXTERNAL>", symbol);
        if (loc != null) {
            try {
                loc.setName((Namespace)library, symbol, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                throw new Exception(e.getMessage());
            }
        }
    }
}

