/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.macho.CpuTypes;
import ghidra.app.util.bin.format.macho.MachConstants;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.ubi.FatArch;
import ghidra.app.util.bin.format.ubi.FatHeader;
import ghidra.app.util.bin.format.ubi.UbiException;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoPrelinkProgramBuilder;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.apache.commons.io.FilenameUtils;
import util.CollectionUtils;

public class MachoLoader
extends AbstractLibrarySupportLoader {
    public static final String MACH_O_NAME = "Mac OS X Mach-O";
    private static final long MIN_BYTE_LENGTH = 4L;
    public static final String REEXPORT_OPTION_NAME = "Perform Reexports";
    static final boolean REEXPORT_OPTION_DEFAULT = true;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        boolean onlyPreferred;
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 4L) {
            return loadSpecs;
        }
        ArrayList<ByteProvider> allProviders = new ArrayList<ByteProvider>();
        if (this.isUniveralBinary(provider)) {
            allProviders.addAll(this.getUniveralBinaryProviders(provider));
            onlyPreferred = true;
        } else {
            allProviders.add(provider);
            onlyPreferred = false;
        }
        for (ByteProvider machoProvider : allProviders) {
            byte[] magicBytes = machoProvider.readBytes(0L, 4L);
            if (!MachConstants.isMagic(LittleEndianDataConverter.INSTANCE.getInt(magicBytes))) continue;
            try {
                MachHeader machHeader = new MachHeader(machoProvider);
                String magic = CpuTypes.getMagicString(machHeader.getCpuType(), machHeader.getCpuSubType());
                String compiler = this.detectCompilerName(machHeader);
                List<QueryResult> results = QueryOpinionService.query(MACH_O_NAME, magic, compiler);
                for (QueryResult result : results) {
                    if (onlyPreferred && !result.preferred) continue;
                    loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), result));
                }
                if (!loadSpecs.isEmpty() || onlyPreferred) continue;
                loadSpecs.add(new LoadSpec((Loader)this, machHeader.getImageBase(), true));
            }
            catch (MachException machException) {}
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        if (this.isUniveralBinary(provider)) {
            provider = this.matchUniversalBinaryProvider(provider, loadSpec, monitor);
        }
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
            if (MachoPrelinkUtils.isMachoPrelink(provider, monitor) || MachoPrelinkUtils.isMachoFileset(provider)) {
                MachoPrelinkProgramBuilder.buildProgram(program, provider, fileBytes, log, monitor);
            } else {
                MachoProgramBuilder.buildProgram(program, provider, fileBytes, log, monitor);
            }
        }
        catch (CancelledException e) {
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(REEXPORT_OPTION_NAME, true, Boolean.class, "-loader-reexport"));
        }
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(REEXPORT_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    @Override
    public String getName() {
        return MACH_O_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isValidSearchPath(FSRL fsrl, LoadSpec loadSpec, TaskMonitor monitor) throws CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        try (ByteProvider provider = fsService.getByteProvider(fsrl, loggingDisabled, monitor);){
            if (!DyldCacheUtils.isDyldCache(provider)) {
                boolean bl2 = true;
                return bl2;
            }
            DyldCacheHeader header = new DyldCacheHeader(new BinaryReader(provider, true));
            DyldArchitecture dyld = header.getArchitecture();
            LanguageCompilerSpecPair lcs = loadSpec.getLanguageCompilerSpec();
            String processor = lcs.getLanguage().getProcessor().toString().toLowerCase();
            boolean is64bit = lcs.getLanguage().getAddressFactory().getDefaultAddressSpace().getPointerSize() == 8;
            boolean bl = switch (processor) {
                case "x86" -> {
                    if (dyld.isX86() && is64bit == dyld.is64bit()) {
                        yield true;
                    }
                    yield false;
                }
                case "aarch64" -> {
                    if (dyld.isARM() && dyld.is64bit()) {
                        yield true;
                    }
                    yield false;
                }
                case "arm" -> {
                    if (dyld.isARM() && !dyld.is64bit()) {
                        yield true;
                    }
                    yield false;
                }
                case "powerpc" -> dyld.isPowerPC();
                default -> false;
            };
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    protected ByteProvider createLibraryByteProvider(FSRL libFsrl, LoadSpec loadSpec, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ByteProvider provider = super.createLibraryByteProvider(libFsrl, loadSpec, log, monitor);
        try {
            FatHeader header = new FatHeader(provider);
            List<FatArch> architectures = header.getArchitectures();
            if (architectures.isEmpty()) {
                log.appendMsg("WARNING! No archives found in the UBI: " + String.valueOf(libFsrl));
                return null;
            }
            for (FatArch architecture : architectures) {
                ByteProviderWrapper bp = new ByteProviderWrapper(this, provider, (long)architecture.getOffset(), architecture.getSize()){

                    @Override
                    public void close() throws IOException {
                        this.provider.close();
                    }
                };
                LoadSpec libLoadSpec = this.matchSupportedLoadSpec(loadSpec, bp);
                if (libLoadSpec == null) continue;
                return bp;
            }
        }
        catch (MachException | UbiException exception) {
            // empty catch block
        }
        return provider;
    }

    @Override
    protected FSRL resolveLibraryFile(GFileSystem fs, String library) throws IOException {
        FSRL fsrl = super.resolveLibraryFile(fs, library);
        if (fsrl != null) {
            return fsrl;
        }
        String libraryParentPath = FilenameUtils.getFullPath((String)library);
        String libraryName = FilenameUtils.getName((String)library);
        GFile libraryParentDir = fs.lookup(libraryParentPath);
        if (libraryParentDir != null) {
            for (GFile file : fs.getListing(libraryParentDir)) {
                if (file.isDirectory() && file.getName().equals("Versions")) {
                    GFile specificVersionDir;
                    String versionsPath = this.joinPaths(libraryParentPath, file.getName());
                    List<GFile> versionListion = fs.getListing(file);
                    if (!versionListion.isEmpty() && (specificVersionDir = versionListion.get(0)).isDirectory()) {
                        return this.resolveLibraryFile(fs, this.joinPaths(versionsPath, specificVersionDir.getName(), libraryName));
                    }
                } else if (file.isDirectory()) continue;
                if (!file.getName().equals(libraryName)) continue;
                return file.getFSRL();
            }
        }
        return null;
    }

    @Override
    protected boolean shouldSearchAllPaths(Program program, List<Option> options, MessageLog log) {
        if (super.shouldSearchAllPaths(program, options, log)) {
            return true;
        }
        if (this.shouldPerformReexports(options)) {
            try {
                Symbol header = program.getSymbolTable().getSymbols("MACH_HEADER").next();
                if (header == null) {
                    return false;
                }
                MemoryByteProvider p = new MemoryByteProvider(program.getMemory(), header.getAddress());
                if (new MachHeader(p).parseAndCheck(-2147483617)) {
                    return true;
                }
            }
            catch (Exception e) {
                log.appendMsg("Failed to parse Mach-O header for: '%s': %s".formatted(program.getName(), e.getMessage()));
            }
        }
        return false;
    }

    @Override
    protected void processLibrary(Program lib, String libName, FSRL libFsrl, ByteProvider provider, Queue<AbstractLibrarySupportLoader.UnprocessedLibrary> unprocessed, int depth, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.shouldPerformReexports(options)) {
            return;
        }
        try {
            for (String path : this.getReexportPaths(lib, log)) {
                unprocessed.add(new AbstractLibrarySupportLoader.UnprocessedLibrary(path, depth, depth == 1));
            }
        }
        catch (MachException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Project project, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.shouldPerformReexports(options)) {
            List<AbstractLibrarySupportLoader.LibrarySearchPath> searchPaths;
            List<DomainFolder> searchFolders = this.getLibrarySearchFolders(loadedPrograms, project, options, log);
            Program firstProgram = loadedPrograms.getFirst().getDomainObject(this);
            try {
                searchPaths = this.getLibrarySearchPaths(firstProgram, loadSpec, options, log, monitor);
            }
            finally {
                firstProgram.release((Object)this);
            }
            monitor.initialize((long)loadedPrograms.size());
            for (Loaded<Program> loadedProgram : loadedPrograms) {
                monitor.increment();
                Program program = loadedProgram.getDomainObject(this);
                int id = program.startTransaction("Reexporting");
                try {
                    this.reexport(program, loadedPrograms, searchFolders, searchPaths, options, monitor, log);
                }
                catch (Exception e) {
                    log.appendException((Throwable)e);
                }
                finally {
                    program.endTransaction(id, true);
                    program.release((Object)this);
                }
            }
        }
        super.postLoadProgramFixups(loadedPrograms, project, loadSpec, options, log, monitor);
    }

    private boolean isUniveralBinary(ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, false);
        int magic = reader.readInt(0L);
        return magic == -889275714 || magic == -1095041334;
    }

    private List<ByteProviderWrapper> getUniveralBinaryProviders(ByteProvider provider) throws IOException {
        ArrayList<ByteProviderWrapper> wrappers = new ArrayList<ByteProviderWrapper>();
        try {
            FatHeader fatHeader = new FatHeader(provider);
            List<Long> machStarts = fatHeader.getMachStarts();
            List<Long> machSizes = fatHeader.getMachSizes();
            for (int i = 0; i < machStarts.size(); ++i) {
                wrappers.add(new ByteProviderWrapper(provider, machStarts.get(i), machSizes.get(i), provider.getFSRL()));
            }
        }
        catch (MachException | UbiException exception) {
            // empty catch block
        }
        return wrappers;
    }

    private ByteProvider matchUniversalBinaryProvider(ByteProvider provider, LoadSpec loadSpec, TaskMonitor monitor) throws IOException {
        ByteProvider ret = null;
        boolean stop = false;
        for (ByteProvider byteProvider : this.getUniveralBinaryProviders(provider)) {
            for (LoadSpec ls : this.findSupportedLoadSpecs(byteProvider)) {
                if (monitor.isCancelled()) {
                    stop = true;
                    break;
                }
                if (!loadSpec.getLanguageCompilerSpec().equals((Object)ls.getLanguageCompilerSpec())) continue;
                ret = byteProvider;
                stop = true;
                break;
            }
            if (!stop) continue;
            break;
        }
        if (ret == null) {
            throw new IOException("Failed to match the load spec to a Universal Binary Mach-O");
        }
        return ret;
    }

    private String detectCompilerName(MachHeader machHeader) throws IOException {
        List<String> sectionNames = machHeader.parseSegments().stream().flatMap(seg -> seg.getSections().stream()).map(section -> section.getSectionName()).toList();
        if (SwiftUtils.isSwift(sectionNames)) {
            return "swift";
        }
        if (GoRttiMapper.hasGolangSections(sectionNames)) {
            return "golang";
        }
        return null;
    }

    private boolean shouldPerformReexports(List<Option> options) {
        return OptionUtils.getOption(REEXPORT_OPTION_NAME, options, true);
    }

    private List<String> getReexportPaths(Program program, MessageLog log) throws MachException, IOException {
        Symbol header = program.getSymbolTable().getSymbols("MACH_HEADER").next();
        if (header == null) {
            log.appendMsg("Failed to lookup reexport paths...couldn't find '%s' symbol".formatted("MACH_HEADER"));
            return List.of();
        }
        MemoryByteProvider p = new MemoryByteProvider(program.getMemory(), header.getAddress());
        return new MachHeader(p).parseReexports().stream().map(DynamicLibraryCommand::getDynamicLibrary).map(DynamicLibrary::getName).map(LoadCommandString::getString).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reexport(Program program, List<Loaded<Program>> loadedPrograms, List<DomainFolder> searchFolders, List<AbstractLibrarySupportLoader.LibrarySearchPath> searchPaths, List<Option> options, TaskMonitor monitor, MessageLog log) throws CancelledException, Exception {
        for (String path : this.getReexportPaths(program, log)) {
            monitor.checkCancelled();
            Program lib = null;
            try {
                Loaded<Program> match = this.findLibraryInLoadedList(loadedPrograms, path);
                if (match != null) {
                    lib = match.getDomainObject(this);
                }
                if (lib == null) {
                    for (DomainFolder searchFolder : searchFolders) {
                        DomainFile df = this.findLibraryInProject(path, searchFolder, searchPaths, options, monitor);
                        if (df == null) continue;
                        DomainObject obj = df.getDomainObject((Object)this, true, true, monitor);
                        if (obj instanceof Program) {
                            Program p;
                            lib = p = (Program)obj;
                            break;
                        }
                        obj.release((Object)this);
                        break;
                    }
                }
                if (lib == null) continue;
                List<Symbol> reexportedSymbols = CollectionUtils.asStream((Iterator)lib.getSymbolTable().getExternalEntryPointIterator()).map(arg_0 -> ((SymbolTable)lib.getSymbolTable()).getPrimarySymbol(arg_0)).filter(Objects::nonNull).toList();
                Address addr = AbstractProgramLoader.addExternalBlock(program, reexportedSymbols.size() * 8, log);
                monitor.initialize((long)reexportedSymbols.size(), "Reexporting symbols...");
                for (Symbol symbol : reexportedSymbols) {
                    monitor.increment();
                    String name = SymbolUtilities.replaceInvalidChars((String)symbol.getName(), (boolean)true);
                    program.getSymbolTable().addExternalEntryPoint(addr);
                    program.getSymbolTable().createLabel(addr, name, SourceType.IMPORTED);
                    Function function = program.getFunctionManager().createFunction(name, addr, (AddressSetView)new AddressSet(addr), SourceType.IMPORTED);
                    ExternalLocation loc = program.getExternalManager().addExtLocation(path, name, null, SourceType.IMPORTED);
                    function.setThunkedFunction(loc.createFunction());
                    addr = addr.add(8L);
                }
            }
            finally {
                if (lib == null) continue;
                lib.release((Object)this);
            }
        }
    }
}

