/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Loaded<T extends DomainObject>
implements AutoCloseable {
    protected final T domainObject;
    protected final String name;
    protected Project project;
    protected String projectFolderPath;
    protected Object loadedConsumer;
    protected DomainFile domainFile;

    public Loaded(T domainObject, String name, Project project, String projectFolderPath, Object consumer) {
        this.domainObject = domainObject;
        this.name = name;
        this.project = project;
        this.loadedConsumer = consumer;
        this.setProjectFolderPath(projectFolderPath);
    }

    public T getDomainObject(Object consumer) {
        this.domainObject.addConsumer(consumer);
        return this.domainObject;
    }

    @Deprecated(since="12.0", forRemoval=true)
    public T getDomainObject() {
        return this.domainObject;
    }

    public Class<? extends DomainObject> getDomainObjectType() {
        return this.domainObject.getClass();
    }

    public void apply(Consumer<T> operation) {
        operation.accept(this.domainObject);
    }

    public boolean check(Predicate<T> predicate) {
        return predicate.test(this.domainObject);
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProjectFolderPath() {
        return this.projectFolderPath;
    }

    public void setProjectFolderPath(String projectFolderPath) {
        if (projectFolderPath == null || ((String)projectFolderPath).isBlank()) {
            projectFolderPath = "/";
        } else if (!((String)projectFolderPath).endsWith("/")) {
            projectFolderPath = (String)projectFolderPath + "/";
        }
        this.projectFolderPath = projectFolderPath;
    }

    public DomainFile save(TaskMonitor monitor) throws CancelledException, ClosedException, IOException {
        if (this.domainObject.isClosed()) {
            throw new ClosedException("Cannot saved closed DomainObject: " + this.domainObject.getName());
        }
        try {
            if (this.getSavedDomainFile() != null) {
                throw new IOException("Already saved to " + String.valueOf(this.domainFile));
            }
        }
        catch (FileNotFoundException e) {
            this.domainFile = null;
        }
        int uniqueNameIndex = 0;
        Object uniqueName = this.name;
        try {
            DomainFolder programFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)this.project.getProjectData().getRootFolder(), (String)this.projectFolderPath);
            while (!monitor.isCancelled()) {
                try {
                    this.domainFile = programFolder.createFile((String)uniqueName, this.domainObject, monitor);
                    return this.domainFile;
                }
                catch (DuplicateFileException e) {
                    uniqueName = this.name + "." + uniqueNameIndex;
                    ++uniqueNameIndex;
                }
            }
        }
        catch (InvalidNameException e) {
            throw new IOException(e);
        }
        throw new CancelledException();
    }

    public DomainFile getSavedDomainFile() throws FileNotFoundException {
        if (this.domainFile != null && !this.domainFile.exists()) {
            throw new FileNotFoundException("Saved DomainFile no longer exists: " + String.valueOf(this.domainFile));
        }
        return this.domainFile;
    }

    @Deprecated(since="12.0", forRemoval=true)
    public void release(Object consumer) {
        if (!this.domainObject.isClosed() && this.domainObject.isUsedBy(consumer)) {
            this.domainObject.release(consumer);
        }
    }

    @Override
    public void close() {
        if (this.loadedConsumer != null && !this.domainObject.isClosed() && this.domainObject.isUsedBy(this.loadedConsumer)) {
            this.domainObject.release(this.loadedConsumer);
        }
    }

    public String toString() {
        return this.getProjectFolderPath() + this.getName();
    }
}

