/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.Loaded;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class LoadResults<T extends DomainObject>
implements Iterable<Loaded<T>>,
AutoCloseable {
    private final List<Loaded<T>> loadedList;

    public LoadResults(List<Loaded<T>> loadedList) throws IllegalArgumentException {
        if (loadedList == null || loadedList.isEmpty()) {
            throw new IllegalArgumentException("The loaded list must not be empty");
        }
        this.loadedList = new ArrayList<Loaded<T>>(loadedList);
    }

    public LoadResults(T domainObject, String name, Project project, String projectFolderPath, Object consumer) {
        this(List.of(new Loaded<T>(domainObject, name, project, projectFolderPath, consumer)));
    }

    public Loaded<T> getPrimary() {
        return this.loadedList.getFirst();
    }

    public List<Loaded<T>> getNonPrimary() {
        return this.loadedList.stream().skip(1L).toList();
    }

    public T getPrimaryDomainObject(Object consumer) {
        return this.loadedList.getFirst().getDomainObject(consumer);
    }

    @Deprecated(since="12.0", forRemoval=true)
    public T getPrimaryDomainObject() {
        return this.loadedList.get(0).getDomainObject();
    }

    public int size() {
        return this.loadedList.size();
    }

    public void save(TaskMonitor monitor) throws CancelledException, IOException {
        for (Loaded<T> loaded : this.loadedList) {
            loaded.save(monitor);
        }
    }

    @Deprecated(since="12.0", forRemoval=true)
    public void release(Object consumer) {
        this.loadedList.forEach(loaded -> loaded.release(consumer));
    }

    @Deprecated(since="12.0", forRemoval=true)
    public void release(Object consumer, Predicate<? super Loaded<T>> filter) {
        this.loadedList.stream().filter(filter).forEach(loaded -> loaded.release(consumer));
    }

    @Deprecated(since="12.0", forRemoval=true)
    public void releaseNonPrimary(Object consumer) {
        for (int i = 0; i < this.loadedList.size(); ++i) {
            if (i <= 0) continue;
            this.loadedList.get(i).release(consumer);
        }
    }

    @Override
    public void close() {
        this.loadedList.forEach(Loaded::close);
    }

    @Override
    public Iterator<Loaded<T>> iterator() {
        return this.loadedList.iterator();
    }
}

