/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import db.DBHandle;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.Application;
import ghidra.framework.data.OpenMode;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public class GdtLoader
implements Loader {
    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return Collections.emptyList();
    }

    @Override
    public LoadResults<? extends DomainObject> load(ByteProvider provider, String filename, Project project, String projectFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        DataTypeArchive dtArchive = this.loadPackedProgramDatabase(provider, filename, consumer, monitor);
        return new LoadResults<DataTypeArchive>(dtArchive, filename, project, projectFolderPath, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTypeArchive loadPackedProgramDatabase(ByteProvider provider, String programName, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException, LanguageNotFoundException {
        File file = provider.getFile();
        File tmpFile = null;
        if (file == null) {
            file = tmpFile = GdtLoader.createTmpFile(provider, monitor);
        }
        try {
            DataTypeArchiveDB dtArchive;
            PackedDatabase packedDatabase = PackedDatabase.getPackedDatabase((File)file, (boolean)true, (TaskMonitor)monitor);
            boolean success = false;
            DBHandle dbh = null;
            try {
                if (!"Archive".equals(packedDatabase.getContentType())) {
                    throw new IOException("File imported is not a Program: " + programName);
                }
                monitor.setMessage("Restoring " + provider.getName());
                dbh = packedDatabase.open(monitor);
                dtArchive = new DataTypeArchiveDB(dbh, OpenMode.UPGRADE, monitor, consumer);
                success = true;
            }
            finally {
                if (!success) {
                    if (dbh != null) {
                        dbh.close();
                    } else {
                        packedDatabase.dispose();
                    }
                }
            }
            DataTypeArchiveDB dataTypeArchiveDB = dtArchive;
            return dataTypeArchiveDB;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    public void loadInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Program program, TaskMonitor monitor) throws IOException, LoadException, CancelledException {
        throw new LoadException("Cannot add GDT to program");
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null && options.size() > 0) {
            return "GDTLoader takes no options";
        }
        return null;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (GdtLoader.isGDTFile(provider)) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, false));
        }
        return loadSpecs;
    }

    @Override
    public String getPreferredFileName(ByteProvider provider) {
        return FilenameUtils.removeExtension((String)provider.getName());
    }

    private static File createTmpFile(ByteProvider provider, TaskMonitor monitor) throws IOException {
        File tmpFile = Application.createTempFile((String)"ghidra_gdt_loader", null);
        try (InputStream is = provider.getInputStream(0L);
             FileOutputStream fos = new FileOutputStream(tmpFile);){
            FileUtilities.copyStreamToStream((InputStream)is, (OutputStream)fos, (TaskMonitor)monitor);
        }
        return tmpFile;
    }

    private static boolean isGDTFile(ByteProvider provider) {
        if (!provider.getName().toLowerCase().endsWith(".gdt")) {
            return false;
        }
        boolean isGDT = false;
        try (InputStream inputStream = provider.getInputStream(0L);){
            isGDT = ItemSerializer.isPackedFile((InputStream)inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isGDT;
    }

    @Override
    public String getName() {
        return "Ghidra Data Type Archive Format";
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 0;
    }
}

