/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.jar.ResourceFile;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LibraryExportedSymbol;
import ghidra.app.util.opinion.LibraryLookupTable;
import ghidra.app.util.opinion.LibrarySymbolTable;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalLocationIterator;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.function.Predicate;

public abstract class AbstractOrdinalSupportLoader
extends AbstractLibrarySupportLoader {
    public static final String ORDINAL_LOOKUP_OPTION_NAME = "Perform Library Ordinal Lookup";
    static final boolean ORDINAL_LOOKUP_OPTION_DEFAULT = true;

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        list.add(new Option(ORDINAL_LOOKUP_OPTION_NAME, true, Boolean.class, "-loader-ordinalLookup"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(ORDINAL_LOOKUP_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    @Override
    protected boolean shouldSearchAllPaths(Program program, List<Option> options, MessageLog log) {
        return this.shouldPerformOrdinalLookup(options);
    }

    @Override
    protected void processLibrary(Program lib, String libName, FSRL libFsrl, ByteProvider provider, Queue<AbstractLibrarySupportLoader.UnprocessedLibrary> unprocessed, int depth, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        int size = loadSpec.getLanguageCompilerSpec().getLanguageDescription().getSize();
        ResourceFile existingExportsFile = LibraryLookupTable.getExistingExportsFile(libName, size);
        if (!this.shouldPerformOrdinalLookup(options)) {
            return;
        }
        if (existingExportsFile == null) {
            try {
                ResourceFile newExportsFile = LibraryLookupTable.createFile(lib, true, monitor);
                log.appendMsg("Created exports file: " + String.valueOf(newExportsFile));
            }
            catch (IOException e) {
                log.appendMsg("Unable to create exports file for " + String.valueOf(libFsrl));
            }
        } else {
            log.appendMsg("Using existing exports file: " + String.valueOf(existingExportsFile));
            File localLibFile = this.getLocalFile(libFsrl);
            if (localLibFile != null && !LibraryLookupTable.hasFileAndPathAndTimeStampMatch(localLibFile, size)) {
                log.appendMsg("WARNING: Existing exports file may not be an exact match.");
            }
        }
    }

    private File getLocalFile(FSRL fsrl) {
        try {
            return FileSystemService.getInstance().getLocalFS().getLocalFile(fsrl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Project project, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.shouldPerformOrdinalLookup(options)) {
            List<Loaded> saveablePrograms = loadedPrograms.stream().filter(loaded -> loaded.check(Predicate.not(DomainObject::isTemporary))).toList();
            monitor.initialize((long)saveablePrograms.size());
            for (Loaded loadedProgram : saveablePrograms) {
                monitor.checkCancelled();
                Program program = (Program)loadedProgram.getDomainObject(this);
                int id = program.startTransaction("Ordinal fixups");
                try {
                    this.applyLibrarySymbols(program, messageLog, monitor);
                    this.applyImports(program, messageLog, monitor);
                }
                finally {
                    program.endTransaction(id, true);
                    program.release((Object)this);
                }
            }
        }
        super.postLoadProgramFixups(loadedPrograms, project, loadSpec, options, messageLog, monitor);
    }

    @Override
    protected void postLoadCleanup(boolean success) {
        super.postLoadCleanup(success);
        LibraryLookupTable.cleanup();
    }

    private boolean shouldPerformOrdinalLookup(List<Option> options) {
        return OptionUtils.getOption(ORDINAL_LOOKUP_OPTION_NAME, options, true);
    }

    private void applyLibrarySymbols(Program program, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Applying information..." + program.getName());
        int size = program.getLanguage().getLanguageDescription().getSize();
        LibrarySymbolTable symtab = LibraryLookupTable.getSymbolTable(new File(program.getExecutablePath()).getName(), size, log);
        if (symtab == null && (symtab = LibraryLookupTable.getSymbolTable(program.getName(), size, log)) == null) {
            return;
        }
        if (!this.isVersionMatch((DomainObject)program, symtab, log)) {
            return;
        }
        SymbolIterator iter = program.getSymbolTable().getSymbolIterator("Ordinal_*", true);
        while (iter.hasNext()) {
            int ordinal;
            LibraryExportedSymbol les;
            monitor.checkCancelled();
            Symbol ordSym = iter.next();
            if (!ordSym.getAddress().isMemoryAddress() || !ordSym.getParentNamespace().equals((Object)program.getGlobalNamespace()) || (les = symtab.getSymbol(ordinal = SymbolUtilities.getOrdinalValue((String)ordSym.getName()))) == null || les.getName() == null) continue;
            try {
                Symbol nameSym = program.getSymbolTable().getGlobalSymbol(les.getName(), ordSym.getAddress());
                if (nameSym != null) continue;
                String name = les.getName();
                Symbol s = program.getSymbolTable().createLabel(ordSym.getAddress(), name, program.getGlobalNamespace(), SourceType.IMPORTED);
                s.setPrimary();
            }
            catch (InvalidInputException e) {
                log.appendMsg("Error creating label named " + les.getName() + " at address " + String.valueOf(ordSym.getAddress()) + ": " + e.getMessage());
            }
        }
    }

    private void applyImports(Program program, MessageLog log, TaskMonitor monitor) {
        String[] libs;
        monitor.setMessage("Applying imports..." + program.getName());
        ExternalManager em = program.getExternalManager();
        for (String lib : libs = em.getExternalLibraryNames()) {
            if (monitor.isCancelled()) {
                return;
            }
            int size = program.getLanguage().getLanguageDescription().getSize();
            LibrarySymbolTable symtab = LibraryLookupTable.getSymbolTable(lib, size, log);
            ExternalLocationIterator iter = em.getExternalLocations(lib);
            while (iter.hasNext()) {
                boolean isNot32Bit;
                if (monitor.isCancelled()) {
                    return;
                }
                ExternalLocation extLoc = (ExternalLocation)iter.next();
                String symName = extLoc.getLabel();
                if (symtab == null) continue;
                LibraryExportedSymbol expSym = symtab.getSymbol(symName);
                if (expSym == null) {
                    try {
                        int ord = SymbolUtilities.getOrdinalValue((String)symName);
                        if (ord == -1) continue;
                        expSym = symtab.getSymbol(ord);
                        if (expSym == null) {
                            log.appendMsg("Unable to locate symbol [" + symName + "] in [" + String.valueOf(LibraryLookupTable.getExistingExportsFile(lib, size)) + "]. Please verify the version is correct.");
                            continue;
                        }
                        extLoc.setLocation(expSym.getName(), extLoc.getAddress(), SourceType.IMPORTED);
                    }
                    catch (DuplicateNameException | InvalidInputException e) {
                        log.appendMsg("Error creating label: ", e.getMessage());
                    }
                }
                int purgeSize = expSym.getPurge();
                boolean bl = isNot32Bit = size > 32;
                if (purgeSize == -1 || purgeSize < -1024 || purgeSize > 1024 || isNot32Bit) continue;
                Function extFunc = extLoc.createFunction();
                extFunc.setStackPurgeSize(purgeSize);
                if (!expSym.hasNoReturn()) continue;
                extFunc.setNoReturn(true);
            }
        }
    }

    private boolean isVersionMatch(DomainObject p, LibrarySymbolTable symtab, MessageLog log) {
        String version = AbstractOrdinalSupportLoader.getRidOfVersionAlias(symtab.getVersion());
        Options options = p.getOptions("Program Information");
        String programVersion = AbstractOrdinalSupportLoader.getRidOfVersionAlias(options.getString("ProductVersion", (String)null));
        if (programVersion == null) {
            return false;
        }
        boolean match = programVersion.equalsIgnoreCase(version);
        if (!match) {
            log.appendMsg("Library version mismatch in .exports file for " + p.getName());
            log.appendMsg("   expected " + programVersion + " but was " + version);
        }
        return match;
    }

    private static String getRidOfVersionAlias(String version) {
        if (version == null) {
            return null;
        }
        int aliasOpenParenPosition = version.indexOf(40);
        if (aliasOpenParenPosition == -1) {
            return version.trim();
        }
        return version.substring(0, aliasOpenParenPosition).trim();
    }
}

