/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.DomainFolderOption;
import ghidra.app.util.importer.LibrarySearchPathDummyOption;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.LoadedOpen;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractLibrarySupportLoader
extends AbstractProgramLoader {
    public static final String LINK_EXISTING_OPTION_NAME = "Link Existing Project Libraries";
    static final boolean LINK_EXISTING_OPTION_DEFAULT = true;
    public static final String LINK_SEARCH_FOLDER_OPTION_NAME = "Project Library Search Folder";
    static final String LINK_SEARCH_FOLDER_OPTION_DEFAULT = "";
    public static final String LOAD_LIBRARY_OPTION_NAME = "Load Libraries From Disk";
    static final boolean LOAD_LIBRARY_OPTION_DEFAULT = false;
    public static final String LIBRARY_SEARCH_PATH_DUMMY_OPTION_NAME = "Library Search Paths";
    public static final String DEPTH_OPTION_NAME = "Recursive Library Load Depth";
    static final int DEPTH_OPTION_DEFAULT = 1;
    public static final String LIBRARY_DEST_FOLDER_OPTION_NAME = "Library Destination Folder";
    static final String LIBRARY_DEST_FOLDER_OPTION_DEFAULT = "";
    public static final String LOAD_ONLY_LIBRARIES_OPTION_NAME = "Only Load Libraries";
    static final boolean LOAD_ONLY_LIBRARIES_OPTION_DEFAULT = false;

    protected abstract void load(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4, TaskMonitor var5, MessageLog var6) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Loaded<Program>> loadProgram(ByteProvider provider, String loadedName, Project project, String projectFolderPath, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> loadedProgramList = new ArrayList<Loaded<Program>>();
        ArrayList<String> libraryNameList = new ArrayList<String>();
        boolean success = false;
        try {
            Program program = null;
            if (!this.shouldLoadOnlyLibraries(options)) {
                program = this.doLoad(provider, loadedName, loadSpec, libraryNameList, options, consumer, log, monitor);
                loadedProgramList.add(new Loaded<Program>(program, loadedName, project, projectFolderPath, consumer));
                log.appendMsg("------------------------------------------------\n");
            } else {
                if (project == null) {
                    throw new LoadException("Cannot load only libraries...project is null");
                }
                DomainFile domainFile = project.getProjectData().getFile(projectFolderPath + "/" + loadedName);
                if (domainFile == null) {
                    throw new LoadException("Cannot load only libraries for a non-existant program");
                }
                if (!Program.class.isAssignableFrom(domainFile.getDomainObjectClass())) {
                    throw new LoadException("Cannot load only libraries for a non-program");
                }
                program = (Program)domainFile.getOpenedDomainObject(consumer);
                if (program == null) {
                    throw new LoadException("Failed to acquire an open Program");
                }
                loadedProgramList.add(new LoadedOpen<Program>(program, domainFile, consumer));
                libraryNameList.addAll(this.getLibraryNames(provider, program));
            }
            loadedProgramList.addAll(this.loadLibraries(provider, program, project, projectFolderPath, loadSpec, options, log, consumer, libraryNameList, monitor));
            success = true;
            ArrayList<Loaded<Program>> arrayList = loadedProgramList;
            return arrayList;
        }
        finally {
            if (!success) {
                loadedProgramList.forEach(Loaded::close);
            }
        }
    }

    @Override
    protected void loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws CancelledException, LoadException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            String message = provider.getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName();
            log.appendMsg(message);
            throw new LoadException(message);
        }
        log.appendMsg("Loading " + provider.getAbsolutePath() + "...");
        this.load(provider, loadSpec, options, program, monitor, log);
        log.appendMsg("--------------------------------------------------------------------\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Project project, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        List<LibrarySearchPath> searchPaths;
        if (loadedPrograms.isEmpty() || !this.isLinkExistingLibraries(options) && !this.isLoadLibraries(options)) {
            return;
        }
        List<DomainFolder> searchFolders = this.getLibrarySearchFolders(loadedPrograms, project, options, log);
        Program firstProgram = loadedPrograms.getFirst().getDomainObject(this);
        try {
            searchPaths = this.getLibrarySearchPaths(firstProgram, loadSpec, options, log, monitor);
        }
        finally {
            firstProgram.release((Object)this);
        }
        List<Loaded<Program>> saveablePrograms = loadedPrograms.stream().filter(loaded -> loaded.check(Predicate.not(DomainObject::isTemporary))).toList();
        monitor.initialize((long)saveablePrograms.size());
        for (Loaded loaded2 : saveablePrograms) {
            monitor.increment();
            Program program = (Program)loaded2.getDomainObject(this);
            try {
                ExternalManager extManager = program.getExternalManager();
                String[] extLibNames = extManager.getExternalLibraryNames();
                if (extLibNames.length == 0 || extLibNames.length == 1 && "<EXTERNAL>".equals(extLibNames[0])) continue;
                monitor.setMessage("Resolving..." + program.getName());
                int id = program.startTransaction("Resolving external references");
                try {
                    this.resolveExternalLibraries(program, saveablePrograms, searchFolders, searchPaths, options, monitor, log);
                }
                finally {
                    program.endTransaction(id, true);
                }
            }
            finally {
                program.release((Object)this);
            }
        }
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        list.add(new Option(LINK_EXISTING_OPTION_NAME, true, Boolean.class, "-loader-linkExistingProjectLibraries"));
        list.add(new DomainFolderOption(LINK_SEARCH_FOLDER_OPTION_NAME, "-loader-projectLibrarySearchFolder"));
        list.add(new Option(LOAD_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadLibraries"));
        list.add(new LibrarySearchPathDummyOption(LIBRARY_SEARCH_PATH_DUMMY_OPTION_NAME));
        list.add(new Option(DEPTH_OPTION_NAME, 1, Integer.class, "-loader-libraryLoadDepth"));
        list.add(new DomainFolderOption(LIBRARY_DEST_FOLDER_OPTION_NAME, "-loader-libraryDestinationFolder"));
        list.add(new Option(LOAD_ONLY_LIBRARIES_OPTION_NAME, Boolean.class, false, "-loader-loadOnlyLibraries", null, null, true));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (name.equals(LINK_EXISTING_OPTION_NAME) || name.equals(LOAD_LIBRARY_OPTION_NAME) || name.equals(LOAD_ONLY_LIBRARIES_OPTION_NAME)) {
                    if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                if (name.equals(DEPTH_OPTION_NAME)) {
                    if (Integer.class.isAssignableFrom(option.getValueClass())) continue;
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                if (!name.equals(LINK_SEARCH_FOLDER_OPTION_NAME) && !name.equals(LIBRARY_DEST_FOLDER_OPTION_NAME)) continue;
                if (!String.class.isAssignableFrom(option.getValueClass())) {
                    return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
                }
                String value = (String)option.getValue();
                if (value.isEmpty() || value.startsWith("/")) continue;
                return "Invalid absolute project path for option: " + name;
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    protected boolean isLinkExistingLibraries(List<Option> options) {
        return OptionUtils.getOption(LINK_EXISTING_OPTION_NAME, options, true);
    }

    protected DomainFolder getLinkSearchFolder(Project project, Program program, String projectFolderPath, List<Option> options, MessageLog log) {
        if (!this.shouldSearchAllPaths(program, options, log) && !this.isLinkExistingLibraries(options)) {
            return null;
        }
        if (project == null) {
            return null;
        }
        String linkSearchFolderPath = OptionUtils.getOption(LINK_SEARCH_FOLDER_OPTION_NAME, options, "");
        ProjectData projectData = project.getProjectData();
        if (linkSearchFolderPath.isBlank()) {
            if (projectFolderPath == null) {
                return null;
            }
            return projectData.getFolder(projectFolderPath);
        }
        return projectData.getFolder(FilenameUtils.separatorsToUnix((String)linkSearchFolderPath));
    }

    protected boolean isLoadLibraries(List<Option> options) {
        return OptionUtils.getOption(LOAD_LIBRARY_OPTION_NAME, options, false);
    }

    protected boolean shouldLoadOnlyLibraries(List<Option> options) {
        return OptionUtils.getOption(LOAD_ONLY_LIBRARIES_OPTION_NAME, options, false);
    }

    protected int getLibraryLoadDepth(List<Option> options) {
        return OptionUtils.getOption(DEPTH_OPTION_NAME, options, 1);
    }

    protected String getLibraryDestinationFolderPath(Project project, String projectFolderPath, List<Option> options) {
        if (project == null) {
            return null;
        }
        String libraryDestinationFolderPath = OptionUtils.getOption(LIBRARY_DEST_FOLDER_OPTION_NAME, options, "");
        if (libraryDestinationFolderPath.isBlank()) {
            return projectFolderPath;
        }
        return FilenameUtils.separatorsToUnix((String)libraryDestinationFolderPath);
    }

    protected DomainFolder getLibraryDestinationSearchFolder(Project project, String libraryDestinationFolderPath, List<Option> options) {
        if (project == null || libraryDestinationFolderPath == null) {
            return null;
        }
        if (!this.isLoadLibraries(options)) {
            return null;
        }
        return project.getProjectData().getFolder(libraryDestinationFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DomainFolder> getLibrarySearchFolders(List<Loaded<Program>> loadedPrograms, Project project, List<Option> options, MessageLog log) {
        Program firstProgram = loadedPrograms.getFirst().getDomainObject(this);
        try {
            ArrayList<DomainFolder> searchFolders = new ArrayList<DomainFolder>();
            String projectFolderPath = loadedPrograms.get(0).getProjectFolderPath();
            String destPath = this.getLibraryDestinationFolderPath(project, projectFolderPath, options);
            DomainFolder destSearchFolder = this.getLibraryDestinationSearchFolder(project, destPath, options);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(project, firstProgram, projectFolderPath, options, log);
            Optional.ofNullable(destSearchFolder).ifPresent(searchFolders::add);
            Optional.ofNullable(linkSearchFolder).ifPresent(searchFolders::add);
            ArrayList<DomainFolder> arrayList = searchFolders;
            return arrayList;
        }
        finally {
            firstProgram.release((Object)this);
        }
    }

    protected boolean shouldSearchAllPaths(Program program, List<Option> options, MessageLog log) {
        return false;
    }

    protected boolean isCaseInsensitiveLibraryFilenames() {
        return false;
    }

    protected boolean isOptionalLibraryFilenameExtensions() {
        return false;
    }

    protected ByteProvider createLibraryByteProvider(FSRL libFsrl, LoadSpec loadSpec, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        return FileSystemService.getInstance().getByteProvider(libFsrl, true, monitor);
    }

    protected void processLibrary(Program library, String libraryName, FSRL libraryFsrl, ByteProvider provider, Queue<UnprocessedLibrary> unprocessed, int depth, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Loaded<Program>> loadLibraries(ByteProvider provider, Program program, Project project, String projectFolderPath, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, List<String> libraryNameList, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<Loaded<Program>> arrayList;
        List<LibrarySearchPath> searchPaths;
        List<LibrarySearchPath> customSearchPaths;
        block8: {
            ArrayList<Loaded<Program>> loadedPrograms = new ArrayList<Loaded<Program>>();
            TreeSet<String> processed = new TreeSet<String>(this.getLibraryNameComparator());
            Queue<UnprocessedLibrary> unprocessed = this.createUnprocessedQueue(libraryNameList, options);
            boolean loadLibraries = this.isLoadLibraries(options);
            customSearchPaths = this.getCustomLibrarySearchPaths(provider, options, log, monitor);
            searchPaths = this.getLibrarySearchPaths(program, desiredLoadSpec, options, log, monitor);
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(project, program, projectFolderPath, options, log);
            String libraryDestFolderPath = this.getLibraryDestinationFolderPath(project, projectFolderPath, options);
            DomainFolder libraryDestFolder = this.getLibraryDestinationSearchFolder(project, libraryDestFolderPath, options);
            boolean success = false;
            try {
                while (!unprocessed.isEmpty()) {
                    monitor.checkCancelled();
                    UnprocessedLibrary unprocessedLibrary = unprocessed.remove();
                    String library = unprocessedLibrary.name().trim();
                    int depth = unprocessedLibrary.depth();
                    if (depth == 0 || processed.contains(library)) continue;
                    processed.add(library);
                    if (this.findLibraryInProject(library, libraryDestFolder, searchPaths, options, monitor) != null) {
                        log.appendMsg("Found %s in %s...".formatted(library, libraryDestFolder));
                        log.appendMsg("------------------------------------------------\n");
                        continue;
                    }
                    if (this.findLibraryInProject(library, linkSearchFolder, searchPaths, options, monitor) != null) {
                        log.appendMsg("Found %s in %s...".formatted(library, linkSearchFolder));
                        log.appendMsg("------------------------------------------------\n");
                        continue;
                    }
                    if (!this.isLoadLibraries(options) && !this.shouldSearchAllPaths(program, options, log)) continue;
                    Loaded<Program> loadedLibrary = this.loadLibraryFromSearchPaths(library, provider, project, customSearchPaths, libraryDestFolderPath, unprocessed, depth, desiredLoadSpec, options, log, consumer, monitor);
                    if (loadedLibrary == null) {
                        loadedLibrary = this.loadLibraryFromSearchPaths(library, provider, project, searchPaths, libraryDestFolderPath, unprocessed, depth, desiredLoadSpec, options, log, consumer, monitor);
                    }
                    if (loadedLibrary != null) {
                        boolean temporary = !loadLibraries || unprocessedLibrary.temporary();
                        loadedLibrary.apply(p -> p.setTemporary(temporary));
                        loadedPrograms.add(loadedLibrary);
                        log.appendMsg((String)(temporary ? "Library not saved to project." : "Saving library to: " + String.valueOf(loadedLibrary)));
                    }
                    log.appendMsg("------------------------------------------------\n");
                }
                success = true;
                arrayList = loadedPrograms;
                if (success) break block8;
            }
            catch (Throwable throwable) {
                if (!success) {
                    loadedPrograms.forEach(Loaded::close);
                }
                Stream.of(customSearchPaths, searchPaths).flatMap(Collection::stream).forEach(fsSearchPath -> {
                    if (!fsSearchPath.fsRef().isClosed()) {
                        fsSearchPath.fsRef().close();
                    }
                });
                FileSystemService.getInstance().closeUnusedFileSystems();
                throw throwable;
            }
            loadedPrograms.forEach(Loaded::close);
        }
        Stream.of(customSearchPaths, searchPaths).flatMap(Collection::stream).forEach(fsSearchPath -> {
            if (!fsSearchPath.fsRef().isClosed()) {
                fsSearchPath.fsRef().close();
            }
        });
        FileSystemService.getInstance().closeUnusedFileSystems();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loaded<Program> loadLibraryFromSearchPaths(String library, ByteProvider provider, Project project, List<LibrarySearchPath> searchPaths, String libraryDestFolderPath, Queue<UnprocessedLibrary> unprocessed, int depth, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        if (searchPaths.isEmpty()) {
            return null;
        }
        log.appendMsg("Searching %d path%s for library %s...".formatted(searchPaths.size(), searchPaths.size() > 1 ? "s" : "", library));
        Program libraryProgram = null;
        String simpleLibraryName = FilenameUtils.getName((String)library);
        boolean isAbsolute = this.isAbsoluteLibraryPath(library);
        boolean success = false;
        try {
            List<FSRL> candidateLibraryFsrls = this.findLibraryOnDisk(library, searchPaths, log, monitor);
            if (candidateLibraryFsrls.isEmpty()) {
                log.appendMsg("Library not found.");
                Loaded<Program> loaded = null;
                return loaded;
            }
            for (FSRL candidateLibraryFsrl : candidateLibraryFsrls) {
                monitor.checkCancelled();
                ArrayList<String> newLibraryList = new ArrayList<String>();
                libraryProgram = this.loadLibrary(simpleLibraryName, candidateLibraryFsrl, desiredLoadSpec, newLibraryList, options, consumer, log, monitor);
                for (String newLibraryName : newLibraryList) {
                    unprocessed.add(new UnprocessedLibrary(newLibraryName, depth - 1, false));
                }
                if (libraryProgram == null) continue;
                this.processLibrary(libraryProgram, library, candidateLibraryFsrl, provider, unprocessed, depth, desiredLoadSpec, options, log, monitor);
                success = true;
                String folderPath = libraryDestFolderPath;
                if (folderPath != null && isAbsolute) {
                    folderPath = this.joinPaths(folderPath, FilenameUtils.getFullPath((String)library));
                }
                Loaded<Program> loaded = new Loaded<Program>(libraryProgram, simpleLibraryName, project, folderPath, consumer);
                return loaded;
            }
        }
        finally {
            if (!success && libraryProgram != null) {
                libraryProgram.release(consumer);
            }
        }
        return null;
    }

    protected DomainFile findLibraryInProject(String library, DomainFolder rootSearchFolder, List<LibrarySearchPath> searchPaths, List<Option> options, TaskMonitor monitor) throws CancelledException {
        if (rootSearchFolder == null) {
            return null;
        }
        String projectPath = this.joinPaths(rootSearchFolder.getPathname(), library);
        ProjectData projectData = rootSearchFolder.getProjectData();
        DomainFile ret = projectData.getFile(projectPath);
        if (ret != null) {
            return ret;
        }
        String libraryName = FilenameUtils.getName((String)library);
        ret = rootSearchFolder.getFile(libraryName);
        if (ret != null) {
            return ret;
        }
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        Comparator<String> comparator = this.getLibraryNameComparator();
        for (DomainFile file : rootSearchFolder.getFiles()) {
            String candidateName = file.getName();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (comparator.compare(candidateName, libraryName) != 0) continue;
            return file;
        }
        return null;
    }

    private List<FSRL> findLibraryOnDisk(String library, List<LibrarySearchPath> searchPaths, MessageLog log, TaskMonitor monitor) throws CancelledException {
        ArrayList<FSRL> results = new ArrayList<FSRL>();
        try {
            for (LibrarySearchPath searchPath : searchPaths) {
                monitor.checkCancelled();
                String fullLibraryPath = FSUtilities.appendPath(searchPath.relativeFsPath(), library);
                GFileSystem fs = searchPath.fsRef().getFilesystem();
                FSRL fsrl = this.resolveLibraryFile(fs, fullLibraryPath);
                Optional.ofNullable(fsrl).ifPresent(results::add);
            }
            if (results.isEmpty() && this.isAbsoluteLibraryPath(library)) {
                LocalFileSystem localFS = FileSystemService.getInstance().getLocalFS();
                FSRL fsrl = this.resolveLibraryFile(localFS, library);
                Optional.ofNullable(fsrl).ifPresent(results::add);
            }
        }
        catch (IOException e) {
            log.appendException((Throwable)e);
        }
        return results;
    }

    private Program loadLibrary(String libraryName, FSRL libraryFsrl, LoadSpec desiredLoadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        try (ByteProvider provider = this.createLibraryByteProvider(libraryFsrl, desiredLoadSpec, log, monitor);){
            LoadSpec libLoadSpec = this.matchSupportedLoadSpec(desiredLoadSpec, provider);
            if (libLoadSpec == null) {
                log.appendMsg("Skipping library which is the wrong architecture: " + String.valueOf(libraryFsrl));
                Program program = null;
                return program;
            }
            Program program = this.doLoad(provider, libraryName, libLoadSpec, libraryNameList, options, consumer, log, monitor);
            return program;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doLoad(ByteProvider provider, String programName, LoadSpec loadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language language = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec compilerSpec = language.getCompilerSpecByID(pair.compilerSpecID);
        monitor.setMessage(provider.getName());
        Address imageBaseAddr = language.getAddressFactory().getDefaultAddressSpace().getAddress(loadSpec.getDesiredImageBase());
        Program program = this.createProgram(provider, programName, imageBaseAddr, this.getName(), language, compilerSpec, consumer);
        int transactionID = program.startTransaction("Loading");
        boolean success = false;
        try {
            log.appendMsg("Loading %s...".formatted(provider.getFSRL()));
            this.load(provider, loadSpec, options, program, monitor, log);
            this.createDefaultMemoryBlocks(program, language, log);
            libraryNameList.addAll(this.getLibraryNames(provider, program));
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            program.endTransaction(transactionID, true);
            if (!success) {
                program.release(consumer);
            }
        }
    }

    private List<String> getLibraryNames(ByteProvider provider, Program program) {
        ArrayList<String> libraryNames = new ArrayList<String>();
        ExternalManager extMgr = program.getExternalManager();
        String[] externalNames = extMgr.getExternalLibraryNames();
        Comparator<String> comparator = this.getLibraryNameComparator();
        Arrays.sort(externalNames, comparator);
        for (String name : externalNames) {
            if (comparator.compare(name, provider.getName()) == 0 || comparator.compare(name, program.getName()) == 0 || "<EXTERNAL>".equals(name)) continue;
            libraryNames.add(name);
        }
        return libraryNames;
    }

    private void resolveExternalLibraries(Program program, List<Loaded<Program>> loadedPrograms, List<DomainFolder> searchFolders, List<LibrarySearchPath> fsSearchPaths, List<Option> options, TaskMonitor monitor, MessageLog log) throws CancelledException {
        ExternalManager extManager = program.getExternalManager();
        String[] extLibNames = extManager.getExternalLibraryNames();
        log.appendMsg("Linking the External Programs of '%s' to imported libraries...".formatted(program.getName()));
        for (String externalLibName : extLibNames) {
            if ("<EXTERNAL>".equals(externalLibName)) continue;
            monitor.checkCancelled();
            try {
                Loaded<Program> match = this.findLibraryInLoadedList(loadedPrograms, externalLibName);
                if (match != null) {
                    String path = match.getProjectFolderPath() + match.getName();
                    extManager.setExternalPath(externalLibName, path, false);
                    log.appendMsg("  [" + externalLibName + "] -> [" + path + "]");
                    continue;
                }
                boolean found = false;
                for (DomainFolder searchFolder : searchFolders) {
                    DomainFile alreadyImportedLib = this.findLibraryInProject(externalLibName, searchFolder, fsSearchPaths, options, monitor);
                    if (alreadyImportedLib == null) continue;
                    extManager.setExternalPath(externalLibName, alreadyImportedLib.getPathname(), false);
                    log.appendMsg("  [" + externalLibName + "] -> [" + alreadyImportedLib.getPathname() + "] (previously imported)");
                    found = true;
                    break;
                }
                if (found) continue;
                log.appendMsg("  [" + externalLibName + "] -> not found in project");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Bad library name: " + externalLibName), (Throwable)e);
            }
        }
        log.appendMsg("------------------------------------------------\n");
    }

    private Queue<UnprocessedLibrary> createUnprocessedQueue(List<String> libraryNames, List<Option> options) {
        int depth = this.getLibraryLoadDepth(options);
        return libraryNames.stream().map(name -> new UnprocessedLibrary((String)name, depth, false)).collect(Collectors.toCollection(LinkedList::new));
    }

    protected List<LibrarySearchPath> getCustomLibrarySearchPaths(ByteProvider provider, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        return List.of();
    }

    protected boolean isValidSearchPath(FSRL fsrl, LoadSpec loadSpec, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LibrarySearchPath> getLibrarySearchPaths(Program program, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (!this.isLoadLibraries(options) && !this.shouldSearchAllPaths(program, options, log)) {
            return List.of();
        }
        FileSystemService fsService = FileSystemService.getInstance();
        ArrayList<LibrarySearchPath> result = new ArrayList<LibrarySearchPath>();
        boolean success = false;
        try {
            for (FSRL fsrl : LibrarySearchPathManager.getLibraryFsrlList(program, log, monitor)) {
                Closeable fileRef;
                if (!this.isValidSearchPath(fsrl, loadSpec, monitor)) continue;
                if (fsService.isLocal(fsrl)) {
                    try {
                        if (fsService.getLocalFS().getLocalFile(fsrl).isFile() && (fileRef = fsService.probeFileForFilesystem(fsrl, monitor, null)) != null) {
                            result.add(new LibrarySearchPath((FileSystemRef)fileRef, null));
                            continue;
                        }
                    }
                    catch (IOException e) {
                        log.appendMsg(e.getMessage());
                    }
                }
                try {
                    fileRef = fsService.getRefdFile(fsrl, monitor);
                    try {
                        if (fileRef == null) continue;
                        result.add(new LibrarySearchPath(((RefdFile)fileRef).fsRef.dup(), ((RefdFile)fileRef).file.getPath()));
                    }
                    finally {
                        if (fileRef == null) continue;
                        ((RefdFile)fileRef).close();
                    }
                }
                catch (IOException e) {
                    log.appendMsg(e.getMessage());
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                result.forEach(fsSearchPath -> fsSearchPath.fsRef().close());
            }
        }
        return result;
    }

    protected Loaded<Program> findLibraryInLoadedList(List<Loaded<Program>> loadedPrograms, String libraryName) {
        Comparator<String> comparator = this.getLibraryNameComparator();
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        boolean absolute = libraryName.startsWith("/");
        for (Loaded<Program> loadedProgram : loadedPrograms) {
            String loadedProgramPath;
            String candidateName = loadedProgram.getName();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (!(absolute ? (loadedProgramPath = loadedProgram.getProjectFolderPath() + candidateName).endsWith(libraryName) : comparator.compare(candidateName, libraryName) == 0)) continue;
            return loadedProgram;
        }
        return null;
    }

    protected LoadSpec matchSupportedLoadSpec(LoadSpec desiredLoadSpec, ByteProvider provider) throws IOException {
        LanguageCompilerSpecPair desiredPair = desiredLoadSpec.getLanguageCompilerSpec();
        Collection<LoadSpec> supportedLoadSpecs = this.findSupportedLoadSpecs(provider);
        if (supportedLoadSpecs != null) {
            for (LoadSpec supportedLoadSpec : supportedLoadSpecs) {
                if (!desiredPair.equals((Object)supportedLoadSpec.getLanguageCompilerSpec())) continue;
                return supportedLoadSpec;
            }
        }
        return null;
    }

    protected FSRL resolveLibraryFile(GFileSystem fs, String library) throws IOException {
        Comparator baseNameComp = this.getLibraryNameComparator();
        Comparator nameComp = this.isOptionalLibraryFilenameExtensions() && FilenameUtils.getExtension((String)library).isEmpty() ? (s1, s2) -> baseNameComp.compare(FilenameUtils.getBaseName((String)s1), FilenameUtils.getBaseName((String)s2)) : baseNameComp;
        GFile foundFile = fs.lookup(library, nameComp);
        return foundFile != null && !foundFile.isDirectory() ? foundFile.getFSRL() : null;
    }

    private Comparator<String> getLibraryNameComparator() {
        return this.isCaseInsensitiveLibraryFilenames() ? String.CASE_INSENSITIVE_ORDER : (s1, s2) -> s1.compareTo((String)s2);
    }

    private boolean isAbsoluteLibraryPath(String path) {
        return FilenameUtils.getPrefixLength((String)path) > 0;
    }

    protected record UnprocessedLibrary(String name, int depth, boolean temporary) {
    }

    protected record LibrarySearchPath(FileSystemRef fsRef, String relativeFsPath) {
    }
}

