/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import generic.stl.Pair;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.importer.CsHintLoadSpecChooser;
import ghidra.app.util.importer.LcsHintLoadSpecChooser;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.LoadSpecChooser;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ProgramLoader {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteProvider provider;
        private FSRL fsrl;
        private File file;
        private byte[] bytes;
        private Project project;
        private String projectFolderPath;
        private String importNameOverride;
        private Predicate<Loader> loaderFilter = LoaderService.ACCEPT_ALL;
        private List<Pair<String, String>> loaderArgs = new ArrayList<Pair<String, String>>();
        private LanguageID languageId;
        private CompilerSpecID compilerSpecId;
        private MessageLog log = new MessageLog();
        private TaskMonitor monitor = TaskMonitor.DUMMY;

        private Builder() {
        }

        public Builder source(ByteProvider p) {
            this.provider = p;
            this.fsrl = null;
            this.file = null;
            this.bytes = null;
            return this;
        }

        public Builder source(FSRL f) {
            this.provider = null;
            this.fsrl = f;
            this.file = null;
            this.bytes = null;
            return this;
        }

        public Builder source(File f) {
            this.provider = null;
            this.fsrl = null;
            this.file = f;
            this.bytes = null;
            return this;
        }

        public Builder source(byte[] b) {
            this.provider = null;
            this.fsrl = null;
            this.file = null;
            this.bytes = b;
            return this;
        }

        public Builder source(String path) {
            return this.source(new File(path));
        }

        public Builder project(Project p) {
            this.project = p;
            return this;
        }

        public Builder projectFolderPath(String path) {
            this.projectFolderPath = path;
            return this;
        }

        public Builder name(String name) {
            this.importNameOverride = name;
            return this;
        }

        public Builder loaders(Predicate<Loader> filter) {
            this.loaderFilter = filter != null ? filter : LoaderService.ACCEPT_ALL;
            return this;
        }

        public Builder loaders(Class<? extends Loader> cls) {
            this.loaderFilter = cls != null ? loader -> loader.getClass().equals(cls) : LoaderService.ACCEPT_ALL;
            return this;
        }

        public Builder loaders(String clsName) throws InvalidInputException {
            Class<? extends Loader> cls = LoaderService.getLoaderClassByName(clsName);
            if (cls == null) {
                throw new InvalidInputException("Loader '%s' does not exist!".formatted(clsName));
            }
            return this.loaders(cls);
        }

        public Builder loaders(List<Class<? extends Loader>> cls) {
            this.loaderFilter = cls != null ? loader -> cls.contains(loader.getClass()) : LoaderService.ACCEPT_ALL;
            return this;
        }

        public Builder loaderArgs(List<Pair<String, String>> args) {
            this.loaderArgs = args != null ? new ArrayList<Pair<String, String>>(args) : new ArrayList();
            return this;
        }

        public Builder addLoaderArg(String name, String value) {
            this.loaderArgs.add((Pair<String, String>)new Pair((Object)name, (Object)value));
            return this;
        }

        public Builder language(String id) {
            this.languageId = id != null ? new LanguageID(id) : null;
            return this;
        }

        public Builder language(LanguageID id) {
            this.languageId = id;
            return this;
        }

        public Builder language(Language language) {
            this.languageId = language != null ? language.getLanguageID() : null;
            return this;
        }

        public Builder compiler(String id) {
            this.compilerSpecId = id != null ? new CompilerSpecID(id) : null;
            return this;
        }

        public Builder compiler(CompilerSpecID id) {
            this.compilerSpecId = id;
            return this;
        }

        public Builder compiler(CompilerSpec cspec) {
            this.compilerSpecId = cspec != null ? cspec.getCompilerSpecID() : null;
            return this;
        }

        public Builder log(MessageLog messageLog) {
            this.log = messageLog;
            return this;
        }

        public Builder monitor(TaskMonitor mon) {
            this.monitor = mon;
            return this;
        }

        public LoadResults<Program> load() throws IOException, LanguageNotFoundException, CancelledException, VersionException, LoadException {
            return this.load(this);
        }

        @Deprecated(since="12.0", forRemoval=true)
        LoadResults<Program> load(Object consumer) throws IOException, LanguageNotFoundException, CancelledException, VersionException, LoadException {
            try (ByteProvider p = this.getSourceAsProvider();){
                LoadSpec loadSpec = this.getLoadSpec(p);
                List<Option> loaderOptions = this.getLoaderOptions(p, loadSpec);
                String importName = this.importNameOverride != null ? this.importNameOverride : loadSpec.getLoader().getPreferredFileName(p);
                Msg.info(ProgramLoader.class, (Object)("Using Loader: " + loadSpec.getLoader().getName()));
                Msg.info(ProgramLoader.class, (Object)("Using Language/Compiler: " + String.valueOf(loadSpec.getLanguageCompilerSpec())));
                Msg.info(ProgramLoader.class, (Object)("Using Library Search Path: " + Arrays.toString(LibrarySearchPathManager.getLibraryPaths())));
                LoadResults<? extends DomainObject> loadResults = loadSpec.getLoader().load(p, importName, this.project, this.projectFolderPath, loadSpec, loaderOptions, this.log, Objects.requireNonNullElse(consumer, this), this.monitor);
                if (!Loader.loggingDisabled && this.log.hasMessages()) {
                    Msg.info(ProgramLoader.class, (Object)("Additional info:\n" + String.valueOf(this.log)));
                }
                ArrayList loadedPrograms = new ArrayList();
                for (Loaded<? extends DomainObject> loaded : loadResults) {
                    if (Program.class.isAssignableFrom(loaded.getDomainObjectType())) {
                        loadedPrograms.add(loaded);
                        continue;
                    }
                    try {
                        loaded.close();
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                if (loadedPrograms.isEmpty()) {
                    throw new LoadException("Domain objects were loaded, but none were Programs");
                }
                LoadResults loadResults2 = new LoadResults(loadedPrograms);
                return loadResults2;
            }
        }

        private ByteProvider getSourceAsProvider() throws IOException, LoadException, CancelledException {
            ByteProvider p;
            FileSystemService fsService = FileSystemService.getInstance();
            if (this.provider != null) {
                p = new ByteProviderWrapper(this.provider, this.provider.getFSRL());
            } else if (this.fsrl != null) {
                p = fsService.getByteProvider(this.fsrl, true, this.monitor);
            } else if (this.file != null) {
                p = fsService.getByteProvider(fsService.getLocalFSRL(this.file), true, this.monitor);
            } else if (this.bytes != null) {
                if (this.importNameOverride == null) {
                    throw new LoadException("Byte source does not have a name (was name() called?)");
                }
                p = new ByteArrayProvider(this.bytes);
            } else {
                throw new LoadException("No source to import!");
            }
            return p;
        }

        private LoadSpec getLoadSpec(ByteProvider p) throws LanguageNotFoundException, LoadException {
            LoaderMap loaderMap;
            LoadSpecChooser loadSpecChooser = this.languageId != null ? new LcsHintLoadSpecChooser(this.languageId, this.compilerSpecId) : (this.compilerSpecId != null ? new CsHintLoadSpecChooser(this.compilerSpecId) : LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED);
            LoadSpec loadSpec = loadSpecChooser.choose(loaderMap = LoaderService.getSupportedLoadSpecs(p, this.loaderFilter));
            if (loadSpec == null) {
                String name = Objects.requireNonNullElse(p.getName(), "???");
                Msg.info(ProgramLoader.class, (Object)("No load spec found for import file: " + name));
                throw new LoadException("No load spec found");
            }
            return loadSpec;
        }

        private List<Option> getLoaderOptions(ByteProvider p, LoadSpec loadSpec) throws LanguageNotFoundException, LoadException {
            List<Option> options = loadSpec.getLoader().getDefaultOptions(p, loadSpec, null, false);
            if (options == null) {
                throw new LoadException("Cannot load with null options");
            }
            if (this.loaderArgs == null) {
                return options;
            }
            LanguageCompilerSpecPair languageCompilerSpecPair = loadSpec.getLanguageCompilerSpec();
            AddressFactory addrFactory = null;
            if (languageCompilerSpecPair != null) {
                addrFactory = DefaultLanguageService.getLanguageService().getLanguage(languageCompilerSpecPair.languageID).getAddressFactory();
            }
            for (Pair<String, String> pair : this.loaderArgs) {
                String arg = (String)pair.first;
                String val = (String)pair.second;
                boolean foundIt = false;
                for (Option option : options) {
                    if (option.getArg() == null || !arg.equalsIgnoreCase(option.getArg())) continue;
                    Object oldVal = option.getValue();
                    if (!option.parseAndSetValueByType(val, addrFactory)) {
                        Msg.error(ProgramLoader.class, (Object)String.format("Failed to apply \"%s\" to \"%s\" (old: \"%s\", bad: \"%s\")", arg, option.getName(), oldVal, val));
                        return null;
                    }
                    Msg.info(ProgramLoader.class, (Object)String.format("Successfully applied \"%s\" to \"%s\" (old: \"%s\", new: \"%s\")", arg, option.getName(), oldVal, val));
                    foundIt = true;
                    break;
                }
                if (foundIt) continue;
                Msg.warn(ProgramLoader.class, (Object)("Skipping unsupported " + arg + " argument"));
            }
            return options;
        }
    }
}

