/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;

public enum GoKind {
    invalid("invalid"),
    Bool("bool"),
    Int("int"),
    Int8("int8"),
    Int16("int16"),
    Int32("int32"),
    Int64("int64"),
    Uint("uint"),
    Uint8("uint8"),
    Uint16("uint16"),
    Uint32("uint32"),
    Uint64("uint64"),
    Uintptr("uintptr"),
    Float32("float32"),
    Float64("float64"),
    Complex64("complex64"),
    Complex128("complex128"),
    Array("array"),
    Chan("chan"),
    Func("func()"),
    Interface("interface"),
    Map("map"),
    Pointer("pointer"),
    Slice("slice"),
    String("string"),
    Struct("struct"),
    UnsafePointer("unsafe.Pointer");

    public static final int KIND_MASK = 31;
    public static final int GC_PROG = 64;
    public static final int DIRECT_IFACE = 32;
    private static final Set<GoKind> PRIMITIVE_KINDS;
    private static final GoKind[] ALLKINDS;
    private final String typeName;

    public static GoKind parseByte(int b) {
        int ordinal = b & 0x1F;
        return Bool.ordinal() <= ordinal && ordinal <= UnsafePointer.ordinal() ? GoKind.values()[ordinal] : invalid;
    }

    public static GoKind parseTypename(String typeName) throws IOException {
        for (GoKind kind : ALLKINDS) {
            if (!kind.typeName.equalsIgnoreCase(typeName)) continue;
            return kind;
        }
        return invalid;
    }

    private GoKind(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isPrimitive() {
        return PRIMITIVE_KINDS.contains((Object)this);
    }

    static {
        PRIMITIVE_KINDS = EnumSet.of(Bool, new GoKind[]{Int, Int8, Int16, Int32, Int64, Uint, Uint8, Uint16, Uint32, Uint64, Uintptr, Float32, Float64, Complex64, Complex128, Pointer, String, UnsafePointer});
        ALLKINDS = GoKind.values();
    }
}

