/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFRegisterMappings;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionInstruction;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOpCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DWARFExpression {
    public static final int MAX_SANE_EXPR = 256;
    private final List<DWARFExpressionInstruction> instructions;

    public static DWARFExpression read(byte[] exprBytes, DWARFCompilationUnit cu) throws DWARFExpressionException {
        return DWARFExpression.read(exprBytes, cu.getPointerSize(), cu.getProgram().isLittleEndian(), cu.getIntSize());
    }

    private static DWARFExpression read(byte[] exprBytes, byte addrSize, boolean isLittleEndian, int intSize) throws DWARFExpressionException {
        ByteArrayProvider provider = new ByteArrayProvider(exprBytes);
        BinaryReader reader = new BinaryReader(provider, isLittleEndian);
        return DWARFExpression.read(reader, addrSize, intSize);
    }

    private static DWARFExpression read(BinaryReader reader, byte addrSize, int intSize) throws DWARFExpressionException {
        ArrayList<DWARFExpressionInstruction> instructions = new ArrayList<DWARFExpressionInstruction>();
        try {
            while (reader.hasNext()) {
                DWARFExpressionInstruction instr = DWARFExpressionInstruction.read(reader, addrSize, intSize);
                instructions.add(instr);
                if (instr.getOpCode() != DWARFExpressionOpCode.DW_OP_unknown_opcode) continue;
                throw new IOException("Unknown DWARF opcode(s) encountered");
            }
            return new DWARFExpression(instructions);
        }
        catch (IOException ioe) {
            DWARFExpression badExpr = new DWARFExpression(instructions);
            throw new DWARFExpressionException("Error reading DWARF expression, partial expression is: ", badExpr, -1, ioe);
        }
    }

    private DWARFExpression(List<DWARFExpressionInstruction> instructions) {
        this.instructions = instructions;
    }

    public DWARFExpression toGenericForm() {
        List<DWARFExpressionInstruction> genericInstrs = this.instructions.stream().map(DWARFExpressionInstruction::toGenericForm).toList();
        return new DWARFExpression(genericInstrs);
    }

    public DWARFExpressionInstruction getInstruction(int i) {
        return this.instructions.get(i);
    }

    public int getInstructionCount() {
        return this.instructions.size();
    }

    public boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    public int findInstructionByOffset(long offset) {
        for (int i = 0; i < this.instructions.size(); ++i) {
            DWARFExpressionInstruction instr = this.getInstruction(i);
            if ((long)instr.getOffset() != offset) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.toString(-1, false, false, null);
    }

    public String toString(DWARFCompilationUnit cu) {
        return this.toString(-1, false, false, cu.getProgram().getRegisterMappings());
    }

    public String toString(int caretPosition, boolean newlines, boolean offsets, DWARFRegisterMappings regMapping) {
        StringBuilder sb = new StringBuilder();
        for (int instrIndex = 0; instrIndex < this.instructions.size(); ++instrIndex) {
            DWARFExpressionInstruction instr = this.instructions.get(instrIndex);
            if (instrIndex != 0) {
                sb.append(newlines ? "\n" : "; ");
            }
            if (offsets) {
                sb.append("%3d [%03x]: ".formatted(instrIndex, instr.getOffset()));
            }
            if (caretPosition == instrIndex) {
                sb.append(" ==> [");
            }
            sb.append(instr.getOpCode().toString(regMapping));
            for (int operandIndex = 0; operandIndex < instr.getOperandCount(); ++operandIndex) {
                if (operandIndex == 0) {
                    sb.append(':');
                }
                sb.append(' ');
                sb.append(instr.getOperandRepresentation(operandIndex));
            }
            if (caretPosition == instrIndex) {
                sb.append(" ] <==");
            }
            if (instr.opcode != DWARFExpressionOpCode.DW_OP_bra && instr.opcode != DWARFExpressionOpCode.DW_OP_skip) continue;
            long destOffset = instr.getOperandValue(0) + (long)instr.getOffset();
            int destIndex = this.findInstructionByOffset(destOffset);
            sb.append(String.format(" /* dest index: %d, offset: %03x */", destIndex, (int)destOffset));
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.instructions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DWARFExpression)) {
            return false;
        }
        DWARFExpression other = (DWARFExpression)obj;
        return Objects.equals(this.instructions, other.instructions);
    }
}

