/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.plugin.core.analysis.AnalysisOptionsUpdater;
import ghidra.framework.options.Options;
import java.nio.charset.Charset;

public class DWARFImportOptions {
    private static final String OPTION_IMPORT_DATATYPES = "Import Data Types";
    private static final String OPTION_IMPORT_DATATYPES_DESC = "Import data types defined in the DWARF debug info.";
    private static final String OPTION_IMPORT_FUNCS = "Import Functions";
    private static final String OPTION_IMPORT_FUNCS_DESC = "Import function information defined in the DWARF debug info\n(implies 'Import Data Types' is selected).";
    private static final String OPTION_OUTPUT_SOURCE_INFO = "Output Source Info";
    private static final String OPTION_OUTPUT_SOURCE_INFO_DESC = "Include source code location info (filename:linenumber) in comments attached to the Ghidra datatype or function or variable created.";
    private static final String OPTION_SOURCE_LINEINFO = "Import Source Line Info";
    private static final String OPTION_SOURCE_LINEINFO_DESC = "Create source map entries containing the source code filename, line number, address, and length at each location provided in the DWARF data";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO = "Output DWARF DIE Info";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO_DESC = "Include DWARF DIE offset info in comments attached to the Ghidra datatype or function or variable created.";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS = "Add Lexical Block Comments";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_DESC = "Add comments to the start of lexical blocks";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS = "Add Inlined Functions Comments";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS_DESC = "Add comments to the start of inlined functions";
    private static final String OPTION_OUTPUT_FUNC_SIGS = "Create Function Signatures";
    private static final String OPTION_OUTPUT_FUNC_SIGS_DESC = "Create function signature data types for each function encountered in the DWARF debug data.";
    private static final String OPTION_TRY_PACK_STRUCTS = "Try To Pack Structs";
    private static final String OPTION_TRY_PACK_STRUCTS_DESC = "Try to pack structure/union data types.";
    private static final String OPTION_IMPORT_LOCAL_VARS = "Import Local Variable Info";
    private static final String OPTION_IMPORT_LOCAL_VARS_DESC = "Import local variable information from DWARF and attempt to create Ghidra local variables.";
    private static final String OPTION_IGNORE_PARAM_STORAGE = "Ignore Parameter Storage Info";
    private static final String OPTION_IGNORE_PARAM_STORAGE_DESC = "Ignore any function parameter storage info specifed, allow automatic layout.";
    private static final String OPTION_DEFAULT_CC = "Default Calling Convention";
    private static final String OPTION_DEFAULT_CC_DESC = "Name of default calling convention to assign to functions (e.g. __cdecl, __stdcall, etc), or leave blank.";
    private static final String OPTION_MAX_SOURCE_ENTRY_LENGTH = "Maximum Source Map Entry Length";
    private static final String OPTION_MAX_SOURCE_ENTRY_LENGTH_DESC = "Maximum length for a source map entry.  Longer lengths will be replaced with 0";
    private static final String OPTION_COPY_EXTERNAL_DEBUG_FILE_SYMBOLS = "Copy External Debug File Symbols";
    private static final String OPTION_COPY_EXTERNAL_DEBUG_FILE_SYMBOLS_DESC = "Copies symbols (which will typically be mangled) from a found external debug file into the main program";
    private static final String OPTION_CHARSET_NAME = "Debug Strings Charset";
    private static final String OPTION_CHARSET_NAME_DESC = "Charset to use when decoding debug strings (symbols, filenames, etc).\nDefault is utf-8.  Typical values will be 'ascii' or 'utf-8'.";
    private static final String OPTION_SHOW_VARIABLE_STORAGE_INFO = "Output Storage Info";
    private static final String OPTION_SHOW_VARIABLE_STORAGE_DESC = "Add DWARF storage info for parameters and variables to EOL comments.";
    private static final String OPTION_IMPORT_DATATYPES_OLD = "Import data types";
    private static final String OPTION_IMPORT_FUNCS_OLD = "Import functions";
    private static final String OPTION_OUTPUT_SOURCE_INFO_OLD = "Output Source info";
    private static final String OPTION_OUTPUT_DWARF_DIE_INFO_OLD = "Output DWARF DIE info";
    private static final String OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_OLD = "Lexical block comments";
    private static final String OPTION_OUTPUT_INLINE_FUNC_COMMENTS_OLD = "Inlined functions comments";
    private static final String OPTION_OUTPUT_FUNC_SIGS_OLD = "Output function signatures";
    private AnalysisOptionsUpdater optionsUpdater = new AnalysisOptionsUpdater();
    private boolean outputDWARFLocationInfo = false;
    private boolean outputDWARFDIEInfo = false;
    private boolean elideTypedefsWithSameName = true;
    private boolean importDataTypes = true;
    private boolean importFuncs = true;
    private boolean outputInlineFuncComments = false;
    private boolean outputLexicalBlockComments = false;
    private boolean copyRenameAnonTypes = true;
    private boolean createFuncSignatures = true;
    private boolean organizeTypesBySourceFile = true;
    private boolean tryPackStructs = true;
    private boolean specialCaseSizedBaseTypes = true;
    private boolean importLocalVariables = true;
    private boolean useBookmarks = true;
    private boolean outputSourceLineInfo = true;
    private boolean ignoreParamStorage = false;
    private String defaultCC = "";
    private long maxSourceMapEntryLength = 2000L;
    private boolean copyExternalDebugFileSymbols = true;
    private String charsetName = "";
    private boolean showVariableStorageInfo = false;
    private boolean useStaticStackFrameRegisterValue = true;

    public DWARFImportOptions() {
        this.optionsUpdater.registerReplacement(OPTION_IMPORT_DATATYPES, OPTION_IMPORT_DATATYPES_OLD);
        this.optionsUpdater.registerReplacement(OPTION_IMPORT_FUNCS, OPTION_IMPORT_FUNCS_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_SOURCE_INFO, OPTION_OUTPUT_SOURCE_INFO_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_DWARF_DIE_INFO, OPTION_OUTPUT_DWARF_DIE_INFO_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, OPTION_OUTPUT_INLINE_FUNC_COMMENTS_OLD);
        this.optionsUpdater.registerReplacement(OPTION_OUTPUT_FUNC_SIGS, OPTION_OUTPUT_FUNC_SIGS_OLD);
    }

    public AnalysisOptionsUpdater getOptionsUpdater() {
        return this.optionsUpdater;
    }

    public boolean isOutputSourceLocationInfo() {
        return this.outputDWARFLocationInfo;
    }

    public void setOutputSourceLocationInfo(boolean output_DWARF_location_info) {
        this.outputDWARFLocationInfo = output_DWARF_location_info;
    }

    public boolean isOutputDIEInfo() {
        return this.outputDWARFDIEInfo;
    }

    public void setOutputDIEInfo(boolean output_DWARF_die_info) {
        this.outputDWARFDIEInfo = output_DWARF_die_info;
    }

    public boolean isElideTypedefsWithSameName() {
        return this.elideTypedefsWithSameName;
    }

    public void setElideTypedefsWithSameName(boolean elide_typedefs_with_same_name) {
        this.elideTypedefsWithSameName = elide_typedefs_with_same_name;
    }

    public boolean isImportDataTypes() {
        return this.importDataTypes;
    }

    public void setImportDataTypes(boolean importDataTypes) {
        this.importDataTypes = importDataTypes;
    }

    public boolean isImportFuncs() {
        return this.importFuncs;
    }

    public void setImportFuncs(boolean output_Funcs) {
        this.importFuncs = output_Funcs;
    }

    public boolean isOutputInlineFuncComments() {
        return this.outputInlineFuncComments;
    }

    public void setOutputInlineFuncComments(boolean output_InlineFunc_comments) {
        this.outputInlineFuncComments = output_InlineFunc_comments;
    }

    public boolean isOutputLexicalBlockComments() {
        return this.outputLexicalBlockComments;
    }

    public void setOutputLexicalBlockComments(boolean output_LexicalBlock_comments) {
        this.outputLexicalBlockComments = output_LexicalBlock_comments;
    }

    public boolean isCopyRenameAnonTypes() {
        return this.copyRenameAnonTypes;
    }

    public void setCopyRenameAnonTypes(boolean b) {
        this.copyRenameAnonTypes = b;
    }

    public boolean isCreateFuncSignatures() {
        return this.createFuncSignatures;
    }

    public void setCreateFuncSignatures(boolean createFuncSignatures) {
        this.createFuncSignatures = createFuncSignatures;
    }

    public boolean isOrganizeTypesBySourceFile() {
        return this.organizeTypesBySourceFile;
    }

    public void setOrganizeTypesBySourceFile(boolean organizeTypesBySourceFile) {
        this.organizeTypesBySourceFile = organizeTypesBySourceFile;
    }

    public boolean isTryPackStructs() {
        return this.tryPackStructs;
    }

    public void setTryPackDataTypes(boolean tryPackStructs) {
        this.tryPackStructs = tryPackStructs;
    }

    public boolean isSpecialCaseSizedBaseTypes() {
        return this.specialCaseSizedBaseTypes;
    }

    public void setSpecialCaseSizedBaseTypes(boolean b) {
        this.specialCaseSizedBaseTypes = b;
    }

    public boolean isImportLocalVariables() {
        return this.importLocalVariables;
    }

    public void setImportLocalVariables(boolean importLocalVariables) {
        this.importLocalVariables = importLocalVariables;
    }

    public boolean isUseBookmarks() {
        return this.useBookmarks;
    }

    public boolean isOutputSourceLineInfo() {
        return this.outputSourceLineInfo;
    }

    public void setOutputSourceLineInfo(boolean outputSourceLineInfo) {
        this.outputSourceLineInfo = outputSourceLineInfo;
    }

    public boolean isIgnoreParamStorage() {
        return this.ignoreParamStorage;
    }

    public void setIgnoreParamStorage(boolean ignoreParamStorage) {
        this.ignoreParamStorage = ignoreParamStorage;
    }

    public String getDefaultCC() {
        return this.defaultCC;
    }

    public void setDefaultCC(String defaultCC) {
        this.defaultCC = defaultCC;
    }

    public long getMaxSourceMapEntryLength() {
        return this.maxSourceMapEntryLength;
    }

    public void setMaxSourceMapEntryLength(long maxLength) {
        if (maxLength < 0L) {
            maxLength = 0L;
        }
        this.maxSourceMapEntryLength = maxLength;
    }

    public boolean isCopyExternalDebugFileSymbols() {
        return this.copyExternalDebugFileSymbols;
    }

    public void setCopyExternalDebugFileSymbols(boolean b) {
        this.copyExternalDebugFileSymbols = b;
    }

    public Charset getCharset(Charset defaultCharset) {
        try {
            return this.charsetName != null && !this.charsetName.isBlank() ? Charset.forName(this.charsetName) : defaultCharset;
        }
        catch (Throwable th) {
            return defaultCharset;
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean isShowVariableStorageInfo() {
        return this.showVariableStorageInfo;
    }

    public void setShowVariableStorageInfo(boolean showVariableStorageInfo) {
        this.showVariableStorageInfo = showVariableStorageInfo;
    }

    public boolean isUseStaticStackFrameRegisterValue() {
        return this.useStaticStackFrameRegisterValue;
    }

    public void setUseStaticStackFrameRegisterValue(boolean useStaticStackFrameRegisterValue) {
        this.useStaticStackFrameRegisterValue = useStaticStackFrameRegisterValue;
    }

    public void registerOptions(Options options) {
        options.registerOption(OPTION_IMPORT_DATATYPES, (Object)this.isImportDataTypes(), null, OPTION_IMPORT_DATATYPES_DESC);
        options.registerOption(OPTION_IMPORT_FUNCS, (Object)this.isImportFuncs(), null, OPTION_IMPORT_FUNCS_DESC);
        options.registerOption(OPTION_OUTPUT_DWARF_DIE_INFO, (Object)this.isOutputDIEInfo(), null, OPTION_OUTPUT_DWARF_DIE_INFO_DESC);
        options.registerOption(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, (Object)this.isOutputLexicalBlockComments(), null, OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS_DESC);
        options.registerOption(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, (Object)this.isOutputInlineFuncComments(), null, OPTION_OUTPUT_INLINE_FUNC_COMMENTS_DESC);
        options.registerOption(OPTION_OUTPUT_SOURCE_INFO, (Object)this.isOutputSourceLocationInfo(), null, OPTION_OUTPUT_SOURCE_INFO_DESC);
        options.registerOption(OPTION_OUTPUT_FUNC_SIGS, (Object)this.isCreateFuncSignatures(), null, OPTION_OUTPUT_FUNC_SIGS_DESC);
        options.registerOption(OPTION_TRY_PACK_STRUCTS, (Object)this.isTryPackStructs(), null, OPTION_TRY_PACK_STRUCTS_DESC);
        options.registerOption(OPTION_IMPORT_LOCAL_VARS, (Object)this.isImportLocalVariables(), null, OPTION_IMPORT_LOCAL_VARS_DESC);
        options.registerOption(OPTION_SOURCE_LINEINFO, (Object)this.isOutputSourceLineInfo(), null, OPTION_SOURCE_LINEINFO_DESC);
        options.registerOption(OPTION_IGNORE_PARAM_STORAGE, (Object)this.isIgnoreParamStorage(), null, OPTION_IGNORE_PARAM_STORAGE_DESC);
        options.registerOption(OPTION_DEFAULT_CC, (Object)this.getDefaultCC(), null, OPTION_DEFAULT_CC_DESC);
        options.registerOption(OPTION_MAX_SOURCE_ENTRY_LENGTH, (Object)this.maxSourceMapEntryLength, null, OPTION_MAX_SOURCE_ENTRY_LENGTH_DESC);
        options.registerOption(OPTION_COPY_EXTERNAL_DEBUG_FILE_SYMBOLS, (Object)this.isCopyExternalDebugFileSymbols(), null, OPTION_COPY_EXTERNAL_DEBUG_FILE_SYMBOLS_DESC);
        options.registerOption(OPTION_CHARSET_NAME, (Object)this.getCharsetName(), null, OPTION_CHARSET_NAME_DESC);
        options.registerOption(OPTION_SHOW_VARIABLE_STORAGE_INFO, (Object)this.isShowVariableStorageInfo(), null, OPTION_SHOW_VARIABLE_STORAGE_DESC);
    }

    public void optionsChanged(Options options) {
        this.setOutputDIEInfo(options.getBoolean(OPTION_OUTPUT_DWARF_DIE_INFO, this.isOutputDIEInfo()));
        this.setOutputSourceLocationInfo(options.getBoolean(OPTION_OUTPUT_SOURCE_INFO, this.isOutputSourceLocationInfo()));
        this.setOutputLexicalBlockComments(options.getBoolean(OPTION_OUTPUT_LEXICAL_BLOCK_COMMENTS, this.isOutputLexicalBlockComments()));
        this.setOutputInlineFuncComments(options.getBoolean(OPTION_OUTPUT_INLINE_FUNC_COMMENTS, this.isOutputInlineFuncComments()));
        this.setImportDataTypes(options.getBoolean(OPTION_IMPORT_DATATYPES, this.isImportDataTypes()));
        this.setImportFuncs(options.getBoolean(OPTION_IMPORT_FUNCS, this.isImportFuncs()));
        this.setCreateFuncSignatures(options.getBoolean(OPTION_OUTPUT_FUNC_SIGS, this.isCreateFuncSignatures()));
        this.setTryPackDataTypes(options.getBoolean(OPTION_TRY_PACK_STRUCTS, this.isTryPackStructs()));
        this.setImportLocalVariables(options.getBoolean(OPTION_IMPORT_LOCAL_VARS, this.isImportLocalVariables()));
        this.setOutputSourceLineInfo(options.getBoolean(OPTION_SOURCE_LINEINFO, this.isOutputSourceLineInfo()));
        this.setIgnoreParamStorage(options.getBoolean(OPTION_IGNORE_PARAM_STORAGE, this.isIgnoreParamStorage()));
        this.setDefaultCC(options.getString(OPTION_DEFAULT_CC, this.getDefaultCC()));
        this.setMaxSourceMapEntryLength(options.getLong(OPTION_MAX_SOURCE_ENTRY_LENGTH, this.getMaxSourceMapEntryLength()));
        this.setCopyExternalDebugFileSymbols(options.getBoolean(OPTION_COPY_EXTERNAL_DEBUG_FILE_SYMBOLS, this.isCopyExternalDebugFileSymbols()));
        this.setCharsetName(options.getString(OPTION_CHARSET_NAME, this.getCharsetName()));
        this.setShowVariableStorageInfo(options.getBoolean(OPTION_SHOW_VARIABLE_STORAGE_INFO, this.isShowVariableStorageInfo()));
    }
}

