/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.ReferencesFromTableModel;
import ghidra.util.table.field.ReferenceEndpoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

@Deprecated
public class XReferenceUtil {
    private static final Address[] EMPTY_ADDR_ARRAY = new Address[0];
    private static final Reference[] EMPTY_REF_ARRAY = new Reference[0];
    public static final int ALL_REFS = -1;

    public static final Address[] getXRefList(CodeUnit cu) {
        return XReferenceUtil.getXRefList(cu, -1);
    }

    public static final Address[] getXRefList(CodeUnit cu, int maxNumber) {
        Program prog = cu.getProgram();
        if (prog == null) {
            return EMPTY_ADDR_ARRAY;
        }
        ArrayList<Address> xrefList = new ArrayList<Address>();
        ReferenceIterator iter = prog.getReferenceManager().getReferencesTo(cu.getMinAddress());
        while (iter.hasNext()) {
            Reference ref = iter.next();
            xrefList.add(ref.getFromAddress());
            if (maxNumber <= 0 || xrefList.size() != maxNumber) continue;
            break;
        }
        Object[] arr = new Address[xrefList.size()];
        xrefList.toArray(arr);
        Arrays.sort(arr);
        return arr;
    }

    public static final Reference[] getXReferences(CodeUnit cu, int maxNumber) {
        Address[] thunkAddrs;
        Function func;
        Program prog = cu.getProgram();
        if (prog == null) {
            return EMPTY_REF_ARRAY;
        }
        ArrayList<Object> xrefList = new ArrayList<Object>();
        ReferenceIterator iter = prog.getReferenceManager().getReferencesTo(cu.getMinAddress());
        while (iter.hasNext()) {
            Reference ref = iter.next();
            xrefList.add(ref);
            if (maxNumber <= 0 || xrefList.size() != maxNumber) continue;
            break;
        }
        if ((func = prog.getFunctionManager().getFunctionAt(cu.getMinAddress())) != null && (thunkAddrs = func.getFunctionThunkAddresses()) != null) {
            for (Address thunkAddr : thunkAddrs) {
                xrefList.add(new ThunkReference(thunkAddr, func.getEntryPoint()));
            }
        }
        Reference[] arr = new Reference[xrefList.size()];
        xrefList.toArray(arr);
        return arr;
    }

    public static final Address[] getOffcutXRefList(CodeUnit cu) {
        return XReferenceUtil.getOffcutXRefList(cu, -1);
    }

    public static final Address[] getOffcutXRefList(CodeUnit cu, int maxXRefs) {
        Program prog = cu.getProgram();
        if (prog == null) {
            return EMPTY_ADDR_ARRAY;
        }
        ArrayList<Address> offcutList = new ArrayList<Address>();
        if (cu.getLength() > 1) {
            ReferenceManager refMgr = prog.getReferenceManager();
            AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
            AddressIterator iter = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
            block0: while (iter.hasNext()) {
                Address addr = iter.next();
                ReferenceIterator refIter = refMgr.getReferencesTo(addr);
                while (refIter.hasNext()) {
                    Reference ref = refIter.next();
                    offcutList.add(ref.getFromAddress());
                    if (maxXRefs <= 0 || offcutList.size() != maxXRefs) continue;
                    continue block0;
                }
            }
        }
        Object[] arr = new Address[offcutList.size()];
        offcutList.toArray(arr);
        Arrays.sort(arr);
        return arr;
    }

    public static final Reference[] getOffcutXReferences(CodeUnit cu, int maxXRefs) {
        Program prog = cu.getProgram();
        if (prog == null) {
            return EMPTY_REF_ARRAY;
        }
        ArrayList<Reference> offcutList = new ArrayList<Reference>();
        if (cu.getLength() > 1) {
            ReferenceManager refMgr = prog.getReferenceManager();
            AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
            AddressIterator iter = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
            block0: while (iter.hasNext()) {
                Address addr = iter.next();
                ReferenceIterator refIter = refMgr.getReferencesTo(addr);
                while (refIter.hasNext()) {
                    Reference ref = refIter.next();
                    offcutList.add(ref);
                    if (maxXRefs <= 0 || offcutList.size() != maxXRefs) continue;
                    continue block0;
                }
            }
        }
        Object[] arr = new Reference[offcutList.size()];
        offcutList.toArray(arr);
        Arrays.sort(arr);
        return arr;
    }

    public static int getOffcutXRefCount(CodeUnit cu) {
        Program prog = cu.getProgram();
        if (prog == null) {
            return 0;
        }
        int refCount = 0;
        if (cu.getLength() > 1) {
            ReferenceManager refMgr = prog.getReferenceManager();
            AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
            AddressIterator iter = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
            while (iter.hasNext()) {
                Address addr = iter.next();
                ReferenceIterator refIter = refMgr.getReferencesTo(addr);
                while (refIter.hasNext()) {
                    refIter.next();
                    ++refCount;
                }
            }
        }
        return refCount;
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts) {
        Reference[] vrefs;
        Address addr = var.getMinAddress();
        if (addr == null) {
            return;
        }
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        for (Reference vref : vrefs = refMgr.getReferencesTo(var)) {
            if (addr.equals((Object)vref.getToAddress())) {
                xrefs.add(vref);
                continue;
            }
            offcuts.add(vref);
        }
    }

    public static Set<Reference> getVariableRefs(Variable var) {
        Reference[] vrefs;
        HashSet<Reference> results = new HashSet<Reference>();
        Address addr = var.getMinAddress();
        if (addr == null) {
            return results;
        }
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        for (Reference vref : vrefs = refMgr.getReferencesTo(var)) {
            results.add(vref);
        }
        return results;
    }

    public static void showAllXrefs(Navigatable navigatable, ServiceProvider serviceProvider, TableService service, ProgramLocation location, Set<Reference> xrefs) {
        ReferencesFromTableModel model = new ReferencesFromTableModel(new ArrayList<Reference>(xrefs), serviceProvider, location.getProgram());
        TableComponentProvider<ReferenceEndpoint> provider = service.showTable("XRefs to " + location.getAddress().toString(), "XRefs", model, "XRefs", navigatable);
        provider.installRemoveItemsAction();
    }

    public static Set<Reference> getAllXrefs(ProgramLocation location) {
        Data cu = DataUtilities.getDataAtLocation((ProgramLocation)location);
        if (cu == null) {
            Address toAddress = location.getAddress();
            Listing listing = location.getProgram().getListing();
            cu = listing.getCodeUnitContaining(toAddress);
        }
        Object[] xrefs = XReferenceUtil.getXReferences((CodeUnit)cu, -1);
        Object[] offcuts = XReferenceUtil.getOffcutXReferences((CodeUnit)cu, -1);
        HashSet<Reference> set = new HashSet<Reference>();
        CollectionUtils.addAll(set, (Object[])xrefs);
        CollectionUtils.addAll(set, (Object[])offcuts);
        return set;
    }
}

