/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.app.plugin.core.string.StringEvent;
import ghidra.app.plugin.core.string.StringTableModel;
import ghidra.app.plugin.core.string.StringTableOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.util.string.FoundString;

public class StringAddedEvent
extends StringEvent {
    public StringAddedEvent(DataType stringDataType, Address address, int length) {
        super(stringDataType, address, length);
    }

    @Override
    public void process(StringTableModel model, StringTableOptions options) {
        FoundString newString = new FoundString(this.address, this.length, this.stringDataType);
        int row = model.getRowIndex(newString);
        FoundString existingString = null;
        if (row >= 0 && !(existingString = (FoundString)model.getRowObject(row)).getAddress().equals((Object)this.address)) {
            existingString = null;
        }
        if (existingString == null) {
            existingString = this.findRowSlowWay(model);
        }
        if (existingString == null) {
            if (options.includeDefinedStrings()) {
                newString.setDefinedState(FoundString.DefinedState.DEFINED);
                model.addObject(newString);
            }
            return;
        }
        this.updateMatch(existingString, newString);
        if (existingString.isDefined() && !options.includeDefinedStrings()) {
            model.removeObject(existingString);
        } else if (existingString.isPartiallyDefined() && !options.includePartiallyDefinedStrings()) {
            model.removeObject(existingString);
        } else {
            model.updateObject(existingString);
        }
    }

    private void updateMatch(FoundString existingString, FoundString newString) {
        Address newAddr;
        Address existingAddr = existingString.getAddress();
        if (existingAddr.equals((Object)(newAddr = newString.getAddress())) && existingString.getLength() <= newString.getLength()) {
            existingString.setDefinedState(FoundString.DefinedState.DEFINED);
            return;
        }
        Address existingEndAddr = existingString.getEndAddress();
        Address newEndAddr = newString.getEndAddress();
        Address minAddress = this.getMinAddress(existingAddr, newAddr);
        Address maxAddress = this.getMaxAddress(existingEndAddr, newEndAddr);
        this.length = (int)maxAddress.subtract(minAddress) + 1;
        existingString.setAddress(minAddress);
        existingString.setLength(this.length);
        existingString.setDefinedState(FoundString.DefinedState.PARTIALLY_DEFINED);
    }
}

