/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.framework.data.DomainFileProxy;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

public class ProgramLocator {
    private final DomainFile domainFile;
    private final URL ghidraURL;
    private final int version;
    private final boolean invalidContent;

    public ProgramLocator(URL url) {
        Objects.requireNonNull(url, "URL can't be null");
        if (!GhidraURL.isGhidraURL((URL)url)) {
            throw new IllegalArgumentException("unsupported protocol: " + url.getProtocol());
        }
        this.ghidraURL = GhidraURL.getNormalizedURL((URL)url);
        this.domainFile = null;
        this.version = -1;
        this.invalidContent = false;
    }

    public ProgramLocator(DomainFile domainFile) {
        this(domainFile, -1);
    }

    public ProgramLocator(DomainFile domainFile, int version) {
        this.version = version;
        this.invalidContent = !Program.class.isAssignableFrom(domainFile.getDomainObjectClass());
        DomainFile file = null;
        URL url = null;
        DomainFolder parent = domainFile.getParent();
        if (this.invalidContent || version != -1 || parent == null || parent.isInWritableProject()) {
            file = domainFile;
        } else {
            if (domainFile instanceof LinkedDomainFile) {
                LinkedDomainFile linkedFile = (LinkedDomainFile)domainFile;
                try {
                    domainFile = linkedFile.getLinkedFile();
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"Failed to resolve linked-file", (Throwable)e);
                }
            }
            if ((url = domainFile.getLocalProjectURL(null)) == null) {
                url = domainFile.getSharedProjectURL(null);
            }
        }
        this.domainFile = file;
        this.ghidraURL = url;
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public URL getURL() {
        return this.ghidraURL;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDomainFile() {
        return this.domainFile != null;
    }

    public boolean isURL() {
        return this.ghidraURL != null;
    }

    public boolean isValid() {
        return !this.invalidContent;
    }

    public boolean canReopen() {
        return !this.invalidContent && !(this.domainFile instanceof DomainFileProxy);
    }

    public String toString() {
        if (this.domainFile != null) {
            return this.domainFile.toString();
        }
        return this.ghidraURL.toString();
    }

    public int hashCode() {
        return Objects.hash(this.domainFile, this.ghidraURL, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramLocator other = (ProgramLocator)obj;
        return Objects.equals(this.domainFile, other.domainFile) && Objects.equals(this.ghidraURL, other.ghidraURL) && this.version == other.version;
    }
}

