/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.ActionContext;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.builder.ActionBuilder;
import docking.widgets.tab.GTabPanel;
import generic.theme.GIcon;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramVisibilityChangePluginEvent;
import ghidra.app.plugin.core.progmgr.ProgramTabActionContext;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectDisplayUtils;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;
import help.Help;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Open/close programs", description="This plugin provides actions for opening and closing multiple programs. A tab is displayed in the Code Browser when there is more than one open program", servicesRequired={ProgramManager.class, CodeViewerService.class}, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramVisibilityChangePluginEvent.class})
public class MultiTabPlugin
extends Plugin
implements DomainObjectListener,
OptionsChangeListener {
    private static final Icon TRANSIENT_ICON = new GIcon("icon.plugin.programmanager.transient");
    private static final Icon EMPTY8_ICON = new GIcon("icon.plugin.programmanager.empty.small");
    private static final String SHOW_TABS_ALWAYS = "Show Program Tabs Always";
    private final KeyStroke NEXT_TAB_KEYSTROKE = KeyStroke.getKeyStroke(120, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private final KeyStroke PREVIOUS_TAB_KEYSTROKE = KeyStroke.getKeyStroke(119, DockingUtils.CONTROL_KEY_MODIFIER_MASK);
    private GTabPanel<Program> tabPanel;
    private ProgramManager progService;
    private CodeViewerService cvService;
    private DockingAction goToProgramAction;
    private DockingAction goToLastActiveProgramAction;
    private Program lastActiveProgram;
    private Program currentProgram;
    private DockingAction goToNextProgramAction;
    private DockingAction goToPreviousProgramAction;
    private Timer selectHighlightedProgramTimer;

    public MultiTabPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Close Program", this.getName()).popupMenuPath(new String[]{"Close"})).helpLocation(new HelpLocation("ProgramManagerPlugin", "Close_Program"))).withContext(ProgramTabActionContext.class).onAction(c -> this.progService.closeProgram(c.getProgram(), false)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Close Other Programs", this.getName()).popupMenuPath(new String[]{"Close Others"})).helpLocation(new HelpLocation("ProgramManagerPlugin", "Close_Others"))).withContext(ProgramTabActionContext.class).onAction(c -> this.closeOtherPrograms(c.getProgram())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Close All Programs", this.getName()).popupMenuPath(new String[]{"Close All"})).helpLocation(new HelpLocation("ProgramManagerPlugin", "Close_All"))).withContext(ProgramTabActionContext.class).onAction(c -> this.progService.closeAllPrograms(false)).buildAndInstall((Tool)this.tool);
        String firstGroup = "1";
        String secondGroup = "2";
        this.goToProgramAction = new DockingAction("Go To Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.showProgramList();
            }
        };
        this.goToProgramAction.setMenuBarData(new MenuData(new String[]{"&Navigation", "Go To Program..."}, null, "GoToWindow", -1, firstGroup));
        this.goToProgramAction.setKeyBindingData(new KeyBindingData(118, 128));
        this.goToProgramAction.setEnabled(false);
        this.goToProgramAction.setDescription("Shows the program selection dialog with the current program selected");
        this.goToProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Program"));
        this.goToNextProgramAction = new DockingAction("Go To Next Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.cycleNextProgram(true);
            }
        };
        this.goToNextProgramAction.setEnabled(false);
        this.goToNextProgramAction.setDescription("Highlights the next program tab and then switches to that program");
        this.goToNextProgramAction.setKeyBindingData(new KeyBindingData(this.NEXT_TAB_KEYSTROKE));
        this.goToNextProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Next_And_Previous_Program"));
        this.goToPreviousProgramAction = new DockingAction("Go To Previous Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.cycleNextProgram(false);
            }
        };
        this.goToPreviousProgramAction.setEnabled(false);
        this.goToPreviousProgramAction.setKeyBindingData(new KeyBindingData(this.PREVIOUS_TAB_KEYSTROKE));
        this.goToPreviousProgramAction.setDescription("Highlights the previous program tab and then switches to that program");
        this.goToPreviousProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Next_And_Previous_Program"));
        this.selectHighlightedProgramTimer = new Timer(750, e -> this.selectHighlightedProgram());
        this.selectHighlightedProgramTimer.setRepeats(false);
        this.goToLastActiveProgramAction = new DockingAction("Go To Last Active Program", this.getName()){

            public void actionPerformed(ActionContext context) {
                MultiTabPlugin.this.switchToProgram(MultiTabPlugin.this.lastActiveProgram);
            }
        };
        this.goToLastActiveProgramAction.setMenuBarData(new MenuData(new String[]{"&Navigation", "Go To Last Active Program"}, null, "GoToWindow", -1, secondGroup));
        this.goToLastActiveProgramAction.setKeyBindingData(new KeyBindingData(117, 128));
        this.goToLastActiveProgramAction.setEnabled(false);
        this.goToLastActiveProgramAction.setDescription("Activates the last program used before the current program");
        this.goToLastActiveProgramAction.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Go_To_Last_Active_Program"));
        this.tool.addAction((DockingActionIf)this.goToProgramAction);
        this.tool.addAction((DockingActionIf)this.goToLastActiveProgramAction);
        this.tool.addAction((DockingActionIf)this.goToNextProgramAction);
        this.tool.addAction((DockingActionIf)this.goToPreviousProgramAction);
    }

    private void closeOtherPrograms(Program keepProgram) {
        this.progService.setCurrentProgram(keepProgram);
        this.progService.closeOtherPrograms(false);
    }

    private void updateActionEnablement() {
        boolean enable = this.tabPanel.getTabCount() > 1;
        this.goToProgramAction.setEnabled(enable);
        this.goToNextProgramAction.setEnabled(enable);
        this.goToPreviousProgramAction.setEnabled(enable);
        enable = this.lastActiveProgram != null;
        this.goToLastActiveProgramAction.setEnabled(enable);
    }

    private void switchToProgram(Program program) {
        if (this.lastActiveProgram != null) {
            this.tabPanel.selectTab((Object)this.lastActiveProgram);
        }
    }

    private void showProgramList() {
        this.tabPanel.showTabList(!this.tabPanel.isShowingTabList());
    }

    private void selectHighlightedProgram() {
        Program highlightedTabValue = (Program)this.tabPanel.getHighlightedTabValue();
        if (highlightedTabValue != null) {
            this.tabPanel.selectTab((Object)highlightedTabValue);
        }
    }

    private String getToolTip(Program program) {
        return DomainObjectDisplayUtils.getToolTip((DomainObject)program);
    }

    private String getTabName(Program program) {
        return DomainObjectDisplayUtils.getTabText((DomainObject)program);
    }

    void keyTypedFromListWindow(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        if (stroke.equals(this.NEXT_TAB_KEYSTROKE)) {
            this.cycleNextProgram(true);
        } else if (stroke.equals(this.PREVIOUS_TAB_KEYSTROKE)) {
            this.cycleNextProgram(false);
        }
    }

    private void cycleNextProgram(boolean forward) {
        this.tabPanel.highlightNextPreviousTab(forward);
        this.selectHighlightedProgramTimer.restart();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.getSource() instanceof Program) {
            Program program = (Program)ev.getSource();
            this.tabPanel.refreshTab((Object)program);
        }
    }

    protected void init() {
        this.tabPanel = new GTabPanel("Program");
        this.tabPanel.setNameFunction(p -> this.getTabName((Program)p));
        this.tabPanel.setIconFunction(p -> this.getIcon((Program)p));
        this.tabPanel.setToolTipFunction(p -> this.getToolTip((Program)p));
        this.tabPanel.setSelectedTabConsumer(p -> this.programSelected((Program)p));
        this.tabPanel.setCloseTabConsumer(p -> this.progService.closeProgram((Program)p, false));
        Help.getHelpService().registerHelp(this.tabPanel, new HelpLocation("ProgramManagerPlugin", "Navigate_File"));
        this.initOptions();
        this.progService = (ProgramManager)this.tool.getService(ProgramManager.class);
        this.cvService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        this.cvService.setNorthComponent((JComponent)this.tabPanel);
    }

    private void initOptions() {
        ToolOptions options = this.tool.getOptions("Tool");
        options.registerOption(SHOW_TABS_ALWAYS, (Object)false, null, "If true, program tabs will be displayed even if only one");
        this.tabPanel.setShowTabsAlways(options.getBoolean(SHOW_TABS_ALWAYS, false));
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        if (optionName.equals(SHOW_TABS_ALWAYS)) {
            this.tabPanel.setShowTabsAlways(((Boolean)newValue).booleanValue());
        }
    }

    private Icon getIcon(Program program) {
        ProjectLocator projectLocator = program.getDomainFile().getProjectLocator();
        if (projectLocator != null && projectLocator.isTransient()) {
            return TRANSIENT_ICON;
        }
        return EMPTY8_ICON;
    }

    boolean removeProgram(Program program) {
        return this.progService.closeProgram(program, false);
    }

    void programSelected(Program program) {
        if (program != this.progService.getCurrentProgram()) {
            this.progService.setCurrentProgram(program);
            this.cvService.requestFocus();
        }
    }

    private void add(Program prog) {
        if (this.progService.isVisible(prog)) {
            this.tabPanel.addTab((Object)prog);
            prog.removeListener((DomainObjectListener)this);
            prog.addListener((DomainObjectListener)this);
            this.updateActionEnablement();
        }
    }

    private void remove(Program prog) {
        prog.removeListener((DomainObjectListener)this);
        this.tabPanel.removeTab((Object)prog);
        this.updateActionEnablement();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            Program prog = ((ProgramOpenedPluginEvent)event).getProgram();
            this.add(prog);
        } else if (event instanceof ProgramClosedPluginEvent) {
            Program prog = ((ProgramClosedPluginEvent)event).getProgram();
            if (prog == this.lastActiveProgram) {
                this.lastActiveProgram = null;
            }
            if (prog == this.currentProgram) {
                this.currentProgram = null;
            }
            this.remove(prog);
        } else if (event instanceof ProgramActivatedPluginEvent) {
            Program prog = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.lastActiveProgram = this.currentProgram;
            this.currentProgram = prog;
            if (prog != null) {
                this.add(prog);
                if (this.tabPanel.getSelectedTabValue() != prog) {
                    this.tabPanel.selectTab((Object)prog);
                    this.updateActionEnablement();
                }
            }
        } else if (event instanceof ProgramVisibilityChangePluginEvent) {
            Program prog = ((ProgramVisibilityChangePluginEvent)event).getProgram();
            if (this.progService.isVisible(prog)) {
                this.add(prog);
                if (this.progService.getCurrentProgram() != prog) {
                    this.currentProgram = prog;
                    this.tabPanel.selectTab((Object)prog);
                    this.updateActionEnablement();
                }
            } else {
                this.remove(prog);
                this.add(prog);
            }
        }
    }

    protected void dispose() {
        this.selectHighlightedProgramTimer.stop();
        this.tabPanel.removeAll();
        this.cvService.setNorthComponent(null);
    }
}

