/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.action;

import ghidra.debug.api.action.LocationTracker;
import ghidra.debug.api.action.LocationTrackingSpecFactory;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.TraceAddressSnapRange;
import javax.swing.Icon;

public interface LocationTrackingSpec {
    public static boolean changeIsCurrent(AddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates current) {
        if (space == null) {
            return false;
        }
        if (!space.isMemorySpace() && !current.isRegisterSpace(space)) {
            return false;
        }
        return range.getLifespan().contains(current.getSnap());
    }

    public String getConfigName();

    public String getMenuName();

    public Icon getMenuIcon();

    public String computeTitle(DebuggerCoordinates var1);

    public String getLocationLabel();

    public LocationTracker getTracker();

    public static class TrackingSpecConfigFieldCodec
    implements AutoConfigState.ConfigFieldCodec<LocationTrackingSpec> {
        public LocationTrackingSpec read(SaveState state, String name, LocationTrackingSpec current) {
            String specName = state.getString(name, null);
            return LocationTrackingSpecFactory.fromConfigName(specName);
        }

        public void write(SaveState state, String name, LocationTrackingSpec value) {
            state.putString(name, value.getConfigName());
        }
    }
}

