/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.bookmark;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkOperations;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.util.TraceRegisterUtils;

public interface TraceBookmarkSpace
extends TraceBookmarkOperations {
    public Trace getTrace();

    public AddressSpace getAddressSpace();

    default public TraceBookmark addBookmark(Lifespan lifespan, Register register, TraceBookmarkType type, String category, String comment) {
        TracePlatform host = this.getTrace().getPlatformManager().getHostPlatform();
        AddressRange range = host.getConventionalRegisterRange(this.getAddressSpace(), register);
        return this.addBookmark(lifespan, range.getMinAddress(), type, category, comment);
    }

    default public Iterable<? extends TraceBookmark> getBookmarksEnclosed(Lifespan lifespan, Register register) {
        return this.getBookmarksEnclosed(lifespan, TraceRegisterUtils.rangeForRegister(register));
    }

    default public Iterable<? extends TraceBookmark> getBookmarksIntersecting(Lifespan lifespan, Register register) {
        return this.getBookmarksIntersecting(lifespan, TraceRegisterUtils.rangeForRegister(register));
    }
}

