/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SpecialAddress;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractDBTraceSymbol
extends DBAnnotatedObject
implements TraceSymbol,
DBTraceOverlaySpaceAdapter.DecodesAddresses {
    private static final byte SOURCE_MASK = 15;
    private static final int SOURCE_SHIFT = 0;
    private static final byte SOURCE_CLEAR = -16;
    private static final byte PRIMARY_MASK = 16;
    private static final int PRIMARY_CLEAR = -17;
    static final String NAME_COLUMN_NAME = "Name";
    static final String PARENT_COLUMN_NAME = "Parent";
    static final String FLAGS_COLUMN_NAME = "Flags";
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedColumn(value="Parent")
    static DBObjectColumn PARENT_COLUMN;
    @DBAnnotatedColumn(value="Flags")
    static DBObjectColumn FLAGS_COLUMN;
    @DBAnnotatedField(column="Name", indexed=true)
    String name;
    @DBAnnotatedField(column="Parent", indexed=true)
    long parentID;
    @DBAnnotatedField(column="Flags")
    byte flags;
    protected DBTraceNamespaceSymbol parent;
    protected final DBTraceSymbolManager manager;

    public AbstractDBTraceSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractDBTraceSymbol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractDBTraceSymbol that = (AbstractDBTraceSymbol)obj;
        if (this.getID() == that.getID()) {
            return true;
        }
        if (this.getSymbolType() != that.getSymbolType()) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!this.getAddress().equals((Object)that.getAddress())) {
            return false;
        }
        return Objects.equals(this.getParentSymbol(), that.getParentSymbol());
    }

    public int hashCode() {
        return Long.hashCode(this.getID());
    }

    public String toString() {
        return this.name;
    }

    protected void assertNotGlobal() {
        if (this.isGlobal()) {
            throw new UnsupportedOperationException("Cannot modify the global namespace");
        }
    }

    protected DBTraceNamespaceSymbol assertIsNamespace(AbstractDBTraceSymbol symbol) {
        assert (symbol != null);
        if (!(symbol instanceof DBTraceNamespaceSymbol)) {
            throw new AssertionError((Object)"Trace database corrupted. Symbol has a non-namespace parent.");
        }
        return (DBTraceNamespaceSymbol)symbol;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            return;
        }
        this.parent = this.parentID == -1L ? null : this.assertIsNamespace(this.manager.getSymbolByID(this.parentID));
    }

    @Override
    public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
        return this.manager.overlayAdapter;
    }

    @Override
    public DBTrace getTrace() {
        return this.manager.trace;
    }

    @Override
    public TraceThread getThread() {
        return null;
    }

    protected AddressSpace getAddressSpace() {
        return this.getAddress().getAddressSpace();
    }

    public long getID() {
        if (this.isGlobal()) {
            return 0L;
        }
        return DBTraceSymbolManager.packID(this.getSymbolType().getID(), this.getKey());
    }

    public String getName() {
        return this.name;
    }

    public Address getAddress() {
        return SpecialAddress.NO_ADDRESS;
    }

    protected Iterable<? extends TraceAddressSnapRange> getRanges() {
        return () -> this.manager.idMap.getActiveSpaces().stream().flatMap(space -> space.getUserIndex(Long.TYPE, DBTraceSymbolManager.DBTraceSymbolIDEntry.ID_COLUMN).get((Object)this.getID()).stream()).map(ent -> ent.getShape()).iterator();
    }

    public Lifespan getLifespan() {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (TraceAddressSnapRange traceAddressSnapRange : this.getRanges()) {
            min = Math.min(min, traceAddressSnapRange.getLifespan().lmin());
            max = Math.min(max, traceAddressSnapRange.getLifespan().lmax());
        }
        if (min > max) {
            return null;
        }
        return Lifespan.span(min, max);
    }

    protected void doCollectAddressSet(AddressSet set) {
        for (TraceAddressSnapRange traceAddressSnapRange : this.getRanges()) {
            set.add(traceAddressSnapRange.getRange());
        }
    }

    public AddressSet getAddressSet() {
        AddressSet result = new AddressSet();
        this.doCollectAddressSet(result);
        return result;
    }

    public String[] getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            this.checkIsValid();
            if (this.isGlobal()) {
                String[] stringArray = new String[]{this.getName()};
                return stringArray;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (this.parent != this.manager.globalNamespace) {
                this.parent.doGetPath(list);
            }
            list.add(this.getName());
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
    }

    public String getName(boolean includeNamespace) {
        if (!includeNamespace) {
            return this.getName();
        }
        return StringUtils.join((Object[])this.getPath(), (String)"::");
    }

    @Override
    public DBTraceNamespaceSymbol getParentNamespace() {
        return this.parent;
    }

    @Override
    public DBTraceNamespaceSymbol getParentSymbol() {
        return this.parent;
    }

    public boolean isDescendant(Namespace namespace) {
        AbstractDBTraceSymbol s = this;
        while (s != null) {
            if (s == namespace) {
                return true;
            }
            s = s.parent;
        }
        return false;
    }

    public Collection<? extends DBTraceReference> getReferenceCollection() {
        return this.manager.trace.getReferenceManager().getReferencesBySymbolId(this.getID());
    }

    public int getReferenceCount() {
        return this.getReferenceCollection().size();
    }

    public boolean hasReferences() {
        return !this.getReferenceCollection().isEmpty();
    }

    public DBTraceReference[] getReferences(TaskMonitor monitor) {
        Collection<? extends DBTraceReference> refs = this.getReferenceCollection();
        DBTraceReference[] result = new DBTraceReference[refs.size()];
        int i = 0;
        for (DBTraceReference dBTraceReference : refs) {
            result[i++] = dBTraceReference;
            if (!monitor.isCancelled()) continue;
            break;
        }
        return result;
    }

    public DBTraceReference[] getReferences() {
        return this.getReferences(TaskMonitor.DUMMY);
    }

    void rawSet(String name, long parentID) {
        this.name = name;
        this.parentID = parentID;
        this.update(NAME_COLUMN, PARENT_COLUMN);
    }

    protected void set(String name, DBTraceNamespaceSymbol parent, SourceType source) {
        this.name = name;
        this.parentID = parent.getID();
        this.doSetSource(source);
        this.update(NAME_COLUMN, PARENT_COLUMN, FLAGS_COLUMN);
        this.parent = parent;
    }

    protected TraceChangeRecord<?, ?> doSetNameWithEvent(String newName) throws InvalidInputException {
        String oldName = this.name;
        if (oldName.equals(newName)) {
            return null;
        }
        this.name = newName;
        return new TraceChangeRecord<AbstractDBTraceSymbol, String>(TraceEvents.SYMBOL_RENAMED, this.getAddressSpace(), this, oldName, newName);
    }

    protected TraceChangeRecord<?, ?> doSetParent(DBTraceNamespaceSymbol newParent) throws CircularDependencyException {
        DBTraceNamespaceSymbol checkedParent;
        DBTraceNamespaceSymbol oldParent = this.parent;
        if (oldParent == newParent) {
            return null;
        }
        if (!this.isValidParent(newParent)) {
            throw new IllegalArgumentException("This symbol type cannot be a child of the given namespace type");
        }
        this.parent = checkedParent = this.checkCircular(newParent);
        this.parentID = this.parent.getID();
        return new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceNamespaceSymbol>(TraceEvents.SYMBOL_PARENT_CHANGED, this.getAddressSpace(), this, oldParent, checkedParent);
    }

    protected void doSetSource(SourceType newSource) {
        this.flags = (byte)(this.flags & 0xFFFFFFF0 | (newSource.ordinal() & 0xF) << 0);
    }

    protected TraceChangeRecord<?, ?> doSetSourceWithEvent(SourceType newSource) {
        SourceType oldSource = this.getSource();
        if (oldSource == newSource) {
            return null;
        }
        this.doSetSource(newSource);
        return new TraceChangeRecord<AbstractDBTraceSymbol, SourceType>(TraceEvents.SYMBOL_SOURCE_CHANGED, this.getAddressSpace(), this, oldSource, newSource);
    }

    public boolean isValidParent(Namespace ns) {
        DBTraceNamespaceSymbol dbns = this.manager.checkIsMine(ns);
        if (dbns == null) {
            return false;
        }
        return DBTraceSymbolManager.MySymbolTypes.VALUES.get(this.getSymbolType().getID()).isValidParent(dbns);
    }

    protected DBTraceNamespaceSymbol checkCircular(DBTraceNamespaceSymbol newParent) throws CircularDependencyException {
        return newParent;
    }

    protected Pair<String, SourceType> validateNameAndSource(String newName, SourceType newSource) throws InvalidInputException {
        if (newSource == SourceType.DEFAULT ^ this.getSource() == SourceType.DEFAULT) {
            throw new IllegalArgumentException("Cannot create or remove DEFAULT symbols");
        }
        DBTraceSymbolManager.assertValidName(newName);
        return new ImmutablePair((Object)newName, (Object)newSource);
    }

    public void setName(String newName, SourceType newSource) throws DuplicateNameException, InvalidInputException {
        this.assertNotGlobal();
        Pair<String, SourceType> validated = this.validateNameAndSource(newName, newSource);
        newName = (String)validated.getLeft();
        newSource = (SourceType)validated.getRight();
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            TraceChangeRecord<?, ?> nameEvent = this.doSetNameWithEvent(newName);
            TraceChangeRecord<?, ?> sourceEvent = this.doSetSourceWithEvent(newSource);
            if (nameEvent != null || sourceEvent != null) {
                this.update(NAME_COLUMN, FLAGS_COLUMN);
            }
            if (nameEvent != null) {
                this.manager.trace.setChanged(nameEvent);
            }
            if (sourceEvent != null) {
                this.manager.trace.setChanged(sourceEvent);
            }
        }
    }

    protected void validateNameAndParent(String newName, DBTraceNamespaceSymbol newParent) throws DuplicateNameException {
        this.manager.assertNotDuplicate(this, newName, newParent);
    }

    public void setNamespace(Namespace newNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.assertNotGlobal();
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(newNamespace);
            this.validateNameAndParent(this.getName(), dbnsParent);
            TraceChangeRecord<?, ?> parentEvent = this.doSetParent(dbnsParent);
            if (parentEvent != null) {
                this.update(PARENT_COLUMN);
                this.manager.trace.setChanged(parentEvent);
            }
        }
    }

    public void setNameAndNamespace(String newName, Namespace newNamespace, SourceType newSource) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.assertNotGlobal();
        Pair<String, SourceType> validated = this.validateNameAndSource(newName, newSource);
        newName = (String)validated.getLeft();
        newSource = (SourceType)validated.getRight();
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            TraceChangeRecord<?, ?> parentEvent = this.doSetParent(this.manager.assertIsMine(newNamespace));
            TraceChangeRecord<?, ?> nameEvent = this.doSetNameWithEvent(newName);
            TraceChangeRecord<?, ?> sourceEvent = this.doSetSourceWithEvent(newSource);
            if (parentEvent != null || nameEvent != null || sourceEvent != null) {
                this.update(NAME_COLUMN, PARENT_COLUMN, FLAGS_COLUMN);
            }
            if (parentEvent != null) {
                this.manager.trace.setChanged(parentEvent);
            }
            if (nameEvent != null) {
                this.manager.trace.setChanged(nameEvent);
            }
            if (sourceEvent != null) {
                this.manager.trace.setChanged(sourceEvent);
            }
        }
    }

    public void setSource(SourceType newSource) {
        this.assertNotGlobal();
        try {
            Pair<String, SourceType> validated = this.validateNameAndSource(this.getName(), newSource);
            newSource = (SourceType)validated.getRight();
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            TraceChangeRecord<?, ?> sourceEvent = this.doSetSourceWithEvent(newSource);
            if (sourceEvent != null) {
                this.update(FLAGS_COLUMN);
                this.manager.trace.setChanged(sourceEvent);
            }
        }
    }

    public SourceType getSource() {
        this.assertNotGlobal();
        return SourceType.values()[this.flags >> 0 & 0xF];
    }

    public boolean delete() {
        this.assertNotGlobal();
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            boolean bl = this.doDelete();
            return bl;
        }
    }

    protected boolean doDelete() {
        return this.manager.doDeleteSymbol(this);
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isGlobal() {
        return this.parentID == -1L;
    }

    public DBTraceProgramView getProgram() {
        return this.manager.trace.getProgramView();
    }

    public ProgramLocation getProgramLocation() {
        return new ProgramLocation((Program)this.getProgram(), this.getAddress());
    }

    @Override
    public boolean isPinned() {
        return false;
    }

    @Override
    public void setPinned(boolean pinned) {
    }

    public boolean isExternal() {
        return false;
    }
}

